/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.mware.ge.FetchHints;
import com.mware.ge.Graph;
import com.mware.ge.TextIndexHint;
import com.mware.ge.Vertex;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.query.GeoCompare;
import com.mware.ge.query.IterableWithTotalHits;
import com.mware.ge.query.Predicate;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.type.GeoCircle;
import com.mware.ge.type.GeoCollection;
import com.mware.ge.type.GeoHash;
import com.mware.ge.type.GeoLine;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoPolygon;
import com.mware.ge.type.GeoRect;
import com.mware.ge.type.GeoShape;
import com.mware.ge.util.GeAssert;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.GeoPointValue;
import com.mware.ge.values.storable.GeoShapeValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GraphGeoTests
implements GraphTestSetup {
    protected Graph graph;

    @Before
    public void before() throws Exception {
        this.graph = this.graphFactory().createGraph();
        GeAssert.clearGraphEvents();
        this.getGraph().addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                GeAssert.addGraphEvent((GraphEvent)graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().drop();
            this.getGraph().shutdown();
            this.graph = null;
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Test
    public void testStoreGeoPoint() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("location", (Value)Values.geoPointValue((double)38.9186, (double)-77.2297), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("location", (Value)Values.geoPointValue((double)38.9544, (double)-77.3464), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        List vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("location", (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)38.9186, (double)-77.2297, (double)1.0)).vertices());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        GeoPointValue geoPoint = (GeoPointValue)((Vertex)vertices.get(0)).getPropertyValue("location");
        GeAssert.assertEquals((double)38.9186, (double)geoPoint.getLatitude().doubleValue(), (double)0.001);
        GeAssert.assertEquals((double)-77.2297, (double)geoPoint.getLongitude().doubleValue(), (double)0.001);
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A_AND_B, "thing");
        v3.prepareMutation().setProperty("location", (Value)Values.geoPointValue((double)39.0299, (double)-77.5121), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("location", (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)39.0299, (double)-77.5121, (double)1.0)).vertices());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        geoPoint = (GeoPointValue)((Vertex)vertices.get(0)).getPropertyValue("location");
        GeAssert.assertEquals((double)39.0299, (double)geoPoint.getLatitude().doubleValue(), (double)0.001);
        GeAssert.assertEquals((double)-77.5121, (double)geoPoint.getLongitude().doubleValue(), (double)0.001);
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("location", (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)38.9186, (double)-77.2297, (double)25.0)).vertices());
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("location", (Predicate)GeoCompare.WITHIN, (Value)Values.geoRectValue((GeoPoint)new GeoPoint(39.0, -78.0), (GeoPoint)new GeoPoint(38.0, -77.0))).vertices());
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("location", (Predicate)GeoCompare.WITHIN, (Value)Values.geoHashValue((GeoHash)new GeoHash(38.9186, -77.2297, 2))).vertices());
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)vertices));
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("location", (Predicate)GeoCompare.WITHIN, (Value)Values.geoHashValue((GeoHash)new GeoHash(38.9186, -77.2297, 3))).vertices());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testStoreGeoCircle() {
        Assume.assumeTrue((String)"GeoCircle storage and queries are not supported", (boolean)this.isAdvancedGeoQuerySupported());
        GeoCircle within = new GeoCircle(38.627, -90.1994, 100.0);
        GeoCircle contains = new GeoCircle(38.627, -90.1994, 800.0);
        GeoCircle intersects = new GeoCircle(38.627, -80.0, 500.0);
        GeoCircle disjoint = new GeoCircle(38.627, -70.0, 500.0);
        this.doALLGeoshapeTestQueries((GeoShape)intersects, (GeoShape)disjoint, (GeoShape)within, (GeoShape)contains);
    }

    @Test
    public void testStoreGeoRect() {
        Assume.assumeTrue((String)"GeoRect storage and queries are not supported", (boolean)this.isAdvancedGeoQuerySupported());
        GeoRect within = new GeoRect(new GeoPoint(39.52632, -91.35059), new GeoPoint(37.72767, -89.0482));
        GeoRect contains = new GeoRect(new GeoPoint(45.82157, -99.42435), new GeoPoint(31.43242, -80.97444));
        GeoRect intersects = new GeoRect(new GeoPoint(43.1236, -85.75962), new GeoPoint(34.13039, -74.24038));
        GeoRect disjoint = new GeoRect(new GeoPoint(43.1236, -75.75962), new GeoPoint(34.13039, -64.24038));
        this.doALLGeoshapeTestQueries((GeoShape)intersects, (GeoShape)disjoint, (GeoShape)within, (GeoShape)contains);
    }

    @Test
    public void testStoreGeoLine() {
        Assume.assumeTrue((String)"GeoLine storage and queries are not supported", (boolean)this.isAdvancedGeoQuerySupported());
        GeoLine within = new GeoLine(new GeoPoint(39.5, -90.1994), new GeoPoint(37.9, -90.1994));
        GeoLine contains = new GeoLine(new GeoPoint(35.0, -100.0), new GeoPoint(39.5, -80.0));
        GeoLine intersects = new GeoLine(new GeoPoint(38.67, -85.0), new GeoPoint(38.67, -80.0));
        GeoLine disjoint = new GeoLine(new GeoPoint(38.6, -74.0), new GeoPoint(38.6, -68.0));
        this.doALLGeoshapeTestQueries((GeoShape)intersects, (GeoShape)disjoint, (GeoShape)within, (GeoShape)contains);
    }

    @Test
    public void testStoreGeoPolygon() {
        Assume.assumeTrue((String)"GeoPolygon storage and queries are not supported", (boolean)this.isAdvancedGeoQuerySupported());
        GeoPolygon within = new GeoPolygon(Arrays.asList(new GeoPoint(39.4, -91.0), new GeoPoint(38.1, -91.0), new GeoPoint(38.627, -89.0), new GeoPoint(39.4, -91.0)));
        GeoPolygon contains = new GeoPolygon(Arrays.asList(new GeoPoint(50.0, -98.0), new GeoPoint(26.0, -98.0), new GeoPoint(38.627, -75.0), new GeoPoint(50.0, -98.0)));
        GeoPolygon intersects = new GeoPolygon(Arrays.asList(new GeoPoint(43.0, -86.0), new GeoPoint(34.0, -86.0), new GeoPoint(38.627, -74.0), new GeoPoint(43.0, -86.0)));
        GeoPolygon disjoint = new GeoPolygon(Arrays.asList(new GeoPoint(43.0, -75.0), new GeoPoint(34.0, -75.0), new GeoPoint(38.627, -65.0), new GeoPoint(43.0, -75.0)));
        within.addHole(Arrays.asList(new GeoPoint(39.0, -90.5), new GeoPoint(38.627, -89.5), new GeoPoint(38.5, -90.5), new GeoPoint(39.0, -90.5)));
        this.doALLGeoshapeTestQueries((GeoShape)intersects, (GeoShape)disjoint, (GeoShape)within, (GeoShape)contains);
    }

    @Test
    public void testStoreGeoCollection() {
        Assume.assumeTrue((String)"GeoCollection storage and queries are not supported", (boolean)this.isAdvancedGeoQuerySupported());
        GeoCollection within = new GeoCollection().addShape((GeoShape)new GeoCircle(38.627, -90.1994, 100.0));
        GeoCollection contains = new GeoCollection().addShape((GeoShape)new GeoCircle(38.627, -90.1994, 800.0));
        GeoCollection intersects = new GeoCollection().addShape((GeoShape)new GeoCircle(38.627, -80.0, 500.0));
        GeoCollection disjoint = new GeoCollection().addShape((GeoShape)new GeoCircle(38.627, -70.0, 500.0));
        within.addShape((GeoShape)new GeoPoint(38.627, -90.1994));
        this.doALLGeoshapeTestQueries((GeoShape)intersects, (GeoShape)disjoint, (GeoShape)within, (GeoShape)contains);
    }

    private void doALLGeoshapeTestQueries(GeoShape intersects, GeoShape disjoint, GeoShape within, GeoShape contains) {
        this.getGraph().defineProperty("location").dataType(GeoShapeValue.class).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("location", (Value)Values.geoShapeValue((GeoShape)intersects), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("location", (Value)Values.geoShapeValue((GeoShape)disjoint), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").setProperty("location", (Value)Values.geoShapeValue((GeoShape)within), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_A, "thing").setProperty("location", (Value)Values.geoShapeValue((GeoShape)contains), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeoCircle circle = new GeoCircle(38.627, -90.1994, 500.0);
        GeoRect rect = new GeoRect(new GeoPoint(43.1236, -95.959), new GeoPoint(34.1303, -84.4397));
        GeoPolygon triangle = new GeoPolygon(Arrays.asList(new GeoPoint(43.1236, -95.959), new GeoPoint(34.1303, -95.959), new GeoPoint(38.627, -84.4397), new GeoPoint(43.1236, -95.959)));
        GeoLine line = new GeoLine(Arrays.asList(new GeoPoint(34.1303, -95.959), new GeoPoint(43.1236, -84.4397), new GeoPoint(38.627, -84.4397)));
        GeoCollection collection = new GeoCollection().addShape((GeoShape)new GeoCircle(38.627, -90.1994, 250.0)).addShape((GeoShape)new GeoLine(new GeoPoint(39.5, -84.0), new GeoPoint(38.5, -84.0)));
        Arrays.asList(circle, rect, triangle, line, collection).forEach(searchArea -> {
            QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.INTERSECTS, (Value)Values.geoShapeValue((GeoShape)searchArea)).vertices();
            GeAssert.assertEquals((String)"Incorrect total hits match INTERSECTS for shape ", (long)3L, (long)vertices.getTotalHits());
            GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v3", "v4"});
            vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.DISJOINT, (Value)Values.geoShapeValue((GeoShape)searchArea)).vertices();
            GeAssert.assertEquals((String)"Incorrect total hits match DISJOINT for shape ", (long)1L, (long)vertices.getTotalHits());
            GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v2"});
            if (searchArea != line) {
                vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.WITHIN, (Value)Values.geoShapeValue((GeoShape)searchArea)).vertices();
                GeAssert.assertEquals((String)"Incorrect total hits match WITHIN for shape ", (long)1L, (long)vertices.getTotalHits());
                GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v3"});
                vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.CONTAINS, (Value)Values.geoShapeValue((GeoShape)searchArea)).vertices();
                if (intersects instanceof GeoLine) {
                    GeAssert.assertEquals((String)"Incorrect total hits match CONTAINS for shape ", (long)0L, (long)vertices.getTotalHits());
                } else {
                    GeAssert.assertEquals((String)"Incorrect total hits match CONTAINS for shape ", (long)1L, (long)vertices.getTotalHits());
                    GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v4"});
                }
            }
        });
        triangle.addHole(Arrays.asList(new GeoPoint(40.0, -92.5), new GeoPoint(40.0, -88.5), new GeoPoint(37.4, -88.5), new GeoPoint(37.4, -92.5), new GeoPoint(40.0, -92.5)));
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.INTERSECTS, (Value)Values.geoShapeValue((GeoShape)triangle)).vertices();
        GeAssert.assertEquals((String)"Incorrect total hits match INTERSECTS for polygon with hole", (long)2L, (long)vertices.getTotalHits());
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v4"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.DISJOINT, (Value)Values.geoShapeValue((GeoShape)triangle)).vertices();
        GeAssert.assertEquals((String)"Incorrect total hits match DISJOINT for polygon with hole", (long)2L, (long)vertices.getTotalHits());
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v2", "v3"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.WITHIN, (Value)Values.geoShapeValue((GeoShape)triangle)).vertices();
        GeAssert.assertEquals((String)"Incorrect total hits match WITHIN for polygon with hole", (long)0L, (long)vertices.getTotalHits());
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.CONTAINS, (Value)Values.geoShapeValue((GeoShape)triangle)).vertices();
        if (intersects instanceof GeoLine) {
            GeAssert.assertEquals((String)"Incorrect total hits match CONTAINS for polygon with hole", (long)0L, (long)vertices.getTotalHits());
        } else {
            GeAssert.assertEquals((String)"Incorrect total hits match CONTAINS for polygon with hole", (long)1L, (long)vertices.getTotalHits());
            GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v4"});
        }
    }

    @Test
    public void testGeoLocationsWithDifferentKeys() {
        this.getGraph().defineProperty("prop1").dataType(GeoPointValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("key1", "prop1", (Value)Values.geoPointValue((double)38.9186, (double)-77.2297), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)38.9186, (double)-77.2297, (double)1.0)).vertices();
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        Vertex v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        v1.prepareMutation().addPropertyValue("key2", "prop1", (Value)Values.geoPointValue((double)38.627, (double)-90.1994), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)38.9186, (double)-77.2297, (double)1.0)).vertices();
        if (this.multivalueGeopointQueryWithinMeansAny()) {
            GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)vertices);
        } else {
            GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        }
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Predicate)GeoCompare.INTERSECTS, (Value)Values.geoCircleValue((double)38.9186, (double)-77.2297, (double)1.0)).vertices();
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)38.627, (double)-90.1994, (double)1.0)).vertices();
        if (this.multivalueGeopointQueryWithinMeansAny()) {
            GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)vertices);
        } else {
            GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        }
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Predicate)GeoCompare.INTERSECTS, (Value)Values.geoCircleValue((double)38.627, (double)-90.1994, (double)1.0)).vertices();
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
    }

    @Test
    public void testDeleteGeoLocationProperty() {
        this.getGraph().defineProperty("prop1").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().defineProperty("prop2").dataType(GeoPointValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("key1", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addPropertyValue("key1", "prop2", (Value)Values.geoPointValue((double)38.9186, (double)-77.2297), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        v1.prepareMutation().deleteProperties("key1", "prop1").deleteProperties("key1", "prop2").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Value)Values.stringValue((String)"value1")).vertices();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("prop2", (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)38.9186, (double)-77.2297, (double)1.0)).vertices();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)vertices);
        QueryResultsIterable vertexIds = this.getGraph().query(AUTHORIZATIONS_A).has("prop2", (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)38.9186, (double)-77.2297, (double)1.0)).vertexIds();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)vertexIds);
    }

    protected boolean isAdvancedGeoQuerySupported() {
        return true;
    }

    protected boolean multivalueGeopointQueryWithinMeansAny() {
        return true;
    }
}

