/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.mware.ge.Edge;
import com.mware.ge.FindPathOptions;
import com.mware.ge.Graph;
import com.mware.ge.Path;
import com.mware.ge.RelatedEdgeImpl;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.util.GeAssert;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IterableUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GraphFindPathAndRelatedTests
implements GraphTestSetup {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(GraphFindPathAndRelatedTests.class);
    protected Graph graph;

    @Before
    public void before() throws Exception {
        this.graph = this.graphFactory().createGraph();
        GeAssert.clearGraphEvents();
        this.getGraph().addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                GeAssert.addGraphEvent((GraphEvent)graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().drop();
            this.getGraph().shutdown();
            this.graph = null;
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Test
    public void testFindPaths() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v4 = this.getGraph().addVertex("v4", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v5 = this.getGraph().addVertex("v5", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v6 = this.getGraph().addVertex("v6", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge(v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v2, v4, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v1, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v3, v4, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v3, v5, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v4, v6, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        Set paths = IterableUtils.toSet((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v2", 2), AUTHORIZATIONS_A));
        Set pathsByLabels = IterableUtils.toSet((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v2", 2).setLabels(new String[]{"label1"}), AUTHORIZATIONS_A));
        GeAssert.assertEquals((Object)pathsByLabels, (Object)paths);
        Set pathsByBadLabel = IterableUtils.toSet((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v2", 2).setLabels(new String[]{"bad"}), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)0L, (long)pathsByBadLabel.size());
        this.assertPaths(paths, new Path(new String[]{"v1", "v2"}));
        paths = IterableUtils.toSet((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v4", 2), AUTHORIZATIONS_A));
        pathsByLabels = IterableUtils.toSet((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v4", 2).setLabels(new String[]{"label1"}), AUTHORIZATIONS_A));
        GeAssert.assertEquals((Object)pathsByLabels, (Object)paths);
        pathsByBadLabel = IterableUtils.toSet((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v4", 2).setLabels(new String[]{"bad"}), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)0L, (long)pathsByBadLabel.size());
        this.assertPaths(paths, new Path(new String[]{"v1", "v2", "v4"}), new Path(new String[]{"v1", "v3", "v4"}));
        paths = IterableUtils.toSet((Iterable)this.getGraph().findPaths(new FindPathOptions("v4", "v1", 2), AUTHORIZATIONS_A));
        pathsByLabels = IterableUtils.toSet((Iterable)this.getGraph().findPaths(new FindPathOptions("v4", "v1", 2).setLabels(new String[]{"label1"}), AUTHORIZATIONS_A));
        GeAssert.assertEquals((Object)pathsByLabels, (Object)paths);
        pathsByBadLabel = IterableUtils.toSet((Iterable)this.getGraph().findPaths(new FindPathOptions("v4", "v1", 2).setLabels(new String[]{"bad"}), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)0L, (long)pathsByBadLabel.size());
        this.assertPaths(paths, new Path(new String[]{"v4", "v2", "v1"}), new Path(new String[]{"v4", "v3", "v1"}));
        paths = IterableUtils.toSet((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v6", 3), AUTHORIZATIONS_A));
        pathsByLabels = IterableUtils.toSet((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v6", 3).setLabels(new String[]{"label1"}), AUTHORIZATIONS_A));
        GeAssert.assertEquals((Object)pathsByLabels, (Object)paths);
        pathsByBadLabel = IterableUtils.toSet((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v6", 3).setLabels(new String[]{"bad"}), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)0L, (long)pathsByBadLabel.size());
        this.assertPaths(paths, new Path(new String[]{"v1", "v2", "v4", "v6"}), new Path(new String[]{"v1", "v3", "v4", "v6"}));
    }

    @Test
    public void testFindPathExcludeLabels() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v4 = this.getGraph().addVertex("v4", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge(v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v2, v4, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v1, v3, "label2", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v3, v4, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.assertPaths(this.getGraph().findPaths(new FindPathOptions("v1", "v4", 2), AUTHORIZATIONS_A), new Path(new String[]{"v1", "v2", "v4"}), new Path(new String[]{"v1", "v3", "v4"}));
        this.assertPaths(this.getGraph().findPaths(new FindPathOptions("v1", "v4", 2).setExcludedLabels(new String[]{"label2"}), AUTHORIZATIONS_A), new Path(new String[]{"v1", "v2", "v4"}));
        this.assertPaths(this.getGraph().findPaths(new FindPathOptions("v1", "v4", 3).setExcludedLabels(new String[]{"label2"}), AUTHORIZATIONS_A), new Path(new String[]{"v1", "v2", "v4"}));
    }

    private void assertPaths(Iterable<Path> found, Path ... expected) {
        List foundPaths = IterableUtils.toList(found);
        ArrayList expectedPaths = new ArrayList();
        Collections.addAll(expectedPaths, expected);
        GeAssert.assertEquals((long)expectedPaths.size(), (long)foundPaths.size());
        for (Path foundPath : foundPaths) {
            if (expectedPaths.remove(foundPath)) continue;
            GeAssert.fail((String)("Unexpected path: " + foundPath));
        }
    }

    @Test
    public void testFindPathsWithSoftDeletedEdges() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_EMPTY, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_EMPTY, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_EMPTY, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge(v1, v2, "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A);
        Edge v2ToV3 = this.getGraph().addEdge(v2, v3, "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A);
        this.getGraph().flush();
        List paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 2), AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path(new String[]{"v1", "v2", "v3"}));
        this.getGraph().softDeleteEdge(v2ToV3, AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertNull((Object)this.getGraph().getEdge(v2ToV3.getId(), AUTHORIZATIONS_A));
        paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 2), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)0L, (long)paths.size());
    }

    @Test
    public void testFindPathsWithHiddenEdges() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_EMPTY, AUTHORIZATIONS_A_AND_B, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_EMPTY, AUTHORIZATIONS_A_AND_B, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_EMPTY, AUTHORIZATIONS_A_AND_B, "thing");
        this.getGraph().addEdge(v1, v2, "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A_AND_B);
        Edge v2ToV3 = this.getGraph().addEdge(v2, v3, "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        List paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 2), AUTHORIZATIONS_A_AND_B));
        this.assertPaths(paths, new Path(new String[]{"v1", "v2", "v3"}));
        this.getGraph().markEdgeHidden(v2ToV3, VISIBILITY_A, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertNull((Object)this.getGraph().getEdge(v2ToV3.getId(), AUTHORIZATIONS_A_AND_B));
        paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 2), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)0L, (long)paths.size());
        paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 2), AUTHORIZATIONS_B));
        GeAssert.assertEquals((long)1L, (long)paths.size());
    }

    @Test
    public void testFindPathsMultiplePaths() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v4 = this.getGraph().addVertex("v4", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v5 = this.getGraph().addVertex("v5", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge(v1, v4, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v1, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v3, v4, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v2, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v4, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v2, v5, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        List paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v2", 2), AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path(new String[]{"v1", "v4", "v2"}), new Path(new String[]{"v1", "v3", "v2"}));
        paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v2", 3), AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path(new String[]{"v1", "v4", "v2"}), new Path(new String[]{"v1", "v3", "v2"}), new Path(new String[]{"v1", "v3", "v4", "v2"}), new Path(new String[]{"v1", "v4", "v3", "v2"}));
        paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v5", 2), AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path[0]);
        paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v5", 3), AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path(new String[]{"v1", "v4", "v2", "v5"}), new Path(new String[]{"v1", "v3", "v2", "v5"}));
    }

    @Test
    public void testFindPathsWithDifferentVisibilityData() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_EMPTY, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_EMPTY, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_EMPTY, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("v1v2", v1, v2, "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A);
        this.getGraph().addEdge("v2v3", v2, v3, "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A);
        this.getGraph().addEdge("v3v1", v3, v1, "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A);
        this.getGraph().flush();
        List paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 2), AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path(new String[]{"v1", "v2", "v3"}), new Path(new String[]{"v1", "v3"}));
        this.getGraph().getEdge("v3v1", AUTHORIZATIONS_A).prepareMutation().alterElementVisibility(VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().getVertex("v2", AUTHORIZATIONS_A).prepareMutation().alterElementVisibility(VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 2), AUTHORIZATIONS_EMPTY));
        GeAssert.assertEquals((long)0L, (long)paths.size());
        paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 3), AUTHORIZATIONS_EMPTY));
        GeAssert.assertEquals((long)0L, (long)paths.size());
        paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 2), AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path(new String[]{"v1", "v2", "v3"}), new Path(new String[]{"v1", "v3"}));
        this.getGraph().getVertex("v2", AUTHORIZATIONS_A).prepareMutation().alterElementVisibility(Visibility.EMPTY).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v2", 4), AUTHORIZATIONS_EMPTY));
        this.assertPaths(paths, new Path(new String[]{"v1", "v2"}));
    }

    @Test
    public void testHasPath() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v4 = this.getGraph().addVertex("v4", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v5 = this.getGraph().addVertex("v5", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge(v1, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v3, v4, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v2, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v4, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v2, v5, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        List paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v4", 2, true), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)1L, (long)paths.size());
        paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v4", 3, true), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)1L, (long)paths.size());
        paths = IterableUtils.toList((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v5", 2, true), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)0L, (long)paths.size());
    }

    @Test
    public void testFindRelatedEdges() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v4 = this.getGraph().addVertex("v4", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Edge ev1v2 = this.getGraph().addEdge("e v1->v2", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        Edge ev1v3 = this.getGraph().addEdge("e v1->v3", v1, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        Edge ev2v3 = this.getGraph().addEdge("e v2->v3", v2, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        Edge ev3v1 = this.getGraph().addEdge("e v3->v1", v3, v1, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e v3->v4", v3, v4, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        ArrayList<String> vertexIds = new ArrayList<String>();
        vertexIds.add("v1");
        vertexIds.add("v2");
        vertexIds.add("v3");
        List edgeIds = IterableUtils.toList((Iterable)this.getGraph().findRelatedEdgeIds(vertexIds, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)4L, (long)IterableUtils.count((Iterable)edgeIds));
        IterableUtils.assertContains((Object)ev1v2.getId(), (Iterable)edgeIds);
        IterableUtils.assertContains((Object)ev1v3.getId(), (Iterable)edgeIds);
        IterableUtils.assertContains((Object)ev2v3.getId(), (Iterable)edgeIds);
        IterableUtils.assertContains((Object)ev3v1.getId(), (Iterable)edgeIds);
    }

    @Test
    public void testFindRelatedEdgeIdsForVertices() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v4 = this.getGraph().addVertex("v4", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Edge ev1v2 = this.getGraph().addEdge("e v1->v2", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        Edge ev1v3 = this.getGraph().addEdge("e v1->v3", v1, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        Edge ev2v3 = this.getGraph().addEdge("e v2->v3", v2, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        Edge ev3v1 = this.getGraph().addEdge("e v3->v1", v3, v1, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e v3->v4", v3, v4, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        vertices.add(v1);
        vertices.add(v2);
        vertices.add(v3);
        List edgeIds = IterableUtils.toList((Iterable)this.getGraph().findRelatedEdgeIdsForVertices(vertices, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)4L, (long)IterableUtils.count((Iterable)edgeIds));
        IterableUtils.assertContains((Object)ev1v2.getId(), (Iterable)edgeIds);
        IterableUtils.assertContains((Object)ev1v3.getId(), (Iterable)edgeIds);
        IterableUtils.assertContains((Object)ev2v3.getId(), (Iterable)edgeIds);
        IterableUtils.assertContains((Object)ev3v1.getId(), (Iterable)edgeIds);
    }

    @Test
    public void testFindRelatedEdgeSummary() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v4 = this.getGraph().addVertex("v4", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("e v1->v2", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e v1->v3", v1, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e v2->v3", v2, v3, "label2", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e v3->v1", v3, v1, "label2", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e v3->v4", v3, v4, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        ArrayList<String> vertexIds = new ArrayList<String>();
        vertexIds.add("v1");
        vertexIds.add("v2");
        vertexIds.add("v3");
        List relatedEdges = IterableUtils.toList((Iterable)this.getGraph().findRelatedEdgeSummary(vertexIds, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)4L, (long)relatedEdges.size());
        IterableUtils.assertContains((Object)new RelatedEdgeImpl("e v1->v2", "label1", v1.getId(), v2.getId()), (Iterable)relatedEdges);
        IterableUtils.assertContains((Object)new RelatedEdgeImpl("e v1->v3", "label1", v1.getId(), v3.getId()), (Iterable)relatedEdges);
        IterableUtils.assertContains((Object)new RelatedEdgeImpl("e v2->v3", "label2", v2.getId(), v3.getId()), (Iterable)relatedEdges);
        IterableUtils.assertContains((Object)new RelatedEdgeImpl("e v3->v1", "label2", v3.getId(), v1.getId()), (Iterable)relatedEdges);
    }

    @Test
    public void testFindRelatedEdgeSummaryAfterSoftDelete() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Edge e1 = this.getGraph().addEdge("e v1->v2", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        ArrayList<String> vertexIds = new ArrayList<String>();
        vertexIds.add("v1");
        vertexIds.add("v2");
        List relatedEdges = IterableUtils.toList((Iterable)this.getGraph().findRelatedEdgeSummary(vertexIds, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)1L, (long)relatedEdges.size());
        IterableUtils.assertContains((Object)new RelatedEdgeImpl("e v1->v2", "label1", v1.getId(), v2.getId()), (Iterable)relatedEdges);
        this.getGraph().softDeleteEdge(e1, AUTHORIZATIONS_A);
        this.getGraph().flush();
        relatedEdges = IterableUtils.toList((Iterable)this.getGraph().findRelatedEdgeSummary(vertexIds, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)0L, (long)relatedEdges.size());
    }

    @Test
    public void testFindRelatedEdgeSummaryAfterMarkedHidden() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Edge e1 = this.getGraph().addEdge("e v1->v2", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        ArrayList<String> vertexIds = new ArrayList<String>();
        vertexIds.add("v1");
        vertexIds.add("v2");
        List relatedEdges = IterableUtils.toList((Iterable)this.getGraph().findRelatedEdgeSummary(vertexIds, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)1L, (long)relatedEdges.size());
        IterableUtils.assertContains((Object)new RelatedEdgeImpl("e v1->v2", "label1", v1.getId(), v2.getId()), (Iterable)relatedEdges);
        this.getGraph().markEdgeHidden(e1, VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        relatedEdges = IterableUtils.toList((Iterable)this.getGraph().findRelatedEdgeSummary(vertexIds, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)0L, (long)relatedEdges.size());
    }
}

