/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgesSummary;
import com.mware.ge.FetchHints;
import com.mware.ge.Graph;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.util.GeAssert;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GraphFetchHintsTests
implements GraphTestSetup {
    protected Graph graph;

    @Before
    public void before() throws Exception {
        this.graph = this.graphFactory().createGraph();
        GeAssert.clearGraphEvents();
        this.getGraph().addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                GeAssert.addGraphEvent((GraphEvent)graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().drop();
            this.getGraph().shutdown();
            this.graph = null;
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Test
    public void testFetchHints() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        v1.addPropertyValue("k1", "n1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A, AUTHORIZATIONS_A);
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Edge e1 = this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        e1.addPropertyValue("k1", "n1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e2", v2, v1, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        Vertex v1_none = this.getGraph().getVertex("v1", FetchHints.NONE, AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)v1_none);
        GeAssert.assertThrowsException(() -> ((Vertex)v1_none).getProperties());
        GeAssert.assertThrowsException(() -> v1_none.getEdges(Direction.IN, AUTHORIZATIONS_A));
        GeAssert.assertThrowsException(() -> v1_none.getEdges(Direction.OUT, AUTHORIZATIONS_A));
        v1 = this.getGraph().getVertex("v1", this.getGraph().getDefaultFetchHints(), AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)v1);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.IN, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, AUTHORIZATIONS_A)));
        FetchHints propertiesFetchHints = FetchHints.builder().setIncludeAllProperties(true).build();
        Vertex v1_withProperties = this.getGraph().getVertex("v1", propertiesFetchHints, AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)v1_withProperties);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1_withProperties.getProperties()));
        GeAssert.assertThrowsException(() -> v1_withProperties.getEdges(Direction.IN, AUTHORIZATIONS_A));
        GeAssert.assertThrowsException(() -> v1_withProperties.getEdges(Direction.OUT, AUTHORIZATIONS_A));
        Vertex v1_withEdgeRegs = this.getGraph().getVertex("v1", FetchHints.EDGE_REFS, AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)v1_withEdgeRegs);
        GeAssert.assertThrowsException(() -> ((Vertex)v1_withEdgeRegs).getProperties());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1_withEdgeRegs.getEdges(Direction.IN, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1_withEdgeRegs.getEdges(Direction.OUT, AUTHORIZATIONS_A)));
        FetchHints inEdgeRefFetchHints = FetchHints.builder().setIncludeInEdgeRefs(true).build();
        Vertex v1_withInEdgeRegs = this.getGraph().getVertex("v1", inEdgeRefFetchHints, AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)v1_withInEdgeRegs);
        GeAssert.assertThrowsException(() -> ((Vertex)v1_withInEdgeRegs).getProperties());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1_withInEdgeRegs.getEdges(Direction.IN, AUTHORIZATIONS_A)));
        GeAssert.assertThrowsException(() -> v1_withInEdgeRegs.getEdges(Direction.OUT, AUTHORIZATIONS_A));
        FetchHints outEdgeRefFetchHints = FetchHints.builder().setIncludeOutEdgeRefs(true).build();
        Vertex v1_withOutEdgeRegs = this.getGraph().getVertex("v1", outEdgeRefFetchHints, AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)v1_withOutEdgeRegs);
        GeAssert.assertThrowsException(() -> ((Vertex)v1_withOutEdgeRegs).getProperties());
        GeAssert.assertThrowsException(() -> v1_withOutEdgeRegs.getEdges(Direction.IN, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1_withOutEdgeRegs.getEdges(Direction.OUT, AUTHORIZATIONS_A)));
        Edge e1_none = this.getGraph().getEdge("e1", FetchHints.NONE, AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)e1_none);
        GeAssert.assertThrowsException(() -> ((Edge)e1_none).getProperties());
        GeAssert.assertEquals((Object)"v1", (Object)e1_none.getVertexId(Direction.OUT));
        GeAssert.assertEquals((Object)"v2", (Object)e1_none.getVertexId(Direction.IN));
        Edge e1_default = this.getGraph().getEdge("e1", this.getGraph().getDefaultFetchHints(), AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)e1_default.getProperties()));
        GeAssert.assertEquals((Object)"v1", (Object)e1_default.getVertexId(Direction.OUT));
        GeAssert.assertEquals((Object)"v2", (Object)e1_default.getVertexId(Direction.IN));
        Edge e1_properties = this.getGraph().getEdge("e1", propertiesFetchHints, AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)e1_properties.getProperties()));
        GeAssert.assertEquals((Object)"v1", (Object)e1_properties.getVertexId(Direction.OUT));
        GeAssert.assertEquals((Object)"v2", (Object)e1_properties.getVertexId(Direction.IN));
    }

    @Test
    public void testFetchHintsProperties() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        v1.addPropertyValue("k1", "n1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A, AUTHORIZATIONS_A);
        v1.addPropertyValue("k1", "n2", (Value)Values.stringValue((String)"value2"), VISIBILITY_A, AUTHORIZATIONS_A);
        v1.addPropertyValue("k1", "n3", (Value)Values.stringValue((String)"value3"), VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        FetchHints specificPropertiesFetchHints = FetchHints.builder().setPropertyNamesToInclude(new String[]{"n1", "n3"}).build();
        Vertex v1WithoutN2 = this.getGraph().getVertex("v1", specificPropertiesFetchHints, AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1"), (Object)v1WithoutN2.getPropertyValue("n1"));
        GeAssert.assertThrowsException(() -> v1WithoutN2.getProperty("n1").getMetadata());
        GeAssert.assertThrowsException(() -> v1WithoutN2.getPropertyValue("n2"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value3"), (Object)v1WithoutN2.getPropertyValue("n3"));
        FetchHints noPropertiesFetchHints = FetchHints.NONE;
        Vertex v1WithNotProperties = this.getGraph().getVertex("v1", noPropertiesFetchHints, AUTHORIZATIONS_A);
        GeAssert.assertThrowsException(() -> ((Vertex)v1WithNotProperties).getProperties());
        GeAssert.assertThrowsException(() -> v1WithNotProperties.getProperty("n1"));
        FetchHints allPropertiesFetchHints = FetchHints.builder().setIncludeAllProperties(true).setPropertyNamesToInclude(new String[]{"n1", "n3"}).build();
        v1 = this.getGraph().getVertex("v1", allPropertiesFetchHints, AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1"), (Object)v1.getPropertyValue("n1"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2"), (Object)v1.getPropertyValue("n2"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value3"), (Object)v1.getPropertyValue("n3"));
    }

    @Test
    public void testFetchHintsPropertyMetadata() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Metadata metadata = Metadata.create();
        metadata.add("m1", (Value)Values.stringValue((String)"m1value"), VISIBILITY_A);
        metadata.add("m2", (Value)Values.stringValue((String)"m2value"), VISIBILITY_A);
        metadata.add("m3", (Value)Values.stringValue((String)"m3value"), VISIBILITY_A);
        v1.addPropertyValue("k1", "n1", (Value)Values.stringValue((String)"value1"), metadata, VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        FetchHints specificPropertiesFetchHints = FetchHints.builder().setMetadataKeysToInclude(new String[]{"m1", "m3"}).build();
        v1 = this.getGraph().getVertex("v1", specificPropertiesFetchHints, AUTHORIZATIONS_A);
        Metadata n1WithoutM2 = v1.getProperty("n1").getMetadata();
        GeAssert.assertEquals((Object)Values.stringValue((String)"m1value"), (Object)n1WithoutM2.getValue("m1"));
        GeAssert.assertThrowsException(() -> n1WithoutM2.getValue("m2"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"m3value"), (Object)n1WithoutM2.getValue("m3"));
        FetchHints noPropertiesFetchHints = FetchHints.builder().setIncludeAllProperties(true).build();
        Vertex v1_noMetadata = this.getGraph().getVertex("v1", noPropertiesFetchHints, AUTHORIZATIONS_A);
        GeAssert.assertThrowsException(() -> v1_noMetadata.getProperty("n1").getMetadata());
        FetchHints allPropertiesFetchHints = FetchHints.builder().setIncludeAllPropertyMetadata(true).setMetadataKeysToInclude(new String[]{"m1", "m3"}).build();
        Vertex v1_withMetadata = this.getGraph().getVertex("v1", allPropertiesFetchHints, AUTHORIZATIONS_A);
        Metadata n1 = v1_withMetadata.getProperty("n1").getMetadata();
        GeAssert.assertEquals((Object)Values.stringValue((String)"m1value"), (Object)n1.getValue("m1"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"m2value"), (Object)n1.getValue("m2"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"m3value"), (Object)n1.getValue("m3"));
    }

    @Test
    public void testFetchHintsEdges() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e2", v1, v2, "label2", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e3", v1, v2, "label3", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e4", v1, v2, "label3", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        FetchHints specificEdgeLabelFetchHints = FetchHints.builder().setEdgeLabelsOfEdgeRefsToInclude(new String[]{"label1", "label3"}).build();
        v1 = this.getGraph().getVertex("v1", specificEdgeLabelFetchHints, AUTHORIZATIONS_A);
        List edgeInfos = IterableUtils.toList((Iterable)v1.getEdgeInfos(Direction.BOTH, AUTHORIZATIONS_A));
        GeAssert.assertTrue((boolean)edgeInfos.stream().anyMatch(e -> e.getEdgeId().equals("e1")));
        GeAssert.assertFalse((boolean)edgeInfos.stream().anyMatch(e -> e.getEdgeId().equals("e2")));
        GeAssert.assertTrue((boolean)edgeInfos.stream().anyMatch(e -> e.getEdgeId().equals("e3")));
        GeAssert.assertTrue((boolean)edgeInfos.stream().anyMatch(e -> e.getEdgeId().equals("e4")));
        FetchHints noEdgeLabelsFetchHints = FetchHints.NONE;
        Vertex v1_noEdges = this.getGraph().getVertex("v1", noEdgeLabelsFetchHints, AUTHORIZATIONS_A);
        GeAssert.assertThrowsException(() -> v1_noEdges.getEdges(Direction.BOTH, AUTHORIZATIONS_A));
        GeAssert.assertThrowsException(() -> v1_noEdges.getEdgeInfos(Direction.BOTH, AUTHORIZATIONS_A));
        FetchHints edgeLabelsAndCountsFetchHints = FetchHints.builder().setIncludeEdgeLabelsAndCounts(true).build();
        Vertex v1_withEdgeLabelsAndCounts = this.getGraph().getVertex("v1", edgeLabelsAndCountsFetchHints, AUTHORIZATIONS_A);
        GeAssert.assertThrowsException(() -> v1_withEdgeLabelsAndCounts.getEdgeInfos(Direction.BOTH, AUTHORIZATIONS_A));
        GeAssert.assertEquals((Object)"label1,label2,label3", (Object)v1_withEdgeLabelsAndCounts.getEdgesSummary(AUTHORIZATIONS_A).getEdgeLabels().stream().sorted().collect(Collectors.joining(",")));
        FetchHints allEdgeInfoFetchHints = FetchHints.builder().setIncludeAllEdgeRefs(true).setEdgeLabelsOfEdgeRefsToInclude(new String[]{"m1", "m3"}).build();
        Vertex v1_withEdgeRefs = this.getGraph().getVertex("v1", allEdgeInfoFetchHints, AUTHORIZATIONS_A);
        edgeInfos = IterableUtils.toList((Iterable)v1_withEdgeRefs.getEdgeInfos(Direction.BOTH, AUTHORIZATIONS_A));
        GeAssert.assertTrue((boolean)edgeInfos.stream().anyMatch(e -> e.getEdgeId().equals("e1")));
        GeAssert.assertTrue((boolean)edgeInfos.stream().anyMatch(e -> e.getEdgeId().equals("e2")));
        GeAssert.assertTrue((boolean)edgeInfos.stream().anyMatch(e -> e.getEdgeId().equals("e3")));
        GeAssert.assertTrue((boolean)edgeInfos.stream().anyMatch(e -> e.getEdgeId().equals("e4")));
    }

    @Test
    public void testFetchHintsEdgeLabels() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().flush();
        this.getGraph().addEdge("e v1->v2", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().addEdge("e v1->v3", v1, v3, "label2", VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", FetchHints.EDGE_LABELS, AUTHORIZATIONS_ALL);
        List edgeLabels = IterableUtils.toList((Iterable)v1.getEdgesSummary(AUTHORIZATIONS_ALL).getEdgeLabels());
        GeAssert.assertEquals((long)2L, (long)edgeLabels.size());
        GeAssert.assertTrue((String)"label1 missing", (boolean)edgeLabels.contains("label1"));
        GeAssert.assertTrue((String)"label2 missing", (boolean)edgeLabels.contains("label2"));
    }

    @Test
    public void testFetchHintsEdgesSummary() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().flush();
        this.getGraph().addEdge("e v1->v2", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().addEdge("e v1->v3", v1, v3, "label2", VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", FetchHints.EDGE_LABELS, AUTHORIZATIONS_ALL);
        EdgesSummary summary = v1.getEdgesSummary(AUTHORIZATIONS_ALL);
        GeAssert.assertEquals((long)2L, (long)summary.getEdgeLabels().size());
        GeAssert.assertTrue((String)"label1 missing", (boolean)summary.getEdgeLabels().contains((Object)"label1"));
        GeAssert.assertTrue((String)"label2 missing", (boolean)summary.getEdgeLabels().contains((Object)"label2"));
        GeAssert.assertEquals((long)2L, (long)summary.getOutEdgeLabels().size());
        GeAssert.assertEquals((long)0L, (long)summary.getInEdgeLabels().size());
        GeAssert.assertEquals((long)1L, (long)((Integer)summary.getOutEdgeCountsByLabels().get((Object)"label1")).intValue());
        GeAssert.assertEquals((long)1L, (long)((Integer)summary.getOutEdgeCountsByLabels().get((Object)"label2")).intValue());
    }

    @Test
    public void testFetchHintsExceptions() {
        Metadata prop1Metadata = Metadata.create();
        prop1Metadata.add("metadata1", (Value)Values.stringValue((String)"metadata1Value"), VISIBILITY_A);
        prop1Metadata.add("metadata2", (Value)Values.stringValue((String)"metadata2Value"), VISIBILITY_A);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), prop1Metadata, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        FetchHints propertyFetchHints = FetchHints.builder().setPropertyNamesToInclude(new String[]{"prop2"}).build();
        Vertex v1WithOnlyProp2 = this.getGraph().getVertex("v1", propertyFetchHints, AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)v1WithOnlyProp2.getProperties());
        GeAssert.assertThrowsException(() -> v1WithOnlyProp2.getProperty("prop1"));
        FetchHints propertiesFetchHints = FetchHints.builder().setIncludeAllProperties(true).build();
        Vertex v1WithAllProperties = this.getGraph().getVertex("v1", propertiesFetchHints, AUTHORIZATIONS_A);
        GeAssert.assertThrowsException(() -> ((Property)v1WithAllProperties.getProperty("prop1")).getMetadata());
        FetchHints metadataFetchHints = FetchHints.builder().setIncludeAllProperties(true).setMetadataKeysToInclude(new String[]{"metadata1"}).build();
        Vertex v1WithOnlyMetadata1 = this.getGraph().getVertex("v1", metadataFetchHints, AUTHORIZATIONS_A);
        Property prop1 = v1WithOnlyMetadata1.getProperty("prop1");
        GeAssert.assertNotNull((Object)prop1.getMetadata());
        GeAssert.assertNotNull((Object)v1WithOnlyMetadata1.getProperty("prop1").getMetadata().getEntry("metadata1"));
        GeAssert.assertThrowsException(() -> v1WithOnlyMetadata1.getProperty("prop1").getMetadata().getEntry("metadata2"));
    }
}

