/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mware.ge.Authorizations;
import com.mware.ge.DefaultGraphVisitor;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ElementLocation;
import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.GraphVisitor;
import com.mware.ge.GraphWithSearchIndex;
import com.mware.ge.IdRange;
import com.mware.ge.Property;
import com.mware.ge.TextIndexHint;
import com.mware.ge.Vertex;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.event.DeleteExtendedDataEvent;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.mutation.ExistingVertexMutation;
import com.mware.ge.query.IterableWithTotalHits;
import com.mware.ge.query.Predicate;
import com.mware.ge.query.Query;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.QueryableIterable;
import com.mware.ge.query.SortDirection;
import com.mware.ge.query.TextPredicate;
import com.mware.ge.query.aggregations.Aggregation;
import com.mware.ge.query.aggregations.TermsAggregation;
import com.mware.ge.query.aggregations.TermsResult;
import com.mware.ge.search.SearchIndex;
import com.mware.ge.util.GeAssert;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.IntegralValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GraphExtendedDataTests
implements GraphTestSetup {
    protected Graph graph;

    @Before
    public void before() throws Exception {
        this.graph = this.graphFactory().createGraph();
        GeAssert.clearGraphEvents();
        this.getGraph().addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                GeAssert.addGraphEvent((GraphEvent)graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().drop();
            this.getGraph().shutdown();
            this.graph = null;
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Test
    public void testAddExtendedDataRows() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addExtendedData("table1", "row2", "name", (Value)Values.stringValue((String)"value2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        if (this.getGraph() instanceof GraphWithSearchIndex) {
            SearchIndex searchIndex = ((GraphWithSearchIndex)this.getGraph()).getSearchIndex();
            searchIndex.truncate(this.getGraph());
            searchIndex.flush(this.getGraph());
            ExistingVertexMutation mutation = this.getGraph().getVertex("v1", AUTHORIZATIONS_A).prepareMutation();
            Iterable extendedData = this.getGraph().getExtendedData(ElementType.VERTEX, "v1", "table1", AUTHORIZATIONS_A);
            searchIndex.addExtendedData(this.getGraph(), (ElementLocation)mutation, extendedData, AUTHORIZATIONS_A);
            this.getGraph().flush();
        }
        QueryResultsIterable rows = this.getGraph().query(AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)rows);
        rows = this.getGraph().query(AUTHORIZATIONS_A).has("name", (Value)Values.stringValue((String)"value1")).extendedDataRows();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)rows);
        ExtendedDataRow row = (ExtendedDataRow)IterableUtils.single((Iterable)rows);
        GeAssert.assertEquals((Object)"v1", (Object)row.getId().getElementId());
        GeAssert.assertEquals((Object)"table1", (Object)row.getId().getTableName());
        GeAssert.assertEquals((Object)"row1", (Object)row.getId().getRowId());
    }

    @Test
    public void testExtendedData() {
        DateTimeValue date1 = DateTimeValue.ofEpochMillis((IntegralValue)Values.longValue((long)1487083490000L));
        DateTimeValue date2 = DateTimeValue.ofEpochMillis((IntegralValue)Values.longValue((long)1487083480000L));
        DateTimeValue date3 = DateTimeValue.ofEpochMillis((IntegralValue)Values.longValue((long)1487083470000L));
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "date", (Value)date1, VISIBILITY_A).addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addExtendedData("table1", "row2", "date", (Value)date2, VISIBILITY_A).addExtendedData("table1", "row2", "name", (Value)Values.stringValue((String)"value2"), VISIBILITY_A).addExtendedData("table1", "row3", "date", (Value)date3, VISIBILITY_A).addExtendedData("table1", "row3", "name", (Value)Values.stringValue((String)"value3"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        final AtomicInteger rowCount = new AtomicInteger();
        final AtomicInteger rowPropertyCount = new AtomicInteger();
        this.getGraph().visitElements((GraphVisitor)new DefaultGraphVisitor(){

            public void visitExtendedDataRow(Element element, String tableName, ExtendedDataRow row) {
                rowCount.incrementAndGet();
            }

            public void visitProperty(Element element, String tableName, ExtendedDataRow row, Property property) {
                rowPropertyCount.incrementAndGet();
            }
        }, AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)3L, (long)rowCount.get());
        GeAssert.assertEquals((long)6L, (long)rowPropertyCount.get());
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)ImmutableSet.of((Object)"table1"), (Object)v1.getExtendedDataTableNames());
        Iterator rows = v1.getExtendedData("table1").iterator();
        ExtendedDataRow row = (ExtendedDataRow)rows.next();
        GeAssert.assertEquals((Object)date1, (Object)row.getPropertyValue("date"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1"), (Object)row.getPropertyValue("name"));
        row = (ExtendedDataRow)rows.next();
        GeAssert.assertEquals((Object)date2, (Object)row.getPropertyValue("date"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2"), (Object)row.getPropertyValue("name"));
        row = (ExtendedDataRow)rows.next();
        GeAssert.assertEquals((Object)date3, (Object)row.getPropertyValue("date"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value3"), (Object)row.getPropertyValue("name"));
        GeAssert.assertFalse((boolean)rows.hasNext());
        row = this.getGraph().getExtendedData(new ExtendedDataRowId(ElementType.VERTEX, "v1", "table1", "row1"), AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)"row1", (Object)row.getId().getRowId());
        GeAssert.assertEquals((Object)date1, (Object)row.getPropertyValue("date"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1"), (Object)row.getPropertyValue("name"));
        rows = this.getGraph().getExtendedData((Iterable)Lists.newArrayList((Object[])new ExtendedDataRowId[]{new ExtendedDataRowId(ElementType.VERTEX, "v1", "table1", "row1"), new ExtendedDataRowId(ElementType.VERTEX, "v1", "table1", "row2")}), AUTHORIZATIONS_A).iterator();
        row = (ExtendedDataRow)rows.next();
        GeAssert.assertEquals((Object)date1, (Object)row.getPropertyValue("date"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1"), (Object)row.getPropertyValue("name"));
        row = (ExtendedDataRow)rows.next();
        GeAssert.assertEquals((Object)date2, (Object)row.getPropertyValue("date"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2"), (Object)row.getPropertyValue("name"));
        GeAssert.assertFalse((boolean)rows.hasNext());
        rows = this.getGraph().getExtendedData(ElementType.VERTEX, "v1", "table1", AUTHORIZATIONS_A).iterator();
        row = (ExtendedDataRow)rows.next();
        GeAssert.assertEquals((Object)date1, (Object)row.getPropertyValue("date"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1"), (Object)row.getPropertyValue("name"));
        row = (ExtendedDataRow)rows.next();
        GeAssert.assertEquals((Object)date2, (Object)row.getPropertyValue("date"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2"), (Object)row.getPropertyValue("name"));
        row = (ExtendedDataRow)rows.next();
        GeAssert.assertEquals((Object)date3, (Object)row.getPropertyValue("date"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value3"), (Object)row.getPropertyValue("name"));
        GeAssert.assertFalse((boolean)rows.hasNext());
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        v1.prepareMutation().addExtendedData("table1", "row4", "name", (Value)Values.stringValue((String)"value4"), VISIBILITY_A).addExtendedData("table2", "row1", "name", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertTrue((String)"table1 should exist", (boolean)v1.getExtendedDataTableNames().contains((Object)"table1"));
        GeAssert.assertTrue((String)"table2 should exist", (boolean)v1.getExtendedDataTableNames().contains((Object)"table2"));
        List rowsList = IterableUtils.toList((Iterable)v1.getExtendedData("table1"));
        GeAssert.assertEquals((long)4L, (long)rowsList.size());
        rowsList = IterableUtils.toList((Iterable)v1.getExtendedData("table2"));
        GeAssert.assertEquals((long)1L, (long)rowsList.size());
        GeAssert.assertEquals((long)5L, (long)IterableUtils.count((Iterable)this.getGraph().getExtendedData(ElementType.VERTEX, "v1", null, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)5L, (long)IterableUtils.count((Iterable)this.getGraph().getExtendedData(ElementType.VERTEX, null, null, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)5L, (long)IterableUtils.count((Iterable)this.getGraph().getExtendedData((ElementType)null, null, null, AUTHORIZATIONS_A)));
        try {
            IterableUtils.count((Iterable)this.getGraph().getExtendedData(null, null, "table1", AUTHORIZATIONS_A));
            GeAssert.fail((String)"nulls to the left of a value is not allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IterableUtils.count((Iterable)this.getGraph().getExtendedData((ElementType)null, "v1", null, AUTHORIZATIONS_A));
            GeAssert.fail((String)"nulls to the left of a value is not allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testExtendedDataQuery() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addExtendedData("table1", "row2", "name", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addExtendedData("table2", "row3", "name", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").addExtendedData("table1", "row4", "name", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addExtendedData("table1", "row5", "name", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addExtendedData("table2", "row6", "name", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_A).addExtendedData("table1", "row7", "name", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable rows = this.getGraph().query(AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertRowIdsAnyOrder((Iterable)rows, (String[])new String[]{"row1", "row2", "row3", "row4", "row5", "row6", "row7"});
        rows = this.getGraph().query(AUTHORIZATIONS_A).has("__extendedDataRowId", (Value)Values.stringValue((String)"row1")).extendedDataRows();
        GeAssert.assertRowIdsAnyOrder((Iterable)rows, (String[])new String[]{"row1"});
        rows = this.getGraph().query(AUTHORIZATIONS_A).has("__extendedDataElementType", (Value)Values.stringValue((String)ElementType.VERTEX.name())).extendedDataRows();
        GeAssert.assertRowIdsAnyOrder((Iterable)rows, (String[])new String[]{"row1", "row2", "row3", "row4", "row5", "row6"});
        rows = this.getGraph().query(AUTHORIZATIONS_A).has("__extendedDataElementType", (Value)Values.stringValue((String)"VERTEX")).extendedDataRows();
        GeAssert.assertRowIdsAnyOrder((Iterable)rows, (String[])new String[]{"row1", "row2", "row3", "row4", "row5", "row6"});
        rows = this.getGraph().query(AUTHORIZATIONS_A).has("__extendedDataElementId", (Value)Values.stringValue((String)"v1")).extendedDataRows();
        GeAssert.assertRowIdsAnyOrder((Iterable)rows, (String[])new String[]{"row1", "row2", "row3"});
        rows = this.getGraph().query(AUTHORIZATIONS_A).has("__extendedDataTableName", (Value)Values.stringValue((String)"table1")).extendedDataRows();
        GeAssert.assertRowIdsAnyOrder((Iterable)rows, (String[])new String[]{"row1", "row2", "row4", "row5", "row7"});
    }

    @Test
    public void testExtendedDataInRange() {
        this.getGraph().prepareVertex("a", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("aa", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("az", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value3"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("b", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value4"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("aa", "a", "aa", "edge1", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value5"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        List rows = IterableUtils.toList((Iterable)this.getGraph().getExtendedDataInRange(ElementType.VERTEX, new IdRange(null, "a"), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)0L, (long)rows.size());
        rows = IterableUtils.toList((Iterable)this.getGraph().getExtendedDataInRange(ElementType.VERTEX, new IdRange(null, "b"), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)3L, (long)rows.size());
        List rowValues = rows.stream().map(row -> ((TextValue)row.getPropertyValue("name")).stringValue()).collect(Collectors.toList());
        GeAssert.assertIdsAnyOrder(rowValues, (String[])new String[]{"value1", "value2", "value3"});
        rows = IterableUtils.toList((Iterable)this.getGraph().getExtendedDataInRange(ElementType.VERTEX, new IdRange(null, "bb"), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)4L, (long)rows.size());
        rowValues = rows.stream().map(row -> ((TextValue)row.getPropertyValue("name")).stringValue()).collect(Collectors.toList());
        GeAssert.assertIdsAnyOrder(rowValues, (String[])new String[]{"value1", "value2", "value3", "value4"});
        rows = IterableUtils.toList((Iterable)this.getGraph().getExtendedDataInRange(ElementType.VERTEX, new IdRange("aa", "b"), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)2L, (long)rows.size());
        rowValues = rows.stream().map(row -> ((TextValue)row.getPropertyValue("name")).stringValue()).collect(Collectors.toList());
        GeAssert.assertIdsAnyOrder(rowValues, (String[])new String[]{"value2", "value3"});
        rows = IterableUtils.toList((Iterable)this.getGraph().getExtendedDataInRange(ElementType.VERTEX, new IdRange(null, null), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)4L, (long)rows.size());
        rowValues = rows.stream().map(row -> ((TextValue)row.getPropertyValue("name")).stringValue()).collect(Collectors.toList());
        GeAssert.assertIdsAnyOrder(rowValues, (String[])new String[]{"value1", "value2", "value3", "value4"});
        rows = IterableUtils.toList((Iterable)this.getGraph().getExtendedDataInRange(ElementType.EDGE, new IdRange(null, "a"), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)0L, (long)rows.size());
        rows = IterableUtils.toList((Iterable)this.getGraph().getExtendedDataInRange(ElementType.EDGE, new IdRange(null, "b"), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)1L, (long)rows.size());
        rowValues = rows.stream().map(row -> ((TextValue)row.getPropertyValue("name")).stringValue()).collect(Collectors.toList());
        GeAssert.assertIdsAnyOrder(rowValues, (String[])new String[]{"value5"});
        rows = IterableUtils.toList((Iterable)this.getGraph().getExtendedDataInRange(ElementType.EDGE, new IdRange("aa", "b"), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)1L, (long)rows.size());
        rowValues = rows.stream().map(row -> ((TextValue)row.getPropertyValue("name")).stringValue()).collect(Collectors.toList());
        GeAssert.assertIdsAnyOrder(rowValues, (String[])new String[]{"value5"});
        rows = IterableUtils.toList((Iterable)this.getGraph().getExtendedDataInRange(ElementType.EDGE, new IdRange(null, null), AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)1L, (long)rows.size());
        rowValues = rows.stream().map(row -> ((TextValue)row.getPropertyValue("name")).stringValue()).collect(Collectors.toList());
        GeAssert.assertIdsAnyOrder(rowValues, (String[])new String[]{"value5"});
    }

    @Test
    public void testExtendedDataDifferentValue() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        ArrayList rows = Lists.newArrayList((Iterable)v1.getExtendedData("table1"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1"), (Object)((ExtendedDataRow)rows.get(0)).getPropertyValue("name"));
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        rows = Lists.newArrayList((Iterable)v1.getExtendedData("table1"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2"), (Object)((ExtendedDataRow)rows.get(0)).getPropertyValue("name"));
    }

    @Test
    public void testExtendedDataDeleteColumn() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").deleteExtendedData("table1", "row1", "name", VISIBILITY_B).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        ArrayList rows = Lists.newArrayList((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getExtendedData("table1"));
        GeAssert.assertEquals((long)1L, (long)rows.size());
        QueryResultsIterable searchResults = this.getGraph().query("value", AUTHORIZATIONS_A).search();
        GeAssert.assertEquals((long)1L, (long)searchResults.getTotalHits());
        GeAssert.clearGraphEvents();
        this.getGraph().getVertex("v1", AUTHORIZATIONS_A).prepareMutation().deleteExtendedData("table1", "row1", "name", VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new DeleteExtendedDataEvent(this.getGraph(), (Element)v1, "table1", "row1", "name", null)});
        if (v1.getExtendedDataTableNames().size() == 0) {
            GeAssert.assertEquals((String)"table names", (long)0L, (long)v1.getExtendedDataTableNames().size());
        } else {
            GeAssert.assertEquals((String)"extended data rows", (long)0L, (long)Lists.newArrayList((Iterable)v1.getExtendedData("table1")).size());
        }
        searchResults = this.getGraph().query("value", AUTHORIZATIONS_A).search();
        List searchResultsList = IterableUtils.toList((Iterable)searchResults);
        GeAssert.assertEquals((String)"search result items", (long)0L, (long)searchResultsList.size());
        GeAssert.assertEquals((String)"total hits", (long)0L, (long)searchResults.getTotalHits());
    }

    @Test
    public void testExtendedDataDelete() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable searchResults = this.getGraph().query("value", AUTHORIZATIONS_A).search();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)searchResults);
        List rows = IterableUtils.toList((Iterable)this.getGraph().getExtendedData(ElementType.VERTEX, "v1", "table1", AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)1L, (long)rows.size());
        this.getGraph().deleteVertex("v1", AUTHORIZATIONS_A);
        this.getGraph().flush();
        searchResults = this.getGraph().query("value", AUTHORIZATIONS_A).search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
        rows = IterableUtils.toList((Iterable)this.getGraph().getExtendedData(ElementType.VERTEX, "v1", "table1", AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)0L, (long)rows.size());
    }

    @Test
    public void testExtendedDataQueryVerticesAfterVisibilityChange() {
        String nameColumnName = "name.column";
        String tableName = "table.one";
        String rowOneName = "row.one";
        String rowTwoName = "row.two";
        this.getGraph().defineProperty(nameColumnName).sortable(true).textIndexHint(TextIndexHint.values()).dataType(TextValue.class).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData(tableName, rowOneName, nameColumnName, (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData(tableName, rowTwoName, nameColumnName, (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable searchResults = this.getGraph().query("value", AUTHORIZATIONS_A).search();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)searchResults);
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList((Object[])new String[]{rowOneName, rowTwoName}), (Iterable)searchResults);
        this.getGraph().createAuthorizations(AUTHORIZATIONS_A_AND_B, new String[0]);
        this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A).prepareMutation().alterElementVisibility(VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        searchResults = this.getGraph().query("value", AUTHORIZATIONS_A).search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
    }

    @Test
    public void testExtendedDataQueryVertices() {
        DateTimeValue date1 = DateTimeValue.ofEpochMillis((IntegralValue)Values.longValue((long)1487083490000L));
        DateTimeValue date2 = DateTimeValue.ofEpochMillis((IntegralValue)Values.longValue((long)1487083480000L));
        String tableName = "table.one";
        String rowOneName = "row.one";
        String rowTwoName = "row.two";
        String dateColumnName = "date.column";
        String nameColumnName = "name.column";
        this.getGraph().defineProperty(dateColumnName).sortable(true).dataType(DateTimeValue.class).define();
        this.getGraph().defineProperty(nameColumnName).sortable(true).textIndexHint(TextIndexHint.values()).dataType(TextValue.class).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData(tableName, rowOneName, dateColumnName, (Value)date1, VISIBILITY_A).addExtendedData(tableName, rowOneName, nameColumnName, (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData(tableName, rowTwoName, dateColumnName, (Value)date2, VISIBILITY_A).addExtendedData(tableName, rowTwoName, nameColumnName, (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable queryResults = this.getGraph().query(AUTHORIZATIONS_A).has(dateColumnName, (Value)date1).sort(dateColumnName, SortDirection.ASCENDING).vertices();
        GeAssert.assertEquals((long)0L, (long)queryResults.getTotalHits());
        QueryResultsIterable searchResults = this.getGraph().query(AUTHORIZATIONS_A).has(dateColumnName, (Value)date1).sort(dateColumnName, SortDirection.ASCENDING).search();
        GeAssert.assertEquals((long)1L, (long)searchResults.getTotalHits());
        List searchResultsList = IterableUtils.toList((Iterable)searchResults);
        GeAssert.assertEquals((long)1L, (long)searchResultsList.size());
        ExtendedDataRow searchResult = (ExtendedDataRow)searchResultsList.get(0);
        GeAssert.assertEquals((Object)"v1", (Object)searchResult.getId().getElementId());
        GeAssert.assertEquals((Object)rowOneName, (Object)searchResult.getId().getRowId());
        searchResults = this.getGraph().query("value", AUTHORIZATIONS_A).search();
        GeAssert.assertEquals((long)2L, (long)searchResults.getTotalHits());
        searchResultsList = IterableUtils.toList((Iterable)searchResults);
        GeAssert.assertEquals((long)2L, (long)searchResultsList.size());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList((Object[])new String[]{rowOneName, rowTwoName}), (Iterable)searchResultsList);
        searchResults = this.getGraph().query("value", AUTHORIZATIONS_A).hasExtendedData(ElementType.VERTEX, "v1", tableName).search();
        GeAssert.assertEquals((long)2L, (long)searchResults.getTotalHits());
        searchResultsList = IterableUtils.toList((Iterable)searchResults);
        GeAssert.assertEquals((long)2L, (long)searchResultsList.size());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList((Object[])new String[]{rowOneName, rowTwoName}), (Iterable)searchResultsList);
        searchResults = this.getGraph().query("value", AUTHORIZATIONS_A).hasExtendedData(tableName).search();
        GeAssert.assertEquals((long)2L, (long)searchResults.getTotalHits());
        searchResultsList = IterableUtils.toList((Iterable)searchResults);
        GeAssert.assertEquals((long)2L, (long)searchResultsList.size());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList((Object[])new String[]{rowOneName, rowTwoName}), (Iterable)searchResultsList);
    }

    @Test
    public void testExtendedDataVertexQuery() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table1", "row2", "name", (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").addExtendedData("table2", "row3", "name", (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table2", "row4", "name", (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_A).addExtendedData("table1", "row5", "name", (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table1", "row6", "name", (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        List searchResultsList = IterableUtils.toList((Iterable)v1.query(AUTHORIZATIONS_A).extendedDataRows());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList((Object[])new String[]{"row3", "row4", "row5", "row6"}), (Iterable)searchResultsList);
        QueryResultsIterable rows = this.getGraph().query(AUTHORIZATIONS_A).hasId(new String[]{"v1"}).extendedDataRows();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)rows);
        rows = this.getGraph().query(AUTHORIZATIONS_A).hasId(new String[]{"v1", "v2"}).extendedDataRows();
        GeAssert.assertResultsCount((int)4, (int)4, (IterableWithTotalHits)rows);
        searchResultsList = IterableUtils.toList((Iterable)v1.query(AUTHORIZATIONS_A).sort("__extendedDataTableName", SortDirection.ASCENDING).sort("__extendedDataRowId", SortDirection.ASCENDING).extendedDataRows());
        GeAssert.assertRowIds((Iterable)Lists.newArrayList((Object[])new String[]{"row5", "row6", "row3", "row4"}), (Iterable)searchResultsList);
        searchResultsList = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).sort("__extendedDataElementId", SortDirection.ASCENDING).sort("__extendedDataRowId", SortDirection.ASCENDING).extendedDataRows());
        GeAssert.assertRowIds((Iterable)Lists.newArrayList((Object[])new String[]{"row5", "row6", "row1", "row2", "row3", "row4"}), (Iterable)searchResultsList);
        searchResultsList = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).sort("__extendedDataElementType", SortDirection.ASCENDING).sort("__extendedDataRowId", SortDirection.ASCENDING).extendedDataRows());
        GeAssert.assertRowIds((Iterable)Lists.newArrayList((Object[])new String[]{"row5", "row6", "row1", "row2", "row3", "row4"}), (Iterable)searchResultsList);
    }

    @Test
    public void testExtendedDataVertexQueryAggregations() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table1", "row2", "name", (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").addExtendedData("table2", "row3", "name", (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table2", "row4", "name", (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_A).addExtendedData("table1", "row5", "name", (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table1", "row6", "name", (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Query q = this.getGraph().query(AUTHORIZATIONS_A).limit(Long.valueOf(0L));
        TermsAggregation agg = new TermsAggregation("agg", "__extendedDataTableName");
        Assume.assumeTrue((String)"terms aggregation not supported", (boolean)q.isAggregationSupported((Aggregation)agg));
        q.addAggregation((Aggregation)agg);
        QueryResultsIterable rows = q.extendedDataRows();
        Map<Object, Long> aggResult = this.termsBucketToMap(((TermsResult)rows.getAggregationResult("agg", TermsResult.class)).getBuckets());
        GeAssert.assertEquals((long)2L, (long)aggResult.size());
        GeAssert.assertEquals((long)4L, (long)aggResult.get("table1"));
        GeAssert.assertEquals((long)2L, (long)aggResult.get("table2"));
        q = this.getGraph().query(AUTHORIZATIONS_A).addAggregation((Aggregation)new TermsAggregation("agg", "__extendedDataElementId")).limit(Long.valueOf(0L));
        rows = q.extendedDataRows();
        aggResult = this.termsBucketToMap(((TermsResult)rows.getAggregationResult("agg", TermsResult.class)).getBuckets());
        GeAssert.assertEquals((long)3L, (long)aggResult.size());
        GeAssert.assertEquals((long)2L, (long)aggResult.get("v1"));
        GeAssert.assertEquals((long)2L, (long)aggResult.get("v2"));
        GeAssert.assertEquals((long)2L, (long)aggResult.get("e1"));
        q = this.getGraph().query(AUTHORIZATIONS_A).addAggregation((Aggregation)new TermsAggregation("agg", "__extendedDataRowId")).limit(Long.valueOf(0L));
        rows = q.extendedDataRows();
        aggResult = this.termsBucketToMap(((TermsResult)rows.getAggregationResult("agg", TermsResult.class)).getBuckets());
        GeAssert.assertEquals((long)6L, (long)aggResult.size());
        GeAssert.assertEquals((long)1L, (long)aggResult.get("row1"));
        GeAssert.assertEquals((long)1L, (long)aggResult.get("row2"));
        GeAssert.assertEquals((long)1L, (long)aggResult.get("row3"));
        GeAssert.assertEquals((long)1L, (long)aggResult.get("row4"));
        GeAssert.assertEquals((long)1L, (long)aggResult.get("row5"));
        GeAssert.assertEquals((long)1L, (long)aggResult.get("row6"));
        q = this.getGraph().query(AUTHORIZATIONS_A).addAggregation((Aggregation)new TermsAggregation("agg", "__extendedDataElementType")).limit(Long.valueOf(0L));
        rows = q.extendedDataRows();
        aggResult = this.termsBucketToMap(((TermsResult)rows.getAggregationResult("agg", TermsResult.class)).getBuckets());
        GeAssert.assertEquals((long)2L, (long)aggResult.size());
        GeAssert.assertEquals((long)4L, (long)aggResult.get(ElementType.VERTEX.name()));
        GeAssert.assertEquals((long)2L, (long)aggResult.get(ElementType.EDGE.name()));
    }

    @Test
    public void testExtendedDataEdgeQuery() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table1", "row2", "name", (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").addExtendedData("table1", "row3", "name", (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table1", "row4", "name", (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_A).addExtendedData("table1", "row5", "name", (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table1", "row6", "name", (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Edge e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        List searchResultsList = IterableUtils.toList((Iterable)this.getGraph().query("*", AUTHORIZATIONS_A).hasExtendedData(ElementType.EDGE, e1.getId(), "table1").extendedDataRows());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList((Object[])new String[]{"row5", "row6"}), (Iterable)searchResultsList);
        QueryResultsIterable rows = this.getGraph().query(AUTHORIZATIONS_A).hasId(new String[]{"e1"}).extendedDataRows();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)rows);
        rows = this.getGraph().query(AUTHORIZATIONS_A).hasId(new String[]{"v1", "e1"}).extendedDataRows();
        GeAssert.assertResultsCount((int)4, (int)4, (IterableWithTotalHits)rows);
    }

    @Test
    public void testExtendedDataQueryAfterDeleteForVertex() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table1", "row2", "name", (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        List searchResultsList = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).extendedDataRows());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList((Object[])new String[]{"row1", "row2"}), (Iterable)searchResultsList);
        this.getGraph().deleteVertex("v1", AUTHORIZATIONS_A);
        this.getGraph().flush();
        searchResultsList = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).extendedDataRows());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList(), (Iterable)searchResultsList);
    }

    @Test
    public void testAddExtendedData() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "color", (Value)Values.stringValue((String)"red"), VISIBILITY_A).addExtendedData("table1", "row2", "color", (Value)Values.stringValue((String)"green"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().dumpGraph();
        QueryResultsIterable results = this.getGraph().query(AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)results);
        results = this.getGraph().query("red", AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)results);
        results = this.getGraph().query("green", AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)results);
        results = this.getGraph().query("blue", AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        this.getGraph().getVertex("v1", AUTHORIZATIONS_A).prepareMutation().addExtendedData("table1", "row1", "othercolor", (Value)Values.stringValue((String)"blue"), VISIBILITY_A).addExtendedData("table1", "row2", "othercolor", (Value)Values.stringValue((String)"purple"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().dumpGraph();
        results = this.getGraph().query(AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)results);
        results = this.getGraph().query("red", AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)results);
        results = this.getGraph().query("green", AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)results);
        results = this.getGraph().query("blue", AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)results);
        results = this.getGraph().query("purple", AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)results);
    }

    @Test
    public void testExtendedDataQueryAuthorizations() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "color", "junit", (Value)Values.stringValue((String)"red"), VISIBILITY_B).addExtendedData("table1", "row2", "color", "junit", (Value)Values.stringValue((String)"green"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().createAuthorizations(AUTHORIZATIONS_A_AND_B_AND_C, new String[0]);
        this.getGraph().flush();
        QueryResultsIterable results = this.getGraph().query(AUTHORIZATIONS_A).hasExtendedData(ElementType.VERTEX, "v1").extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        results = this.getGraph().query("red", AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        QueryResultsIterable searchResults = this.getGraph().query("red", AUTHORIZATIONS_A).search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query("red", AUTHORIZATIONS_B).extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query("red", AUTHORIZATIONS_B).search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query("red", AUTHORIZATIONS_A_AND_B).extendedDataRows();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query("red", AUTHORIZATIONS_A_AND_B).search();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)searchResults);
        searchResults = this.getGraph().query(AUTHORIZATIONS_A).hasExtendedData(ElementType.VERTEX, "v1").search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query(AUTHORIZATIONS_B).hasExtendedData(ElementType.VERTEX, "v1").extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query(AUTHORIZATIONS_B).hasExtendedData(ElementType.VERTEX, "v1").search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query(AUTHORIZATIONS_A_AND_B).hasExtendedData(ElementType.VERTEX, "v1").extendedDataRows();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query(AUTHORIZATIONS_A_AND_B).hasExtendedData(ElementType.VERTEX, "v1").search();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query(AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query(AUTHORIZATIONS_A).search();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query(AUTHORIZATIONS_B).extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query(AUTHORIZATIONS_B).search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query(AUTHORIZATIONS_A_AND_B).extendedDataRows();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query(AUTHORIZATIONS_A_AND_B).search();
        GeAssert.assertResultsCount((int)3, (int)3, (IterableWithTotalHits)searchResults);
        this.getGraph().getVertex("v1", AUTHORIZATIONS_A).prepareMutation().deleteExtendedData("table1", "row1", "color", "junit", VISIBILITY_B).deleteExtendedData("table1", "row2", "color", "junit", VISIBILITY_B).addExtendedData("table1", "row1", "color", "junit2", (Value)Values.stringValue((String)"blue"), VISIBILITY_C).save(AUTHORIZATIONS_A_AND_B_AND_C);
        this.getGraph().flush();
        Authorizations authorizationsAandC = new Authorizations(new String[]{"a", "c"});
        results = this.getGraph().query(AUTHORIZATIONS_A).extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query(AUTHORIZATIONS_A).search();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query(AUTHORIZATIONS_B).extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query(AUTHORIZATIONS_B).search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query(AUTHORIZATIONS_C).extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query(AUTHORIZATIONS_C).search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query(authorizationsAandC).extendedDataRows();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query(authorizationsAandC).search();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query(AUTHORIZATIONS_A_AND_B_AND_C).extendedDataRows();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query(AUTHORIZATIONS_A_AND_B_AND_C).search();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)searchResults);
        searchResults = this.getGraph().query("blue", AUTHORIZATIONS_A).search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query("blue", AUTHORIZATIONS_B).extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query("blue", AUTHORIZATIONS_B).search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query("blue", AUTHORIZATIONS_C).extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query("blue", AUTHORIZATIONS_C).search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query("blue", AUTHORIZATIONS_A_AND_B).extendedDataRows();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query("blue", AUTHORIZATIONS_A_AND_B).search();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)searchResults);
        results = this.getGraph().query("blue", authorizationsAandC).extendedDataRows();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)results);
        searchResults = this.getGraph().query("blue", authorizationsAandC).search();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)searchResults);
    }

    @Test
    public void testExtendedDataQueryAfterDeleteForEdge() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table1", "row2", "name", (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        List searchResultsList = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).extendedDataRows());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList((Object[])new String[]{"row1", "row2"}), (Iterable)searchResultsList);
        this.getGraph().deleteEdge("e1", AUTHORIZATIONS_A);
        this.getGraph().flush();
        searchResultsList = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).extendedDataRows());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList(), (Iterable)searchResultsList);
    }

    @Test
    public void testExtendedDataQueryEdges() {
        DateTimeValue date1 = DateTimeValue.ofEpochMillis((IntegralValue)Values.longValue((long)1487083490000L));
        DateTimeValue date2 = DateTimeValue.ofEpochMillis((IntegralValue)Values.longValue((long)1487083480000L));
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_A).addExtendedData("table1", "row1", "date", (Value)date1, VISIBILITY_A).addExtendedData("table1", "row1", "name", (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table1", "row2", "date", (Value)date2, VISIBILITY_A).addExtendedData("table1", "row2", "name", (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("e2", "v1", "v2", "label1", VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable queryResults = this.getGraph().query(AUTHORIZATIONS_A).has("date", (Value)date1).edges();
        GeAssert.assertEquals((long)0L, (long)queryResults.getTotalHits());
        QueryResultsIterable searchResults = this.getGraph().query(AUTHORIZATIONS_A).has("date", (Value)date1).search();
        GeAssert.assertEquals((long)1L, (long)searchResults.getTotalHits());
        List searchResultsList = IterableUtils.toList((Iterable)searchResults);
        GeAssert.assertEquals((long)1L, (long)searchResultsList.size());
        ExtendedDataRow searchResult = (ExtendedDataRow)searchResultsList.get(0);
        GeAssert.assertEquals((Object)"e1", (Object)searchResult.getId().getElementId());
        GeAssert.assertEquals((Object)"row1", (Object)searchResult.getId().getRowId());
        searchResults = this.getGraph().query(AUTHORIZATIONS_A).has("name", (Value)Values.stringValue((String)"value 1")).search();
        GeAssert.assertEquals((long)1L, (long)searchResults.getTotalHits());
        searchResultsList = IterableUtils.toList((Iterable)searchResults);
        GeAssert.assertEquals((long)1L, (long)searchResultsList.size());
        searchResult = (ExtendedDataRow)searchResultsList.get(0);
        GeAssert.assertEquals((Object)"e1", (Object)searchResult.getId().getElementId());
        GeAssert.assertEquals((Object)"row1", (Object)searchResult.getId().getRowId());
        searchResults = this.getGraph().query(AUTHORIZATIONS_A).has("name", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"value")).search();
        GeAssert.assertEquals((long)2L, (long)searchResults.getTotalHits());
        searchResultsList = IterableUtils.toList((Iterable)searchResults);
        GeAssert.assertEquals((long)2L, (long)searchResultsList.size());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList((Object[])new String[]{"row1", "row2"}), (Iterable)searchResultsList);
        searchResults = this.getGraph().query("value", AUTHORIZATIONS_A).search();
        GeAssert.assertEquals((long)2L, (long)searchResults.getTotalHits());
        searchResultsList = IterableUtils.toList((Iterable)searchResults);
        GeAssert.assertEquals((long)2L, (long)searchResultsList.size());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList((Object[])new String[]{"row1", "row2"}), (Iterable)searchResultsList);
    }

    @Test
    public void testExtendedDataQueryWithMultiValue() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addExtendedData("table1", "row1", "col1", "key1", (Value)Values.stringValue((String)"joe"), VISIBILITY_A).addExtendedData("table1", "row1", "col1", "key2", (Value)Values.stringValue((String)"bob"), VISIBILITY_A).addExtendedData("table1", "row2", "col1", "key1", (Value)Values.stringValue((String)"joe"), VISIBILITY_A).addExtendedData("table1", "row2", "col1", "key2", (Value)Values.stringValue((String)"jane"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        QueryableIterable rows = v1.getExtendedData("table1");
        for (ExtendedDataRow row : rows) {
            if (row.getId().getRowId().equals("row1")) {
                GeAssert.assertEquals((Object)Values.stringValue((String)"joe"), (Object)row.getPropertyValue("key1", "col1"));
                GeAssert.assertEquals((Object)Values.stringValue((String)"bob"), (Object)row.getPropertyValue("key2", "col1"));
                continue;
            }
            if (row.getId().getRowId().equals("row2")) {
                GeAssert.assertEquals((Object)Values.stringValue((String)"joe"), (Object)row.getPropertyValue("key1", "col1"));
                GeAssert.assertEquals((Object)Values.stringValue((String)"jane"), (Object)row.getPropertyValue("key2", "col1"));
                continue;
            }
            throw new GeException("invalid row: " + row.getId());
        }
        QueryResultsIterable searchResults = this.getGraph().query("joe", AUTHORIZATIONS_A).search();
        GeAssert.assertEquals((long)2L, (long)searchResults.getTotalHits());
        List searchResultsList = IterableUtils.toList((Iterable)searchResults);
        GeAssert.assertEquals((long)2L, (long)searchResultsList.size());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList((Object[])new String[]{"row1", "row2"}), (Iterable)searchResultsList);
        searchResults = this.getGraph().query("bob", AUTHORIZATIONS_A).search();
        GeAssert.assertEquals((long)1L, (long)searchResults.getTotalHits());
        searchResultsList = IterableUtils.toList((Iterable)searchResults);
        GeAssert.assertEquals((long)1L, (long)searchResultsList.size());
        GeAssert.assertRowIdsAnyOrder((Iterable)Lists.newArrayList((Object[])new String[]{"row1"}), (Iterable)searchResultsList);
    }
}

