/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.mware.ge.Direction;
import com.mware.ge.ElementBuilder;
import com.mware.ge.ElementId;
import com.mware.ge.FetchHints;
import com.mware.ge.FetchHintsBuilder;
import com.mware.ge.Graph;
import com.mware.ge.GraphBaseWithSearchIndex;
import com.mware.ge.Metadata;
import com.mware.ge.TextIndexHint;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.util.GeAssert;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GraphBenchmarkTests
implements GraphTestSetup {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(GraphBenchmarkTests.class);
    protected Graph graph;

    @Before
    public void before() throws Exception {
        this.graph = this.graphFactory().createGraph();
        GeAssert.clearGraphEvents();
        this.getGraph().addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                GeAssert.addGraphEvent((GraphEvent)graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().drop();
            this.getGraph().shutdown();
            this.graph = null;
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Test
    public void benchmark() {
        Assume.assumeTrue((boolean)this.benchmarkEnabled());
        Random random = new Random(1L);
        int vertexCount = 10000;
        int edgeCount = 10000;
        int findVerticesByIdCount = 10000;
        this.benchmarkAddVertices(vertexCount);
        this.benchmarkAddEdges(random, vertexCount, edgeCount);
        this.benchmarkFindVerticesById(random, vertexCount, findVerticesByIdCount);
        this.benchmarkFindConnectedVertices();
    }

    @Test
    public void benchmarkGetPropertyByName() {
        Assume.assumeTrue((boolean)this.benchmarkEnabled());
        int propertyCount = 100;
        VertexBuilder m = this.getGraph().prepareVertex("111111", VISIBILITY_A, "thing");
        for (int i = 0; i < 100; ++i) {
            m.addPropertyValue("key", "prop" + i, (Value)Values.stringValue((String)("value " + i)), VISIBILITY_A);
        }
        m.save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("111111", AUTHORIZATIONS_ALL);
        double startTime = System.currentTimeMillis();
        StringBuilder optimizationBuster = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            for (int propIndex = 0; propIndex < 100; ++propIndex) {
                Value value = v1.getPropertyValue("key", "prop" + propIndex);
                optimizationBuster.append(value.toString().substring(0, 1));
            }
        }
        double endTime = System.currentTimeMillis();
        LOGGER.trace("optimizationBuster: %s", new Object[]{optimizationBuster.substring(0, 1)});
        LOGGER.info("get property by name and key in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
        startTime = System.currentTimeMillis();
        optimizationBuster = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            for (int propIndex = 0; propIndex < 100; ++propIndex) {
                Value value = v1.getPropertyValue("prop" + propIndex);
                optimizationBuster.append(value.toString().substring(0, 1));
            }
        }
        endTime = System.currentTimeMillis();
        LOGGER.trace("optimizationBuster: %s", new Object[]{optimizationBuster.substring(0, 1)});
        LOGGER.info("get property by name in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    @Test
    public void benchmarkSaveElementMutations() {
        Assume.assumeTrue((boolean)this.benchmarkEnabled());
        int vertexCount = 1000000;
        this.benchmarkAddVertices(vertexCount);
        this.benchmarkAddVerticesSaveElementMutations(vertexCount);
        this.benchmarkAddVertices(vertexCount);
    }

    @Test
    public void benchmarkAddManyVertices() {
        Assume.assumeTrue((boolean)this.benchmarkEnabled());
        int vertexCount = 1000000;
        this.benchmarkAddVertices(vertexCount);
    }

    @Test
    public void benchmarkLotsOfProperties() {
        Assume.assumeTrue((boolean)this.benchmarkEnabled());
        int vertexCount = 100;
        int propertyNameCount = 10;
        int propertiesPerName = 50;
        int metadataPerProperty = 5;
        System.out.println("Defining properties");
        for (int i = 0; i < propertyNameCount; ++i) {
            this.getGraph().defineProperty("prop" + i).textIndexHint((Collection)TextIndexHint.NONE).dataType(TextValue.class).define();
        }
        System.out.println("Writing vertices");
        for (int vertexIndex = 0; vertexIndex < vertexCount; ++vertexIndex) {
            String vertexId = "v" + vertexIndex;
            VertexBuilder m = this.getGraph().prepareVertex(vertexId, VISIBILITY_A, "thing");
            for (int propertyNameIndex = 0; propertyNameIndex < propertyNameCount; ++propertyNameIndex) {
                for (int propertyPerNameIndex = 0; propertyPerNameIndex < propertiesPerName; ++propertyPerNameIndex) {
                    Metadata metadata = Metadata.create();
                    for (int metadataIndex = 0; metadataIndex < metadataPerProperty; ++metadataIndex) {
                        metadata.add("m" + UUID.randomUUID().toString(), (Value)Values.stringValue((String)("value" + metadataIndex)), VISIBILITY_A);
                    }
                    m.addPropertyValue("k" + UUID.randomUUID().toString(), "prop" + propertyNameIndex, (Value)Values.stringValue((String)("value" + propertyNameIndex)), metadata, VISIBILITY_A);
                }
            }
            m.save(AUTHORIZATIONS_ALL);
        }
        this.getGraph().flush();
        System.out.println("Reading vertices");
        for (Vertex vertex : this.getGraph().getVertices(FetchHints.ALL, AUTHORIZATIONS_A)) {
            vertex.getId();
        }
    }

    @Test
    public void benchmarkDeletes() {
        Assume.assumeTrue((boolean)this.benchmarkEnabled());
        Random random = new Random(1L);
        int vertexCount = 10000;
        int edgeCount = 10000;
        int extendedDataRowCount = 10000;
        this.benchmarkAddVertices(vertexCount);
        this.benchmarkAddEdges(random, vertexCount, edgeCount);
        this.benchmarkAddExtendedDataRows(random, vertexCount, extendedDataRowCount);
        double startTime = System.currentTimeMillis();
        ArrayList<ElementId> elementIds = new ArrayList<ElementId>();
        for (int i = 0; i < vertexCount; ++i) {
            String vertexId = "v" + i;
            elementIds.add(ElementId.vertex((String)vertexId));
        }
        this.getGraph().deleteElements(elementIds.stream(), AUTHORIZATIONS_A);
        this.getGraph().flush();
        double endTime = System.currentTimeMillis();
        LOGGER.info("delete vertices in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    @Test
    public void benchmarkLotsOfEdges() {
        String vertexId;
        int i;
        Assume.assumeTrue((boolean)this.benchmarkEnabled());
        int edgeCount = 100000;
        String sourceVertexId = "v12345678901234567890";
        this.graph.prepareVertex(sourceVertexId, VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)sourceVertexId), VISIBILITY_A).save(AUTHORIZATIONS_A);
        for (i = 0; i < edgeCount; ++i) {
            if (i % 10000 == 0) {
                System.out.println(String.format("Creating vertex %,d / %,d", i, edgeCount));
            }
            vertexId = "v12345678901234567890_" + i;
            this.graph.prepareVertex(vertexId, VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)vertexId), VISIBILITY_A).save(AUTHORIZATIONS_A);
        }
        for (i = 0; i < edgeCount; ++i) {
            if (i % 10000 == 0) {
                System.out.println(String.format("Creating edge %,d / %,d", i, edgeCount));
            }
            vertexId = "v12345678901234567890_" + i;
            String edgeId = "v12345678901234567890_label1_" + vertexId;
            this.graph.prepareEdge(edgeId, sourceVertexId, vertexId, "label1", VISIBILITY_A).save(AUTHORIZATIONS_A);
        }
        this.graph.flush();
        FetchHints fetchHints = new FetchHintsBuilder(FetchHints.ALL).build();
        this.graph.getVertex(sourceVertexId, fetchHints, AUTHORIZATIONS_A);
        fetchHints = new FetchHintsBuilder(FetchHints.ALL).setIncludeEdgeIds(false).build();
        this.graph.getVertex(sourceVertexId, fetchHints, AUTHORIZATIONS_A);
    }

    @Test
    public void testFindRelatedEdgesPerformance() {
        int totalNumberOfVertices = 1000;
        int totalNumberOfEdges = 100000;
        int totalVerticesToCheck = 1000;
        Random random = new Random(100L);
        Date startTime = new Date();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (int i = 0; i < totalNumberOfVertices; ++i) {
            vertices.add(this.getGraph().addVertex("v" + i, VISIBILITY_A, AUTHORIZATIONS_A, "thing"));
        }
        this.getGraph().flush();
        Date endTime = new Date();
        long insertVerticesTime = endTime.getTime() - startTime.getTime();
        startTime = new Date();
        for (int i = 0; i < totalNumberOfEdges; ++i) {
            Vertex outVertex = (Vertex)vertices.get(random.nextInt(vertices.size()));
            Vertex inVertex = (Vertex)vertices.get(random.nextInt(vertices.size()));
            this.getGraph().addEdge("e" + i, outVertex, inVertex, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        }
        this.getGraph().flush();
        endTime = new Date();
        long insertEdgesTime = endTime.getTime() - startTime.getTime();
        ArrayList<String> vertexIds = new ArrayList<String>();
        for (int i = 0; i < totalVerticesToCheck; ++i) {
            Vertex v = (Vertex)vertices.get(random.nextInt(vertices.size()));
            vertexIds.add(v.getId());
        }
        startTime = new Date();
        List edgeIds = IterableUtils.toList((Iterable)this.getGraph().findRelatedEdgeIds(vertexIds, AUTHORIZATIONS_A));
        IterableUtils.count((Iterable)edgeIds);
        endTime = new Date();
        long findRelatedEdgesTime = endTime.getTime() - startTime.getTime();
        LOGGER.info("RESULTS\ntotalNumberOfVertices,totalNumberOfEdges,totalVerticesToCheck,insertVerticesTime,insertEdgesTime,findRelatedEdgesTime\n%d,%d,%d,%d,%d,%d", new Object[]{totalNumberOfVertices, totalNumberOfEdges, totalVerticesToCheck, insertVerticesTime, insertEdgesTime, findRelatedEdgesTime});
    }

    @Test
    public void simpleAddVertices() {
        double startTime = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            this.getGraph().prepareVertex(VISIBILITY_A, "thing").addPropertyValue("k1", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addPropertyValue("k1", "prop2", (Value)Values.stringValue((String)"value2"), VISIBILITY_A).addPropertyValue("k1", "prop3", (Value)Values.stringValue((String)"value3"), VISIBILITY_A).addPropertyValue("k1", "prop4", (Value)Values.stringValue((String)"value4"), VISIBILITY_A).addPropertyValue("k1", "prop5", (Value)Values.stringValue((String)"value5"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        }
        this.getGraph().flush();
        double endTime = System.currentTimeMillis();
        LOGGER.info("add vertices in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    @Test
    public void bulkAddVertices() {
        double startTime = System.currentTimeMillis();
        ArrayList<ElementBuilder> builders = new ArrayList<ElementBuilder>();
        for (int i = 0; i < 100000; ++i) {
            builders.add(this.getGraph().prepareVertex(VISIBILITY_A, "thing").addPropertyValue("k1", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addPropertyValue("k1", "prop2", (Value)Values.stringValue((String)"value2"), VISIBILITY_A).addPropertyValue("k1", "prop3", (Value)Values.stringValue((String)"value3"), VISIBILITY_A).addPropertyValue("k1", "prop4", (Value)Values.stringValue((String)"value4"), VISIBILITY_A).addPropertyValue("k1", "prop5", (Value)Values.stringValue((String)"value5"), VISIBILITY_A));
        }
        this.getGraph().saveElementMutations(builders, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        double endTime = System.currentTimeMillis();
        LOGGER.info("add vertices in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    private void benchmarkAddVertices(int vertexCount) {
        this.getGraph().prepareVertex("warm_up", VISIBILITY_A, "thing").addPropertyValue("k1", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addPropertyValue("k1", "prop2", (Value)Values.stringValue((String)"value2"), VISIBILITY_A).addPropertyValue("k1", "prop3", (Value)Values.stringValue((String)"value3"), VISIBILITY_A).addPropertyValue("k1", "prop4", (Value)Values.stringValue((String)"value4"), VISIBILITY_A).addPropertyValue("k1", "prop5", (Value)Values.stringValue((String)"value5"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        ArrayList<ElementBuilder> elements = new ArrayList<ElementBuilder>();
        int batchSize = 2000;
        double startTime = System.currentTimeMillis();
        ((GraphBaseWithSearchIndex)this.getGraph()).getSearchIndex().enableBulkIngest(true);
        for (int i = 0; i < vertexCount; ++i) {
            String vertexId = "v" + i;
            elements.add(this.getGraph().prepareVertex(vertexId, VISIBILITY_A, "thing").addPropertyValue("k1", "prop1", (Value)Values.stringValue((String)("value1 " + i)), VISIBILITY_A).addPropertyValue("k1", "prop2", (Value)Values.stringValue((String)("value2 " + i)), VISIBILITY_A).addPropertyValue("k1", "prop3", (Value)Values.stringValue((String)("value3 " + i)), VISIBILITY_A).addPropertyValue("k1", "prop4", (Value)Values.stringValue((String)("value4 " + i)), VISIBILITY_A).addPropertyValue("k1", "prop5", (Value)Values.stringValue((String)("value5 " + i)), VISIBILITY_A));
            if (i % batchSize != 0) continue;
            this.graph.saveElementMutations(elements, AUTHORIZATIONS_ALL);
            elements.clear();
        }
        this.graph.saveElementMutations(elements, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        ((GraphBaseWithSearchIndex)this.getGraph()).getSearchIndex().enableBulkIngest(false);
        GeAssert.assertEquals((long)(vertexCount + 1), (long)this.getGraph().query(AUTHORIZATIONS_ALL).limit(Long.valueOf(0L)).vertices().getTotalHits());
        double endTime = System.currentTimeMillis();
        LOGGER.info("add vertices in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    private void benchmarkAddVerticesSaveElementMutations(int vertexCount) {
        double startTime = System.currentTimeMillis();
        ArrayList<ElementBuilder> mutations = new ArrayList<ElementBuilder>();
        for (int i = 0; i < vertexCount; ++i) {
            String vertexId = "v" + i;
            ElementBuilder m = this.getGraph().prepareVertex(vertexId, VISIBILITY_A, "thing").addPropertyValue("k1", "prop1", (Value)Values.stringValue((String)("value1 " + i)), VISIBILITY_A).addPropertyValue("k1", "prop2", (Value)Values.stringValue((String)("value2 " + i)), VISIBILITY_A).addPropertyValue("k1", "prop3", (Value)Values.stringValue((String)("value3 " + i)), VISIBILITY_A).addPropertyValue("k1", "prop4", (Value)Values.stringValue((String)("value4 " + i)), VISIBILITY_A).addPropertyValue("k1", "prop5", (Value)Values.stringValue((String)("value5 " + i)), VISIBILITY_A);
            mutations.add(m);
        }
        this.getGraph().saveElementMutations(mutations, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        double endTime = System.currentTimeMillis();
        LOGGER.info("save element mutations in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    private void benchmarkAddEdges(Random random, int vertexCount, int edgeCount) {
        double startTime = System.currentTimeMillis();
        for (int i = 0; i < edgeCount; ++i) {
            String edgeId = "e" + i;
            String outVertexId = "v" + random.nextInt(vertexCount);
            String inVertexId = "v" + random.nextInt(vertexCount);
            this.getGraph().prepareEdge(edgeId, outVertexId, inVertexId, "label1", VISIBILITY_A).addPropertyValue("k1", "prop1", (Value)Values.stringValue((String)("value1 " + i)), VISIBILITY_A).addPropertyValue("k1", "prop2", (Value)Values.stringValue((String)("value2 " + i)), VISIBILITY_A).addPropertyValue("k1", "prop3", (Value)Values.stringValue((String)("value3 " + i)), VISIBILITY_A).addPropertyValue("k1", "prop4", (Value)Values.stringValue((String)("value4 " + i)), VISIBILITY_A).addPropertyValue("k1", "prop5", (Value)Values.stringValue((String)("value5 " + i)), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        }
        this.getGraph().flush();
        double endTime = System.currentTimeMillis();
        LOGGER.info("add edges in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    private void benchmarkAddExtendedDataRows(Random random, int vertexCount, int extendedDataRowCount) {
        double startTime = System.currentTimeMillis();
        for (int i = 0; i < extendedDataRowCount; ++i) {
            String row = "row" + i;
            String vertexId = "v" + random.nextInt(vertexCount);
            this.getGraph().prepareVertex(vertexId, VISIBILITY_A, "thing").addExtendedData("table1", row, "column1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        }
        this.getGraph().flush();
        double endTime = System.currentTimeMillis();
        LOGGER.info("add rows in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    private void benchmarkFindVerticesById(Random random, int vertexCount, int findVerticesByIdCount) {
        double startTime = System.currentTimeMillis();
        for (int i = 0; i < findVerticesByIdCount; ++i) {
            String vertexId = "v" + random.nextInt(vertexCount);
            this.getGraph().getVertex(vertexId, AUTHORIZATIONS_ALL);
        }
        this.getGraph().flush();
        double endTime = System.currentTimeMillis();
        LOGGER.info("find vertices by id in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    private void benchmarkFindConnectedVertices() {
        double startTime = System.currentTimeMillis();
        for (Vertex vertex : this.getGraph().getVertices(AUTHORIZATIONS_ALL)) {
            for (Vertex connectedVertex : vertex.getVertices(Direction.BOTH, AUTHORIZATIONS_ALL)) {
                connectedVertex.getId();
            }
        }
        double endTime = System.currentTimeMillis();
        LOGGER.info("find connected vertices in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    protected boolean benchmarkEnabled() {
        return Boolean.parseBoolean(System.getProperty("benchmark", "false"));
    }
}

