/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.mware.ge.DefaultGraphVisitor;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeElementLocation;
import com.mware.ge.EdgeInfo;
import com.mware.ge.EdgeVertexPair;
import com.mware.ge.EdgeVertices;
import com.mware.ge.Element;
import com.mware.ge.ElementBuilder;
import com.mware.ge.ElementId;
import com.mware.ge.FetchHints;
import com.mware.ge.FetchHintsBuilder;
import com.mware.ge.FindPathOptions;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.GraphVisitor;
import com.mware.ge.GraphWithSearchIndex;
import com.mware.ge.HasTimestamp;
import com.mware.ge.IdRange;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.RelatedEdgeImpl;
import com.mware.ge.SecurityGeException;
import com.mware.ge.TextIndexHint;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.event.AddEdgeEvent;
import com.mware.ge.event.AddExtendedDataEvent;
import com.mware.ge.event.AddPropertyEvent;
import com.mware.ge.event.AddVertexEvent;
import com.mware.ge.event.DeleteEdgeEvent;
import com.mware.ge.event.DeletePropertyEvent;
import com.mware.ge.event.DeleteVertexEvent;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.metric.StackTraceTracker;
import com.mware.ge.mutation.ElementMutation;
import com.mware.ge.mutation.ExistingEdgeMutation;
import com.mware.ge.query.IterableWithTotalHits;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.SortDirection;
import com.mware.ge.search.DefaultSearchIndex;
import com.mware.ge.search.IndexHint;
import com.mware.ge.search.SearchIndex;
import com.mware.ge.util.GeAssert;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IncreasingTime;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.DateValue;
import com.mware.ge.values.storable.DurationValue;
import com.mware.ge.values.storable.LocalDateTimeValue;
import com.mware.ge.values.storable.LocalTimeValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.TimeValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GraphBaseTests
implements GraphTestSetup {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(GraphBaseTests.class);
    protected Graph graph;

    @Before
    public void before() throws Exception {
        this.graph = this.graphFactory().createGraph();
        GeAssert.clearGraphEvents();
        this.getGraph().addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                GeAssert.addGraphEvent((GraphEvent)graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().drop();
            this.getGraph().shutdown();
            this.graph = null;
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Test
    public void testElementId() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label", VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertTrue((boolean)v1.equals(ElementId.vertex((String)"v1")));
        GeAssert.assertTrue((boolean)ElementId.vertex((String)"v1").equals(v1));
        GeAssert.assertEquals((long)v1.hashCode(), (long)ElementId.vertex((String)"v1").hashCode());
        Edge e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        GeAssert.assertTrue((boolean)e1.equals(ElementId.edge((String)"e1")));
        GeAssert.assertTrue((boolean)ElementId.edge((String)"e1").equals(e1));
        GeAssert.assertEquals((long)e1.hashCode(), (long)ElementId.vertex((String)"e1").hashCode());
    }

    @Test
    public void testAddVertexWithId() {
        Vertex vertexAdded = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        GeAssert.assertNotNull((Object)vertexAdded);
        GeAssert.assertEquals((Object)"v1", (Object)vertexAdded.getId());
        this.getGraph().flush();
        Vertex v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)v);
        GeAssert.assertEquals((Object)"v1", (Object)v.getId());
        GeAssert.assertEquals((Object)VISIBILITY_A, (Object)v.getVisibility());
        v = this.getGraph().getVertex("", AUTHORIZATIONS_A);
        GeAssert.assertNull((Object)v);
        v = this.getGraph().getVertex(null, AUTHORIZATIONS_A);
        GeAssert.assertNull((Object)v);
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new AddVertexEvent(this.getGraph(), vertexAdded)});
    }

    @Test
    public void testAddVertexWithoutId() {
        Vertex vertexAdded = this.getGraph().addVertex(VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        GeAssert.assertNotNull((Object)vertexAdded);
        String vertexId = vertexAdded.getId();
        GeAssert.assertNotNull((Object)vertexId);
        this.getGraph().flush();
        Vertex v = this.getGraph().getVertex(vertexId, AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)v);
        GeAssert.assertNotNull((Object)vertexId);
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new AddVertexEvent(this.getGraph(), vertexAdded)});
    }

    @Test
    public void testGetSingleVertexWithSameRowPrefix() {
        this.getGraph().addVertex("prefix", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
        this.getGraph().addVertex("prefixA", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
        this.getGraph().flush();
        Vertex v = this.getGraph().getVertex("prefix", AUTHORIZATIONS_EMPTY);
        GeAssert.assertEquals((Object)"prefix", (Object)v.getId());
        v = this.getGraph().getVertex("prefixA", AUTHORIZATIONS_EMPTY);
        GeAssert.assertEquals((Object)"prefixA", (Object)v.getId());
    }

    @Test
    public void testAddVertexPropertyWithMetadata() {
        Metadata prop1Metadata = Metadata.create();
        prop1Metadata.add("metadata1", (Value)Values.stringValue((String)"metadata1Value"), VISIBILITY_A);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), prop1Metadata, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        final AtomicInteger vertexCount = new AtomicInteger();
        final AtomicInteger vertexPropertyCount = new AtomicInteger();
        this.getGraph().visitElements((GraphVisitor)new DefaultGraphVisitor(){

            public void visitVertex(Vertex vertex) {
                vertexCount.incrementAndGet();
            }

            public void visitProperty(Element element, Property property) {
                vertexPropertyCount.incrementAndGet();
            }
        }, AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)vertexCount.get());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCount.get());
        Vertex v = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        if (v instanceof HasTimestamp) {
            GeAssert.assertTrue((String)"timestamp should be more than 0", (v.getTimestamp() > 0L ? 1 : 0) != 0);
        }
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getProperties("prop1")));
        Property prop1 = (Property)v.getProperties("prop1").iterator().next();
        if (prop1 instanceof HasTimestamp) {
            GeAssert.assertTrue((String)"timestamp should be more than 0", (prop1.getTimestamp() > 0L ? 1 : 0) != 0);
        }
        prop1Metadata = prop1.getMetadata();
        GeAssert.assertNotNull((Object)prop1Metadata);
        GeAssert.assertEquals((long)1L, (long)prop1Metadata.entrySet().size());
        GeAssert.assertEquals((Object)Values.stringValue((String)"metadata1Value"), (Object)prop1Metadata.getEntry("metadata1", VISIBILITY_A).getValue());
        prop1Metadata.add("metadata2", (Value)Values.stringValue((String)"metadata2Value"), VISIBILITY_A);
        v.prepareMutation().setProperty("prop1", (Value)Values.stringValue((String)"value1"), prop1Metadata, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getProperties("prop1")));
        prop1 = (Property)v.getProperties("prop1").iterator().next();
        prop1Metadata = prop1.getMetadata();
        GeAssert.assertEquals((long)2L, (long)prop1Metadata.entrySet().size());
        GeAssert.assertEquals((Object)Values.stringValue((String)"metadata1Value"), (Object)prop1Metadata.getEntry("metadata1", VISIBILITY_A).getValue());
        GeAssert.assertEquals((Object)Values.stringValue((String)"metadata2Value"), (Object)prop1Metadata.getEntry("metadata2", VISIBILITY_A).getValue());
        prop1Metadata = Metadata.create();
        v.setProperty("prop1", (Value)Values.stringValue((String)"value2"), prop1Metadata, VISIBILITY_A, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getProperties("prop1")));
        prop1 = (Property)v.getProperties("prop1").iterator().next();
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2"), (Object)prop1.getValue());
        prop1Metadata = prop1.getMetadata();
        GeAssert.assertEquals((long)0L, (long)prop1Metadata.entrySet().size());
    }

    @Test
    public void testAddVertexWithProperties() {
        Vertex vertexAdded = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).setProperty("prop2", (Value)Values.stringValue((String)"value2"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        Iterable p = vertexAdded.getProperties("prop1");
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertexAdded.getProperties("prop1")));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1"), vertexAdded.getPropertyValues("prop1").iterator().next());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertexAdded.getProperties("prop2")));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2"), vertexAdded.getPropertyValues("prop2").iterator().next());
        this.getGraph().flush();
        Vertex v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getProperties("prop1")));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1"), v.getPropertyValues("prop1").iterator().next());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getProperties("prop2")));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2"), v.getPropertyValues("prop2").iterator().next());
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new AddVertexEvent(this.getGraph(), vertexAdded), new AddPropertyEvent(this.getGraph(), (Element)vertexAdded, vertexAdded.getProperty("prop1")), new AddPropertyEvent(this.getGraph(), (Element)vertexAdded, vertexAdded.getProperty("prop2"))});
        GeAssert.clearGraphEvents();
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        vertexAdded = (Vertex)v.prepareMutation().addPropertyValue("key1", "prop1Mutation", (Value)Values.stringValue((String)"value1Mutation"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getProperties("prop1Mutation")));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1Mutation"), v.getPropertyValues("prop1Mutation").iterator().next());
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new AddPropertyEvent(this.getGraph(), (Element)vertexAdded, vertexAdded.getProperty("prop1Mutation"))});
    }

    @Test
    public void testNullPropertyValue() {
        try {
            this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").setProperty("prop1", null, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
            throw new GeException("expected null check");
        }
        catch (NullPointerException ex) {
            GeAssert.assertTrue((boolean)ex.getMessage().contains("prop1"));
            return;
        }
    }

    @Test
    public void testConcurrentModificationOfProperties() {
        Vertex v = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).setProperty("prop2", (Value)Values.stringValue((String)"value2"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        int i = 0;
        for (Property p : v.getProperties()) {
            GeAssert.assertNotNull((Object)p.toString());
            if (i == 0) {
                v.setProperty("prop3", (Value)Values.stringValue((String)"value3"), VISIBILITY_A, AUTHORIZATIONS_A_AND_B);
            }
            ++i;
        }
    }

    @Test
    public void testAddVertexWithPropertiesWithTwoDifferentVisibilities() {
        Vertex v = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1a"), VISIBILITY_A).setProperty("prop1", (Value)Values.stringValue((String)"value1b"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v.getProperties("prop1")));
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v.getProperties("prop1")));
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getProperties("prop1")));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1a"), (Object)v.getPropertyValue("prop1"));
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_B);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getProperties("prop1")));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1b"), (Object)v.getPropertyValue("prop1"));
    }

    @Test
    public void testMultivaluedProperties() {
        Vertex v = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        v.prepareMutation().addPropertyValue("propid1a", "prop1", (Value)Values.stringValue((String)"value1a"), VISIBILITY_A).addPropertyValue("propid2a", "prop2", (Value)Values.stringValue((String)"value2a"), VISIBILITY_A).addPropertyValue("propid3a", "prop3", (Value)Values.stringValue((String)"value3a"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1a"), v.getPropertyValues("prop1").iterator().next());
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2a"), v.getPropertyValues("prop2").iterator().next());
        GeAssert.assertEquals((Object)Values.stringValue((String)"value3a"), v.getPropertyValues("prop3").iterator().next());
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)v.getProperties()));
        v.prepareMutation().addPropertyValue("propid1a", "prop1", (Value)Values.stringValue((String)"value1b"), VISIBILITY_A).addPropertyValue("propid2a", "prop2", (Value)Values.stringValue((String)"value2b"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getPropertyValues("prop1")));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1b"), v.getPropertyValues("prop1").iterator().next());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getPropertyValues("prop2")));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2b"), v.getPropertyValues("prop2").iterator().next());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getPropertyValues("prop3")));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value3a"), v.getPropertyValues("prop3").iterator().next());
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)v.getProperties()));
        v.addPropertyValue("propid1b", "prop1", (Value)Values.stringValue((String)"value1a-new"), VISIBILITY_A, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        IterableUtils.assertContains((Object)Values.stringValue((String)"value1b"), (Iterable)v.getPropertyValues("prop1"));
        IterableUtils.assertContains((Object)Values.stringValue((String)"value1a-new"), (Iterable)v.getPropertyValues("prop1"));
        GeAssert.assertEquals((long)4L, (long)IterableUtils.count((Iterable)v.getProperties()));
    }

    @Test
    public void testMultivaluedPropertyOrder() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("a", "prop", (Value)Values.stringValue((String)"a"), VISIBILITY_A).addPropertyValue("aa", "prop", (Value)Values.stringValue((String)"aa"), VISIBILITY_A).addPropertyValue("b", "prop", (Value)Values.stringValue((String)"b"), VISIBILITY_A).addPropertyValue("0", "prop", (Value)Values.stringValue((String)"0"), VISIBILITY_A).addPropertyValue("A", "prop", (Value)Values.stringValue((String)"A"), VISIBILITY_A).addPropertyValue("Z", "prop", (Value)Values.stringValue((String)"Z"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)Values.stringValue((String)"0"), (Object)v1.getPropertyValue("prop", 0));
        GeAssert.assertEquals((Object)Values.stringValue((String)"A"), (Object)v1.getPropertyValue("prop", 1));
        GeAssert.assertEquals((Object)Values.stringValue((String)"Z"), (Object)v1.getPropertyValue("prop", 2));
        GeAssert.assertEquals((Object)Values.stringValue((String)"a"), (Object)v1.getPropertyValue("prop", 3));
        GeAssert.assertEquals((Object)Values.stringValue((String)"aa"), (Object)v1.getPropertyValue("prop", 4));
        GeAssert.assertEquals((Object)Values.stringValue((String)"b"), (Object)v1.getPropertyValue("prop", 5));
    }

    @Test
    public void testDeleteProperty() {
        Vertex v = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        v.prepareMutation().addPropertyValue("propid1a", "prop1", (Value)Values.stringValue((String)"value1a"), VISIBILITY_A).addPropertyValue("propid1b", "prop1", (Value)Values.stringValue((String)"value1b"), VISIBILITY_A).addPropertyValue("propid2a", "prop2", (Value)Values.stringValue((String)"value2a"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        GeAssert.clearGraphEvents();
        v = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        Property prop1_propid1a = v.getProperty("propid1a", "prop1");
        Property prop1_propid1b = v.getProperty("propid1b", "prop1");
        v.deleteProperties("prop1", AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        this.getGraph().dumpGraph();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getProperties()));
        v = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getProperties()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop2", (Value)Values.stringValue((String)"value2a")).vertices()));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop1", (Value)Values.stringValue((String)"value1a")).vertices()));
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new DeletePropertyEvent(this.getGraph(), (Element)v, prop1_propid1a), new DeletePropertyEvent(this.getGraph(), (Element)v, prop1_propid1b)});
        GeAssert.clearGraphEvents();
        Property prop2_propid2a = v.getProperty("propid2a", "prop2");
        v.deleteProperty("propid2a", "prop2", AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v.getProperties()));
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v.getProperties()));
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new DeletePropertyEvent(this.getGraph(), (Element)v, prop2_propid2a)});
    }

    @Test
    public void testDeletePropertyWithMutation() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("propid1a", "prop1", (Value)Values.stringValue((String)"value1a"), VISIBILITY_A).addPropertyValue("propid1b", "prop1", (Value)Values.stringValue((String)"value1b"), VISIBILITY_A).addPropertyValue("propid2a", "prop2", (Value)Values.stringValue((String)"value2a"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_A).addPropertyValue("key1", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.clearGraphEvents();
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        Property prop1_propid1a = v1.getProperty("propid1a", "prop1");
        Property prop1_propid1b = v1.getProperty("propid1b", "prop1");
        v1.prepareMutation().deleteProperties("prop1").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop2", (Value)Values.stringValue((String)"value2a")).vertices()));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop1", (Value)Values.stringValue((String)"value1a")).vertices()));
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new DeletePropertyEvent(this.getGraph(), (Element)v1, prop1_propid1a), new DeletePropertyEvent(this.getGraph(), (Element)v1, prop1_propid1b)});
        GeAssert.clearGraphEvents();
        Property prop2_propid2a = v1.getProperty("propid2a", "prop2");
        v1.prepareMutation().deleteProperties("propid2a", "prop2").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new DeletePropertyEvent(this.getGraph(), (Element)v1, prop2_propid2a)});
        GeAssert.clearGraphEvents();
        Edge e1 = this.getGraph().getEdge("e1", FetchHints.ALL, AUTHORIZATIONS_A);
        Property edgeProperty = e1.getProperty("key1", "prop1");
        e1.prepareMutation().deleteProperties("key1", "prop1").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)e1.getProperties()));
        e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)e1.getProperties()));
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new DeletePropertyEvent(this.getGraph(), (Element)e1, edgeProperty)});
    }

    @Test
    public void testDeleteElement() {
        Vertex v = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        v.prepareMutation().setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)v);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop1", (Value)Values.stringValue((String)"value1")).vertices()));
        this.getGraph().deleteVertex(v.getId(), AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertNull((Object)v);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop1", (Value)Values.stringValue((String)"value1")).vertices()));
    }

    @Test
    public void testDeleteElements() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addExtendedData("table1", "row1", "column1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_A).addExtendedData("table1", "row1", "column1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        ArrayList<Object> elements = new ArrayList<Object>();
        FetchHints fetchHints = new FetchHintsBuilder(FetchHints.EDGE_REFS).setIncludeExtendedDataTableNames(true).build();
        elements.add(this.getGraph().getVertex("v1", fetchHints, AUTHORIZATIONS_A));
        elements.add(ElementId.vertex((String)"v2"));
        this.getGraph().deleteElements(elements.stream(), AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertNull((Object)this.getGraph().getVertex("v1", AUTHORIZATIONS_A));
        GeAssert.assertNull((Object)this.getGraph().getVertex("v2", AUTHORIZATIONS_A));
        GeAssert.assertNull((Object)this.getGraph().getEdge("e1", AUTHORIZATIONS_A));
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop1", (Value)Values.stringValue((String)"value1")).vertices());
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A_AND_B).vertices());
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A_AND_B).edges());
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A_AND_B).extendedDataRows());
    }

    @Test
    public void testDeleteVertex() {
        this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("e1", "v1", "v2", "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertVertexIds((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A), (String[])new String[]{"v1", "v2"});
        GeAssert.assertEdgeIds((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A), (String[])new String[]{"e1"});
        this.getGraph().deleteVertex("v1", AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertVertexIds((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A), (String[])new String[]{"v2"});
        GeAssert.assertEdgeIds((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A), (String[])new String[0]);
    }

    @Test
    public void testAddEdge() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Edge addedEdge = this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertNotNull((Object)addedEdge);
        GeAssert.assertEquals((Object)"e1", (Object)addedEdge.getId());
        GeAssert.assertEquals((Object)"label1", (Object)addedEdge.getLabel());
        GeAssert.assertEquals((Object)"v1", (Object)addedEdge.getVertexId(Direction.OUT));
        GeAssert.assertEquals((Object)v1, (Object)addedEdge.getVertex(Direction.OUT, AUTHORIZATIONS_A));
        GeAssert.assertEquals((Object)"v2", (Object)addedEdge.getVertexId(Direction.IN));
        GeAssert.assertEquals((Object)v2, (Object)addedEdge.getVertex(Direction.IN, AUTHORIZATIONS_A));
        GeAssert.assertEquals((Object)VISIBILITY_A, (Object)addedEdge.getVisibility());
        EdgeVertices addedEdgeVertices = addedEdge.getVertices(AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)v1, (Object)addedEdgeVertices.getOutVertex());
        GeAssert.assertEquals((Object)v2, (Object)addedEdgeVertices.getInVertex());
        FetchHints propertiesFetchHints = FetchHints.builder().setIncludeAllProperties(true).build();
        FetchHints inEdgeRefsFetchHints = FetchHints.builder().setIncludeInEdgeRefs(true).build();
        FetchHints outEdgeRefsFetchHints = FetchHints.builder().setIncludeOutEdgeRefs(true).build();
        this.getGraph().getVertex("v1", FetchHints.NONE, AUTHORIZATIONS_A);
        this.getGraph().getVertex("v1", this.getGraph().getDefaultFetchHints(), AUTHORIZATIONS_A);
        this.getGraph().getVertex("v1", propertiesFetchHints, AUTHORIZATIONS_A);
        this.getGraph().getVertex("v1", FetchHints.EDGE_REFS, AUTHORIZATIONS_A);
        this.getGraph().getVertex("v1", inEdgeRefsFetchHints, AUTHORIZATIONS_A);
        this.getGraph().getVertex("v1", outEdgeRefsFetchHints, AUTHORIZATIONS_A);
        this.getGraph().getEdge("e1", FetchHints.NONE, AUTHORIZATIONS_A);
        this.getGraph().getEdge("e1", this.getGraph().getDefaultFetchHints(), AUTHORIZATIONS_A);
        this.getGraph().getEdge("e1", propertiesFetchHints, AUTHORIZATIONS_A);
        Edge e = this.getGraph().getEdge("e1", AUTHORIZATIONS_B);
        GeAssert.assertNull((Object)e);
        e = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)e);
        GeAssert.assertEquals((Object)"e1", (Object)e.getId());
        GeAssert.assertEquals((Object)"label1", (Object)e.getLabel());
        GeAssert.assertEquals((Object)"v1", (Object)e.getVertexId(Direction.OUT));
        GeAssert.assertEquals((Object)v1, (Object)e.getVertex(Direction.OUT, AUTHORIZATIONS_A));
        GeAssert.assertEquals((Object)"v2", (Object)e.getVertexId(Direction.IN));
        GeAssert.assertEquals((Object)v2, (Object)e.getVertex(Direction.IN, AUTHORIZATIONS_A));
        GeAssert.assertEquals((Object)VISIBILITY_A, (Object)e.getVisibility());
        this.getGraph().flush();
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new AddVertexEvent(this.getGraph(), v1), new AddVertexEvent(this.getGraph(), v2), new AddEdgeEvent(this.getGraph(), addedEdge)});
    }

    @Test
    public void testGetEdge() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("e1to2label1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e1to2label2", v1, v2, "label2", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e2to1", v2.getId(), v1.getId(), "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.IN, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)v1.getEdges(v2, Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v1.getEdges(v2, Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(v2, Direction.IN, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v1.getEdges(v2, Direction.BOTH, "label1", AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(v2, Direction.OUT, "label1", AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(v2, Direction.IN, "label1", AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)v1.getEdges(v2, Direction.BOTH, new String[]{"label1", "label2"}, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v1.getEdges(v2, Direction.OUT, new String[]{"label1", "label2"}, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(v2, Direction.IN, new String[]{"label1", "label2"}, AUTHORIZATIONS_A)));
        GeAssert.assertArrayEquals((Object[])new String[]{"label1", "label2"}, (Object[])IterableUtils.toArray((Iterable)v1.getEdgesSummary(AUTHORIZATIONS_A).getOutEdgeLabels(), String.class));
        GeAssert.assertArrayEquals((Object[])new String[]{"label1"}, (Object[])IterableUtils.toArray((Iterable)v1.getEdgesSummary(AUTHORIZATIONS_A).getInEdgeLabels(), String.class));
        GeAssert.assertArrayEquals((Object[])new String[]{"label1", "label2"}, (Object[])IterableUtils.toArray((Iterable)v1.getEdgesSummary(AUTHORIZATIONS_A).getEdgeLabels(), String.class));
    }

    @Test
    public void testGetEdgeVertexPairs() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Edge v1_to_v2_label1 = this.getGraph().addEdge("v1_to_v2_label1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        Edge v1_to_v2_label2 = this.getGraph().addEdge("v1_to_v2_label2", v1, v2, "label2", VISIBILITY_A, AUTHORIZATIONS_A);
        Edge v1_to_v3_label2 = this.getGraph().addEdge("v1_to_v3_label2", v1, v3, "label2", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        List pairs = IterableUtils.toList((Iterable)v1.getEdgeVertexPairs(Direction.BOTH, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)3L, (long)pairs.size());
        GeAssert.assertTrue((boolean)pairs.contains(new EdgeVertexPair(v1_to_v2_label1, v2)));
        GeAssert.assertTrue((boolean)pairs.contains(new EdgeVertexPair(v1_to_v2_label2, v2)));
        GeAssert.assertTrue((boolean)pairs.contains(new EdgeVertexPair(v1_to_v3_label2, v3)));
        pairs = IterableUtils.toList((Iterable)v1.getEdgeVertexPairs(Direction.BOTH, "label2", AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)2L, (long)pairs.size());
        GeAssert.assertTrue((boolean)pairs.contains(new EdgeVertexPair(v1_to_v2_label2, v2)));
        GeAssert.assertTrue((boolean)pairs.contains(new EdgeVertexPair(v1_to_v3_label2, v3)));
    }

    @Test
    public void testAddEdgeWithProperties() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Edge addedEdge = (Edge)this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_A).setProperty("propA", (Value)Values.stringValue((String)"valueA"), VISIBILITY_A).setProperty("propB", (Value)Values.stringValue((String)"valueB"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Edge e = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)e.getProperties()));
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueA"), e.getPropertyValues("propA").iterator().next());
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)e.getPropertyValues("propB")));
        e = this.getGraph().getEdge("e1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)e.getProperties()));
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueA"), e.getPropertyValues("propA").iterator().next());
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueB"), e.getPropertyValues("propB").iterator().next());
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueA"), (Object)e.getPropertyValue("propA"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueB"), (Object)e.getPropertyValue("propB"));
        this.getGraph().flush();
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new AddVertexEvent(this.getGraph(), v1), new AddVertexEvent(this.getGraph(), v2), new AddEdgeEvent(this.getGraph(), addedEdge), new AddPropertyEvent(this.getGraph(), (Element)addedEdge, addedEdge.getProperty("propA")), new AddPropertyEvent(this.getGraph(), (Element)addedEdge, addedEdge.getProperty("propB"))});
    }

    @Test
    public void testAddEdgeWithNullInOutVertices() {
        try {
            String outVertexId = null;
            String inVertexId = null;
            this.getGraph().prepareEdge("e1", outVertexId, inVertexId, "label1", VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
            GeAssert.fail((String)"should throw an exception");
        }
        catch (Exception ex) {
            GeAssert.assertNotNull((Object)ex);
        }
        try {
            Vertex outVertex = null;
            Vertex inVertex = null;
            this.getGraph().prepareEdge("e1", outVertex, inVertex, "label1", VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
            GeAssert.fail((String)"should throw an exception");
        }
        catch (Exception ex) {
            GeAssert.assertNotNull((Object)ex);
        }
    }

    @Test
    public void testAddEdgeWithNullLabels() {
        String label;
        try {
            label = null;
            this.getGraph().prepareEdge("e1", "v1", "v2", label, VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
            GeAssert.fail((String)"should throw an exception");
        }
        catch (Exception ex) {
            GeAssert.assertNotNull((Object)ex);
        }
        try {
            label = null;
            Vertex outVertex = this.getGraph().addVertex("v1", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL, "thing");
            Vertex inVertex = this.getGraph().addVertex("v2", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL, "thing");
            this.getGraph().prepareEdge("e1", outVertex, inVertex, label, VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
            GeAssert.fail((String)"should throw an exception");
        }
        catch (Exception ex) {
            GeAssert.assertNotNull((Object)ex);
        }
    }

    @Test
    public void testChangingPropertyOnEdge() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_A).setProperty("propA", (Value)Values.stringValue((String)"valueA"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Edge e = this.getGraph().getEdge("e1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)e.getProperties()));
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueA"), e.getPropertyValues("propA").iterator().next());
        Property propA = e.getProperty("", "propA");
        GeAssert.assertNotNull((Object)propA);
        e.markPropertyHidden(propA, VISIBILITY_A, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        e = this.getGraph().getEdge("e1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)e.getProperties()));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)e.getPropertyValues("propA")));
        e.setProperty(propA.getName(), (Value)Values.stringValue((String)"valueA_changed"), VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        e = this.getGraph().getEdge("e1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)e.getProperties()));
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueA_changed"), e.getPropertyValues("propA").iterator().next());
        e.markPropertyVisible(propA, VISIBILITY_A, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        e = this.getGraph().getEdge("e1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)e.getProperties()));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)e.getPropertyValues("propA")));
        List propertyValues = IterableUtils.toList((Iterable)e.getPropertyValues("propA"));
        GeAssert.assertTrue((boolean)propertyValues.contains(Values.stringValue((String)"valueA")));
        GeAssert.assertTrue((boolean)propertyValues.contains(Values.stringValue((String)"valueA_changed")));
    }

    @Test
    public void testsAlterVertexConceptType() {
        Vertex v = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)"thing", (Object)v.getConceptType());
        v.prepareMutation().alterConceptType("document").save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)"document", (Object)v.getConceptType());
        v.prepareMutation().alterConceptType("audio").save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)"audio", (Object)v.getConceptType());
    }

    @Test
    public void testAlterEdgeLabel() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_A).setProperty("propA", (Value)Values.stringValue((String)"valueA"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Edge e = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)"label1", (Object)e.getLabel());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)e.getProperties()));
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueA"), e.getPropertyValues("propA").iterator().next());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((Object)"label1", (Object)IterableUtils.single((Iterable)v1.getEdgesSummary(AUTHORIZATIONS_A).getOutEdgeLabels()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v2.getEdges(Direction.IN, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((Object)"label1", (Object)IterableUtils.single((Iterable)v2.getEdgesSummary(AUTHORIZATIONS_A).getInEdgeLabels()));
        e.prepareMutation().alterEdgeLabel("label2").save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        e = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)"label2", (Object)e.getLabel());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)e.getProperties()));
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueA"), e.getPropertyValues("propA").iterator().next());
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((Object)"label2", (Object)IterableUtils.single((Iterable)v1.getEdgesSummary(AUTHORIZATIONS_A).getOutEdgeLabels()));
        v2 = this.getGraph().getVertex("v2", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v2.getEdges(Direction.IN, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((Object)"label2", (Object)IterableUtils.single((Iterable)v2.getEdgesSummary(AUTHORIZATIONS_A).getInEdgeLabels()));
        this.getGraph().prepareEdge(e.getId(), e.getVertexId(Direction.OUT), e.getVertexId(Direction.IN), e.getLabel(), e.getVisibility()).alterEdgeLabel("label3").save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        e = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)"label3", (Object)e.getLabel());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)e.getProperties()));
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueA"), e.getPropertyValues("propA").iterator().next());
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((Object)"label3", (Object)IterableUtils.single((Iterable)v1.getEdgesSummary(AUTHORIZATIONS_A).getOutEdgeLabels()));
        v2 = this.getGraph().getVertex("v2", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v2.getEdges(Direction.IN, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((Object)"label3", (Object)IterableUtils.single((Iterable)v2.getEdgesSummary(AUTHORIZATIONS_A).getInEdgeLabels()));
    }

    @Test
    public void testDeleteEdge() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Edge addedEdge = this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().dumpGraph();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
        try {
            this.getGraph().deleteEdge("e1", AUTHORIZATIONS_B);
            this.getGraph().dumpGraph();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
        this.getGraph().deleteEdge("e1", AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().dumpGraph();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getVertices(Direction.BOTH, AUTHORIZATIONS_A)));
        v2 = this.getGraph().getVertex("v2", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v2.getVertices(Direction.BOTH, AUTHORIZATIONS_A)));
        this.getGraph().flush();
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new AddVertexEvent(this.getGraph(), v1), new AddVertexEvent(this.getGraph(), v2), new AddEdgeEvent(this.getGraph(), addedEdge), new DeleteEdgeEvent(this.getGraph(), (EdgeElementLocation)addedEdge)});
    }

    @Test
    public void testDeleteElementEdge() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_A).addExtendedData("table1", "row1", "column1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        this.getGraph().deleteElement(ElementId.edge((String)"e1"), AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertNull((Object)this.getGraph().getEdge("e1", AUTHORIZATIONS_A));
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A_AND_B).edges());
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A_AND_B).extendedDataRows());
    }

    @Test
    public void testAddEdgeWithVisibility() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e2", v1, v2, "label2", VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Iterable aEdges = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getEdges(Direction.BOTH, AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)aEdges));
        GeAssert.assertEquals((Object)"label1", (Object)((Edge)IterableUtils.single((Iterable)aEdges)).getLabel());
        Iterable bEdges = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getEdges(Direction.BOTH, AUTHORIZATIONS_B);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)bEdges));
        GeAssert.assertEquals((Object)"label2", (Object)((Edge)IterableUtils.single((Iterable)bEdges)).getLabel());
        Iterable allEdges = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getEdges(Direction.BOTH, AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)allEdges));
    }

    @Test
    public void testSoftDeleteVertex() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("name1", (Value)Values.stringValue((String)"value1")).vertices()));
        Vertex v2 = this.getGraph().getVertex("v2", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)v2.getEdgesSummary(AUTHORIZATIONS_A).getCountOfEdges());
        this.getGraph().softDeleteVertex("v1", AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("name1", (Value)Values.stringValue((String)"value1")).vertices()));
        v2 = this.getGraph().getVertex("v2", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)0L, (long)v2.getEdgesSummary(AUTHORIZATIONS_A).getCountOfEdges());
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v4", VISIBILITY_A, "thing").addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((long)4L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        GeAssert.assertResultsCount((int)3, (QueryResultsIterable)this.getGraph().query(AUTHORIZATIONS_A).has("name1", (Value)Values.stringValue((String)"value1")).vertices());
        this.getGraph().softDeleteVertex("v3", AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)this.getGraph().query(AUTHORIZATIONS_A).has("name1", (Value)Values.stringValue((String)"value1")).vertices());
    }

    @Test
    public void testReAddingSoftDeletedVertex() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("k1", "p1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((Object)VISIBILITY_A.getVisibilityString(), (Object)v1.getVisibility().getVisibilityString());
        this.getGraph().softDeleteVertex(v1, AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)v1);
        GeAssert.assertEquals((Object)VISIBILITY_A.getVisibilityString(), (Object)v1.getVisibility().getVisibilityString());
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        this.getGraph().softDeleteVertex(v1, AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().prepareVertex("v1", VISIBILITY_A_AND_B, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertNotNull((Object)v1);
        GeAssert.assertEquals((Object)VISIBILITY_A_AND_B.getVisibilityString(), (Object)v1.getVisibility().getVisibilityString());
        this.getGraph().softDeleteVertex(v1, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        this.getGraph().addVertex("v1", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertNotNull((Object)v1);
        GeAssert.assertEquals((Object)VISIBILITY_EMPTY.getVisibilityString(), (Object)v1.getVisibility().getVisibilityString());
    }

    @Test
    public void testGetSoftDeletedElementWithFetchHintsAndTimestamp() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Edge e1 = this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        long beforeDeleteTime = IncreasingTime.currentTimeMillis();
        this.getGraph().softDeleteEdge(e1, AUTHORIZATIONS_A);
        this.getGraph().softDeleteVertex(v1, AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().dumpGraph();
        GeAssert.assertNull((Object)this.getGraph().getEdge(e1.getId(), AUTHORIZATIONS_A));
        GeAssert.assertNull((Object)this.getGraph().getEdge(e1.getId(), this.getGraph().getDefaultFetchHints(), AUTHORIZATIONS_A));
        GeAssert.assertNull((Object)this.getGraph().getEdge(e1.getId(), FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A));
        GeAssert.assertNull((Object)this.getGraph().getVertex(v1.getId(), AUTHORIZATIONS_A));
        GeAssert.assertNull((Object)this.getGraph().getVertex(v1.getId(), this.getGraph().getDefaultFetchHints(), AUTHORIZATIONS_A));
        GeAssert.assertNull((Object)this.getGraph().getVertex(v1.getId(), FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A));
        GeAssert.assertNotNull((Object)this.getGraph().getEdge(e1.getId(), this.getGraph().getDefaultFetchHints(), Long.valueOf(beforeDeleteTime), AUTHORIZATIONS_A));
        GeAssert.assertNotNull((Object)this.getGraph().getEdge(e1.getId(), FetchHints.ALL_INCLUDING_HIDDEN, Long.valueOf(beforeDeleteTime), AUTHORIZATIONS_A));
        GeAssert.assertNotNull((Object)this.getGraph().getVertex(v1.getId(), this.getGraph().getDefaultFetchHints(), Long.valueOf(beforeDeleteTime), AUTHORIZATIONS_A));
        GeAssert.assertNotNull((Object)this.getGraph().getVertex(v1.getId(), FetchHints.ALL_INCLUDING_HIDDEN, Long.valueOf(beforeDeleteTime), AUTHORIZATIONS_A));
    }

    @Test
    public void testSoftDeleteEdge() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A_AND_B, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_B, AUTHORIZATIONS_A_AND_B, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_B, AUTHORIZATIONS_A_AND_B, "thing");
        this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        this.getGraph().addEdge("e2", v1, v3, "label1", VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Edge e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A_AND_B);
        this.getGraph().softDeleteEdge(e1, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        v2 = this.getGraph().getVertex("v2", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v2.getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v2.getEdges(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v2.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        v2 = this.getGraph().getVertex("v2", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v2.getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v2.getEdges(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v2.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        v3 = this.getGraph().getVertex("v3", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v3.getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v3.getEdges(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v3.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        v3 = this.getGraph().getVertex("v3", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v3.getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v3.getEdges(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v3.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
    }

    @Test
    public void testBlindWriteEdgeBothDirections() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_A).addPropertyValue("k1", "name1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().prepareEdge("e1", "v2", "v1", "label1", VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Edge e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)"v2", (Object)e1.getVertexId(Direction.OUT));
        GeAssert.assertEquals((Object)"v1", (Object)e1.getVertexId(Direction.IN));
        GeAssert.assertEdgeIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("__outVertexId", (Value)Values.stringValue((String)"v2")).edges(), (String[])new String[]{"e1"});
        GeAssert.assertEdgeIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("__outVertexId", (Value)Values.stringValue((String)"v1")).edges(), (String[])new String[0]);
        GeAssert.assertEdgeIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("__inVertexId", (Value)Values.stringValue((String)"v1")).edges(), (String[])new String[]{"e1"});
        GeAssert.assertEdgeIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("__inVertexId", (Value)Values.stringValue((String)"v2")).edges(), (String[])new String[0]);
    }

    @Test
    public void testReAddingSoftDeletedEdge() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        Edge e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        this.getGraph().softDeleteEdge(e1, AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        GeAssert.assertNotNull((Object)e1);
        GeAssert.assertEquals((Object)VISIBILITY_A.getVisibilityString(), (Object)e1.getVisibility().getVisibilityString());
        this.getGraph().dumpGraph();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A)));
        v2 = this.getGraph().getVertex("v2", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v2.getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v2.getEdges(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v2.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A)));
    }

    @Test
    public void testSoftDeleteProperty() throws InterruptedException {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().dumpGraph();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)this.getGraph().query(AUTHORIZATIONS_A).has("name1", (Value)Values.stringValue((String)"value1")).vertices());
        this.getGraph().getVertex("v1", AUTHORIZATIONS_A).softDeleteProperties("name1", AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().dumpGraph();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        GeAssert.assertResultsCount((int)0, (QueryResultsIterable)this.getGraph().query(AUTHORIZATIONS_A).has("name1", (Value)Values.stringValue((String)"value1")).vertices());
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().dumpGraph();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)this.getGraph().query(AUTHORIZATIONS_A).has("name1", (Value)Values.stringValue((String)"value1")).vertices());
        this.getGraph().getVertex("v1", AUTHORIZATIONS_A).softDeleteProperties("name1", AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().dumpGraph();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        GeAssert.assertResultsCount((int)0, (QueryResultsIterable)this.getGraph().query(AUTHORIZATIONS_A).has("name1", (Value)Values.stringValue((String)"value1")).vertices());
    }

    @Test
    public void testFindRelatedEdgeSummaryAfterSoftDeleteAndReAdd() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Edge e1 = this.getGraph().addEdge("e v1->v2", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        ArrayList<String> vertexIds = new ArrayList<String>();
        vertexIds.add("v1");
        vertexIds.add("v2");
        List relatedEdges = IterableUtils.toList((Iterable)this.getGraph().findRelatedEdgeSummary(vertexIds, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)1L, (long)relatedEdges.size());
        IterableUtils.assertContains((Object)new RelatedEdgeImpl("e v1->v2", "label1", v1.getId(), v2.getId()), (Iterable)relatedEdges);
        this.getGraph().softDeleteEdge(e1, AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().prepareEdge("e v1->v2", v1, v2, "label1", VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        relatedEdges = IterableUtils.toList((Iterable)this.getGraph().findRelatedEdgeSummary(vertexIds, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)1L, (long)relatedEdges.size());
        IterableUtils.assertContains((Object)new RelatedEdgeImpl("e v1->v2", "label1", v1.getId(), v2.getId()), (Iterable)relatedEdges);
    }

    @Test
    public void testSoftDeletePropertyThroughMutation() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("name1", (Value)Values.stringValue((String)"value1")).vertices()));
        this.getGraph().getVertex("v1", AUTHORIZATIONS_A).prepareMutation().softDeleteProperties("name1").save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("name1", (Value)Values.stringValue((String)"value1")).vertices()));
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)this.getGraph().query(AUTHORIZATIONS_A).has("name1", (Value)Values.stringValue((String)"value1")).vertices());
        this.getGraph().getVertex("v1", AUTHORIZATIONS_A).prepareMutation().softDeleteProperties("name1").save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        GeAssert.assertResultsCount((int)0, (QueryResultsIterable)this.getGraph().query(AUTHORIZATIONS_A).has("name1", (Value)Values.stringValue((String)"value1")).vertices());
    }

    @Test
    public void testSoftDeletePropertyOnEdgeNotIndexed() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A_AND_B, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_B, AUTHORIZATIONS_A_AND_B, "thing");
        ElementBuilder elementBuilder = this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_B).setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_B);
        elementBuilder.setIndexHint(IndexHint.DO_NOT_INDEX);
        Edge e1 = (Edge)elementBuilder.save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        ExistingEdgeMutation m = e1.prepareMutation();
        m.softDeleteProperty("prop1", VISIBILITY_B);
        m.setIndexHint(IndexHint.DO_NOT_INDEX);
        m.save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)e1.getProperties()));
    }

    @Test
    public void testSoftDeletePropertyWithVisibility() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value2"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getProperties()));
        IterableUtils.assertContains((Object)Values.stringValue((String)"value1"), (Iterable)v1.getPropertyValues("name1"));
        IterableUtils.assertContains((Object)Values.stringValue((String)"value2"), (Iterable)v1.getPropertyValues("name1"));
        this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).softDeleteProperty("key1", "name1", VISIBILITY_A, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getProperties()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getPropertyValues("key1", "name1")));
        IterableUtils.assertContains((Object)Values.stringValue((String)"value2"), (Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getPropertyValues("name1"));
    }

    @Test
    public void testSoftDeletePropertyThroughMutationWithVisibility() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value2"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getProperties()));
        IterableUtils.assertContains((Object)Values.stringValue((String)"value1"), (Iterable)v1.getPropertyValues("name1"));
        IterableUtils.assertContains((Object)Values.stringValue((String)"value2"), (Iterable)v1.getPropertyValues("name1"));
        v1 = (Vertex)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).prepareMutation().softDeleteProperty("key1", "name1", VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getPropertyValues("key1", "name1")));
        IterableUtils.assertContains((Object)Values.stringValue((String)"value2"), (Iterable)v1.getPropertyValues("name1"));
    }

    @Test
    public void testSoftDeletePropertyOnAHiddenVertex() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value1"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().markVertexHidden(v1, VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A);
        v1.softDeleteProperty("key1", "name1", AUTHORIZATIONS_A);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A);
        GeAssert.assertNull((Object)v1.getProperty("key1", "name1", VISIBILITY_EMPTY));
    }

    @Test
    public void testMarkHiddenWithVisibilityChange() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "firstName", (Value)Values.stringValue((String)"Joe"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        IterableUtils.assertContains((Object)Values.stringValue((String)"Joe"), (Iterable)v1.getPropertyValues("firstName"));
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        v1.markPropertyHidden("key1", "firstName", VISIBILITY_A, VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        v1.addPropertyValue("key1", "firstName", (Value)Values.stringValue((String)"Joseph"), VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A_AND_B);
        List properties = IterableUtils.toList((Iterable)v1.getProperties());
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)properties));
        boolean foundJoeProp = false;
        boolean foundJosephProp = false;
        for (Property property : properties) {
            if (property.getName().equals("firstName")) {
                if (property.getKey().equals("key1") && property.getValue().eq((Object)Values.stringValue((String)"Joe"))) {
                    foundJoeProp = true;
                    GeAssert.assertTrue((String)"should be hidden", (boolean)property.isHidden(AUTHORIZATIONS_A_AND_B));
                    GeAssert.assertFalse((String)"should not be hidden", (boolean)property.isHidden(AUTHORIZATIONS_A));
                    continue;
                }
                if (property.getKey().equals("key1") && property.getValue().eq((Object)Values.stringValue((String)"Joseph"))) {
                    if (property.getVisibility().equals((Object)VISIBILITY_B)) {
                        foundJosephProp = true;
                        GeAssert.assertFalse((String)"should not be hidden", (boolean)property.isHidden(AUTHORIZATIONS_A_AND_B));
                        continue;
                    }
                    throw new RuntimeException("Unexpected visibility " + property.getVisibility());
                }
                throw new RuntimeException("Unexpected property key " + property.getKey());
            }
            throw new RuntimeException("Unexpected property name " + property.getName());
        }
        GeAssert.assertTrue((String)"Joseph property value not found", (boolean)foundJosephProp);
        GeAssert.assertTrue((String)"Joe property value not found", (boolean)foundJoeProp);
    }

    @Test
    public void testSoftDeleteWithVisibilityChanges() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "firstName", (Value)Values.stringValue((String)"Joe"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        IterableUtils.assertContains((Object)Values.stringValue((String)"Joe"), (Iterable)v1.getPropertyValues("firstName"));
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        v1.markPropertyHidden("key1", "firstName", VISIBILITY_A, VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        v1.addPropertyValue("key1", "firstName", (Value)Values.stringValue((String)"Joseph"), VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1.softDeleteProperty("key1", "firstName", VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1.markPropertyVisible("key1", "firstName", VISIBILITY_A, VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        v1.addPropertyValue("key1", "firstName", (Value)Values.stringValue((String)"Joseph"), VISIBILITY_A, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        List properties = IterableUtils.toList((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getProperties());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)properties));
        Property property = (Property)properties.iterator().next();
        GeAssert.assertEquals((Object)VISIBILITY_A, (Object)property.getVisibility());
        GeAssert.assertEquals((Object)Values.stringValue((String)"Joseph"), (Object)property.getValue());
        Vertex v2 = (Vertex)this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").addPropertyValue("key1", "firstName", (Value)Values.stringValue((String)"Joe"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v2.getProperties()));
        IterableUtils.assertContains((Object)Values.stringValue((String)"Joe"), (Iterable)v2.getPropertyValues("firstName"));
        v2 = this.getGraph().getVertex("v2", AUTHORIZATIONS_A_AND_B);
        v2.markPropertyHidden("key1", "firstName", VISIBILITY_A, VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        v2.addPropertyValue("key1", "firstName", (Value)Values.stringValue((String)"Joseph"), VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v2.softDeleteProperty("key1", "firstName", VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v2.markPropertyVisible("key1", "firstName", VISIBILITY_A, VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        v2.addPropertyValue("key1", "firstName", (Value)Values.stringValue((String)"Joe"), VISIBILITY_A, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        properties = IterableUtils.toList((Iterable)this.getGraph().getVertex("v2", AUTHORIZATIONS_A_AND_B).getProperties());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)properties));
        property = (Property)properties.iterator().next();
        GeAssert.assertEquals((Object)VISIBILITY_A, (Object)property.getVisibility());
        GeAssert.assertEquals((Object)Values.stringValue((String)"Joe"), (Object)property.getValue());
    }

    @Test
    public void testMarkPropertyVisible() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "firstName", (Value)Values.stringValue((String)"Joe"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        IterableUtils.assertContains((Object)Values.stringValue((String)"Joe"), (Iterable)v1.getPropertyValues("firstName"));
        long t = IncreasingTime.currentTimeMillis();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        v1.markPropertyHidden("key1", "firstName", VISIBILITY_A, Long.valueOf(t), VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        List properties = IterableUtils.toList((Iterable)this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A_AND_B).getProperties());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)properties));
        long beforeMarkPropertyVisibleTimestamp = t += 1000L;
        v1.markPropertyVisible("key1", "firstName", VISIBILITY_A, Long.valueOf(t += 1000L), VISIBILITY_B, AUTHORIZATIONS_A_AND_B);
        properties = IterableUtils.toList((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getProperties());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)properties));
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", this.getGraph().getDefaultFetchHints(), Long.valueOf(beforeMarkPropertyVisibleTimestamp), AUTHORIZATIONS_A_AND_B);
        GeAssert.assertNotNull((String)("could not find v1 before timestamp " + beforeMarkPropertyVisibleTimestamp + " current time " + (t += 1000L)), (Object)v1);
        properties = IterableUtils.toList((Iterable)v1.getProperties());
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)properties));
    }

    @Test
    public void testAddVertexWithVisibility() {
        this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().addVertex("v2", VISIBILITY_B, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().flush();
        Iterable cVertices = this.getGraph().getVertices(AUTHORIZATIONS_C);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)cVertices));
        Iterable aVertices = this.getGraph().getVertices(AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)"v1", (Object)((Vertex)IterableUtils.single((Iterable)aVertices)).getId());
        Iterable bVertices = this.getGraph().getVertices(AUTHORIZATIONS_B);
        GeAssert.assertEquals((Object)"v2", (Object)((Vertex)IterableUtils.single((Iterable)bVertices)).getId());
        Iterable allVertices = this.getGraph().getVertices(AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)allVertices));
    }

    @Test
    public void testAddMultipleVertices() {
        ArrayList<ElementBuilder> elements = new ArrayList<ElementBuilder>();
        elements.add(this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"v1"), VISIBILITY_A));
        elements.add(this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"v2"), VISIBILITY_A));
        Iterable vertices = this.getGraph().addVertices(elements, AUTHORIZATIONS_A_AND_B);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1", "v2"});
        this.getGraph().flush();
        if (this.getGraph() instanceof GraphWithSearchIndex) {
            ((GraphWithSearchIndex)this.getGraph()).getSearchIndex().addElements(this.getGraph(), vertices, AUTHORIZATIONS_A_AND_B);
            GeAssert.assertVertexIds((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop1", (Value)Values.stringValue((String)"v1")).vertices(), (String[])new String[]{"v1"});
            GeAssert.assertVertexIds((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop1", (Value)Values.stringValue((String)"v2")).vertices(), (String[])new String[]{"v2"});
        }
    }

    @Test
    public void testGetVerticesWithIds() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"v1"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v1b", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"v1b"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"v2"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"v3"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("v2");
        ids.add("v1");
        Iterable vertices = this.getGraph().getVertices(ids, AUTHORIZATIONS_A);
        boolean foundV1 = false;
        boolean foundV2 = false;
        for (Vertex v : vertices) {
            if (v.getId().equals("v1")) {
                GeAssert.assertEquals((Object)Values.stringValue((String)"v1"), (Object)v.getPropertyValue("prop1"));
                foundV1 = true;
                continue;
            }
            if (v.getId().equals("v2")) {
                GeAssert.assertEquals((Object)Values.stringValue((String)"v2"), (Object)v.getPropertyValue("prop1"));
                foundV2 = true;
                continue;
            }
            GeAssert.assertTrue((String)("Unexpected vertex id: " + v.getId()), (boolean)false);
        }
        GeAssert.assertTrue((String)"v1 not found", (boolean)foundV1);
        GeAssert.assertTrue((String)"v2 not found", (boolean)foundV2);
        List verticesInOrder = this.getGraph().getVerticesInOrder(ids, AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)2L, (long)verticesInOrder.size());
        GeAssert.assertEquals((Object)"v2", (Object)((Vertex)verticesInOrder.get(0)).getId());
        GeAssert.assertEquals((Object)"v1", (Object)((Vertex)verticesInOrder.get(1)).getId());
    }

    @Test
    public void testGetVerticesWithPrefix() {
        this.getGraph().addVertex("a", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().addVertex("aa", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().addVertex("az", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().addVertex("b", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().flush();
        List<Vertex> vertices = this.sortById(IterableUtils.toList((Iterable)this.getGraph().getVerticesWithPrefix("a", AUTHORIZATIONS_ALL)));
        GeAssert.assertVertexIds(vertices, (String[])new String[]{"a", "aa", "az"});
        vertices = this.sortById(IterableUtils.toList((Iterable)this.getGraph().getVerticesWithPrefix("b", AUTHORIZATIONS_ALL)));
        GeAssert.assertVertexIds(vertices, (String[])new String[]{"b"});
        vertices = this.sortById(IterableUtils.toList((Iterable)this.getGraph().getVerticesWithPrefix("c", AUTHORIZATIONS_ALL)));
        GeAssert.assertVertexIds(vertices, (String[])new String[0]);
    }

    @Test
    public void testGetVerticesInRange() {
        this.getGraph().addVertex("a", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().addVertex("aa", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().addVertex("az", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().addVertex("b", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().flush();
        List vertices = IterableUtils.toList((Iterable)this.getGraph().getVerticesInRange(new IdRange(null, "a"), AUTHORIZATIONS_ALL));
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[0]);
        vertices = IterableUtils.toList((Iterable)this.getGraph().getVerticesInRange(new IdRange(null, "b"), AUTHORIZATIONS_ALL));
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"a", "aa", "az"});
        vertices = IterableUtils.toList((Iterable)this.getGraph().getVerticesInRange(new IdRange(null, "bb"), AUTHORIZATIONS_ALL));
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"a", "aa", "az", "b"});
        vertices = IterableUtils.toList((Iterable)this.getGraph().getVerticesInRange(new IdRange(null, null), AUTHORIZATIONS_ALL));
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"a", "aa", "az", "b"});
    }

    @Test
    public void testGetEdgesInRange() {
        this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("a", "v1", "v2", "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL);
        this.getGraph().addEdge("aa", "v1", "v2", "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL);
        this.getGraph().addEdge("az", "v1", "v2", "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL);
        this.getGraph().addEdge("b", "v1", "v2", "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        List edges = IterableUtils.toList((Iterable)this.getGraph().getEdgesInRange(new IdRange(null, "a"), AUTHORIZATIONS_ALL));
        GeAssert.assertEdgeIds((Iterable)edges, (String[])new String[0]);
        edges = IterableUtils.toList((Iterable)this.getGraph().getEdgesInRange(new IdRange(null, "b"), AUTHORIZATIONS_ALL));
        GeAssert.assertEdgeIds((Iterable)edges, (String[])new String[]{"a", "aa", "az"});
        edges = IterableUtils.toList((Iterable)this.getGraph().getEdgesInRange(new IdRange(null, "bb"), AUTHORIZATIONS_ALL));
        GeAssert.assertEdgeIds((Iterable)edges, (String[])new String[]{"a", "aa", "az", "b"});
        edges = IterableUtils.toList((Iterable)this.getGraph().getEdgesInRange(new IdRange(null, null), AUTHORIZATIONS_ALL));
        GeAssert.assertEdgeIds((Iterable)edges, (String[])new String[]{"a", "aa", "az", "b"});
    }

    @Test
    public void testGetEdgesWithIds() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_A).setProperty("prop1", (Value)Values.stringValue((String)"e1"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e1a", v1, v2, "label1", VISIBILITY_A).setProperty("prop1", (Value)Values.stringValue((String)"e1a"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e2", v1, v3, "label1", VISIBILITY_A).setProperty("prop1", (Value)Values.stringValue((String)"e2"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e3", v2, v3, "label1", VISIBILITY_A).setProperty("prop1", (Value)Values.stringValue((String)"e3"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("e1");
        ids.add("e2");
        Iterable edges = this.getGraph().getEdges(ids, AUTHORIZATIONS_A);
        boolean foundE1 = false;
        boolean foundE2 = false;
        for (Edge e : edges) {
            if (e.getId().equals("e1")) {
                GeAssert.assertEquals((Object)Values.stringValue((String)"e1"), (Object)e.getPropertyValue("prop1"));
                foundE1 = true;
                continue;
            }
            if (e.getId().equals("e2")) {
                GeAssert.assertEquals((Object)Values.stringValue((String)"e2"), (Object)e.getPropertyValue("prop1"));
                foundE2 = true;
                continue;
            }
            GeAssert.assertTrue((String)("Unexpected vertex id: " + e.getId()), (boolean)false);
        }
        GeAssert.assertTrue((String)"e1 not found", (boolean)foundE1);
        GeAssert.assertTrue((String)"e2 not found", (boolean)foundE2);
    }

    @Test
    public void testMarkVertexAndPropertiesHidden() {
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "age", (Value)Values.intValue((int)25), VISIBILITY_EMPTY).addPropertyValue("k2", "age", (Value)Values.intValue((int)30), VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_ALL);
        this.getGraph().markVertexHidden(v1, VISIBILITY_A, AUTHORIZATIONS_ALL);
        for (Property property : v1.getProperties()) {
            v1.markPropertyHidden(property, VISIBILITY_A, AUTHORIZATIONS_ALL);
        }
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertNull((String)"v1 was found", (Object)v1);
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_ALL);
        GeAssert.assertNotNull((String)"could not find v1", (Object)v1);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        GeAssert.assertEquals((Object)Values.intValue((int)25), (Object)v1.getPropertyValue("k1", "age"));
        GeAssert.assertEquals((Object)Values.intValue((int)30), (Object)v1.getPropertyValue("k2", "age"));
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_ALL);
        this.getGraph().markVertexVisible(v1, VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        Vertex v1AfterVisible = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertNotNull((String)"could not find v1", (Object)v1AfterVisible);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1AfterVisible.getProperties()));
        for (Property property : v1.getProperties()) {
            v1.markPropertyVisible(property, VISIBILITY_A, AUTHORIZATIONS_ALL);
        }
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertNotNull((String)"could not find v1", (Object)v1);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        GeAssert.assertEquals((Object)Values.intValue((int)25), (Object)v1.getPropertyValue("k1", "age"));
        GeAssert.assertEquals((Object)Values.intValue((int)30), (Object)v1.getPropertyValue("k2", "age"));
    }

    @Test
    public void testRebuildIndexAfterPropertyVisibilityChange() {
        String propertyName = "first.name";
        this.getGraph().defineProperty(propertyName).dataType(TextValue.class).sortable(true).textIndexHint((Collection)TextIndexHint.ALL).define();
        String vertexId = "v1";
        String propertyKey = "k1";
        this.getGraph().prepareVertex(vertexId, VISIBILITY_EMPTY, "thing").addPropertyValue(propertyKey, propertyName, (Value)Values.stringValue((String)"Joe"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        QueryResultsIterable results = this.getGraph().query(AUTHORIZATIONS_ALL).has(propertyName, (Value)Values.stringValue((String)"joe")).sort(propertyName, SortDirection.ASCENDING).vertexIds();
        GeAssert.assertIdsAnyOrder((Iterable)results, (String[])new String[]{vertexId});
        this.getGraph().getVertex(vertexId, AUTHORIZATIONS_ALL).prepareMutation().alterPropertyVisibility(propertyKey, propertyName, VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        results = this.getGraph().query(AUTHORIZATIONS_ALL).has(propertyName, (Value)Values.stringValue((String)"joe")).sort(propertyName, SortDirection.ASCENDING).vertexIds();
        GeAssert.assertIdsAnyOrder((Iterable)results, (String[])new String[]{vertexId});
        SearchIndex searchIndex = ((GraphWithSearchIndex)this.getGraph()).getSearchIndex();
        searchIndex.drop(this.getGraph());
        searchIndex.addElements(this.getGraph(), Collections.singletonList(this.getGraph().getVertex(vertexId, AUTHORIZATIONS_ALL)), AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        results = this.getGraph().query(AUTHORIZATIONS_ALL).has(propertyName, (Value)Values.stringValue((String)"joe")).sort(propertyName, SortDirection.ASCENDING).vertexIds();
        GeAssert.assertIdsAnyOrder((Iterable)results, (String[])new String[]{vertexId});
    }

    @Test
    public void testMarkVertexHidden() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().addEdge("v1tov2", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        ArrayList<String> vertexIdList = new ArrayList<String>();
        vertexIdList.add("v1");
        vertexIdList.add("v2");
        vertexIdList.add("bad");
        Map verticesExist = this.getGraph().doVerticesExist(vertexIdList, AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)3L, (long)vertexIdList.size());
        GeAssert.assertTrue((String)"v1 exist", (boolean)((Boolean)verticesExist.get("v1")));
        GeAssert.assertTrue((String)"v2 exist", (boolean)((Boolean)verticesExist.get("v2")));
        GeAssert.assertFalse((String)"bad exist", (boolean)((Boolean)verticesExist.get("bad")));
        GeAssert.assertTrue((String)"v1 exists (auth A)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_A));
        GeAssert.assertFalse((String)"v1 exists (auth B)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_B));
        GeAssert.assertTrue((String)"v1 exists (auth A&B)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_A_AND_B));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
        this.getGraph().markVertexHidden(v1, VISIBILITY_A_AND_B, AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertTrue((String)"v1 exists (auth A)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_A));
        GeAssert.assertFalse((String)"v1 exists (auth B)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_B));
        GeAssert.assertFalse((String)"v1 exists (auth A&B)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_A_AND_B));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
        this.getGraph().markVertexHidden(v1, VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertFalse((String)"v1 exists (auth A)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_A));
        GeAssert.assertFalse((String)"v1 exists (auth B)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_B));
        GeAssert.assertFalse((String)"v1 exists (auth A&B)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_A_AND_B));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_B)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
        GeAssert.assertNull((String)"found v1 but shouldn't have", (Object)this.getGraph().getVertex("v1", this.getGraph().getDefaultFetchHints(), AUTHORIZATIONS_A));
        Vertex v1Hidden = this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A);
        GeAssert.assertNotNull((String)"did not find v1 but should have", (Object)v1Hidden);
        GeAssert.assertTrue((String)"v1 should be hidden", (boolean)v1Hidden.isHidden(AUTHORIZATIONS_A));
        this.getGraph().markVertexVisible(v1, VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertTrue((String)"v1 exists (auth A)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_A));
        GeAssert.assertFalse((String)"v1 exists (auth B)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_B));
        GeAssert.assertFalse((String)"v1 exists (auth A&B)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_A_AND_B));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
        this.getGraph().markVertexVisible(v1, VISIBILITY_A_AND_B, AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertTrue((String)"v1 exists (auth A)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_A));
        GeAssert.assertFalse((String)"v1 exists (auth B)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_B));
        GeAssert.assertTrue((String)"v1 exists (auth A&B)", (boolean)this.getGraph().doesVertexExist("v1", AUTHORIZATIONS_A_AND_B));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
    }

    @Test
    public void testMarkEdgeHidden() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        Edge e1 = this.getGraph().addEdge("v1tov2", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().addEdge("v2tov3", v2, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        ArrayList<String> edgeIdList = new ArrayList<String>();
        edgeIdList.add("v1tov2");
        edgeIdList.add("v2tov3");
        edgeIdList.add("bad");
        Map edgesExist = this.getGraph().doEdgesExist(edgeIdList, AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)3L, (long)edgeIdList.size());
        GeAssert.assertTrue((String)"v1tov2 exist", (boolean)((Boolean)edgesExist.get("v1tov2")));
        GeAssert.assertTrue((String)"v2tov3 exist", (boolean)((Boolean)edgesExist.get("v2tov3")));
        GeAssert.assertFalse((String)"bad exist", (boolean)((Boolean)edgesExist.get("bad")));
        GeAssert.assertTrue((String)"v1tov2 exists (auth A)", (boolean)this.getGraph().doesEdgeExist("v1tov2", AUTHORIZATIONS_A));
        GeAssert.assertFalse((String)"v1tov2 exists (auth B)", (boolean)this.getGraph().doesEdgeExist("v1tov2", AUTHORIZATIONS_B));
        GeAssert.assertTrue((String)"v1tov2 exists (auth A&B)", (boolean)this.getGraph().doesEdgeExist("v1tov2", AUTHORIZATIONS_A_AND_B));
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getEdges(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 2), AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 10), AUTHORIZATIONS_A_AND_B)));
        this.getGraph().markEdgeHidden(e1, VISIBILITY_A_AND_B, AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertTrue((String)"v1tov2 exists (auth A)", (boolean)this.getGraph().doesEdgeExist("v1tov2", AUTHORIZATIONS_A));
        GeAssert.assertFalse((String)"v1tov2 exists (auth B)", (boolean)this.getGraph().doesEdgeExist("v1tov2", AUTHORIZATIONS_B));
        GeAssert.assertFalse((String)"v1tov2 exists (auth A&B)", (boolean)this.getGraph().doesEdgeExist("v1tov2", AUTHORIZATIONS_A_AND_B));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getEdges(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getEdges(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getEdgeInfos(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A_AND_B).getEdges(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A_AND_B).getEdges(Direction.BOTH, FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A_AND_B).getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A_AND_B).getEdgeInfos(Direction.BOTH, AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 2), AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 10), AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 10), AUTHORIZATIONS_A)));
        GeAssert.assertNull((String)"found e1 but shouldn't have", (Object)this.getGraph().getEdge("v1tov2", this.getGraph().getDefaultFetchHints(), AUTHORIZATIONS_A_AND_B));
        Edge e1Hidden = this.getGraph().getEdge("v1tov2", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A_AND_B);
        GeAssert.assertNotNull((String)"did not find e1 but should have", (Object)e1Hidden);
        GeAssert.assertTrue((String)"e1 should be hidden", (boolean)e1Hidden.isHidden(AUTHORIZATIONS_A_AND_B));
        this.getGraph().markEdgeVisible(e1, VISIBILITY_A_AND_B, AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertTrue((String)"v1tov2 exists (auth A)", (boolean)this.getGraph().doesEdgeExist("v1tov2", AUTHORIZATIONS_A));
        GeAssert.assertFalse((String)"v1tov2 exists (auth B)", (boolean)this.getGraph().doesEdgeExist("v1tov2", AUTHORIZATIONS_B));
        GeAssert.assertTrue((String)"v1tov2 exists (auth A&B)", (boolean)this.getGraph().doesEdgeExist("v1tov2", AUTHORIZATIONS_A_AND_B));
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getEdges(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 2), AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().findPaths(new FindPathOptions("v1", "v3", 10), AUTHORIZATIONS_A_AND_B)));
    }

    @Test
    public void testSearchingForHiddenEdges() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        Edge e1 = this.getGraph().addEdge("v1tov2", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_ALL);
        Edge e2 = this.getGraph().addEdge("v2tov3", v2, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        this.getGraph().markEdgeHidden(e1, VISIBILITY_B, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        FetchHints propertiesFetchHints = FetchHints.builder().setIncludeAllProperties(true).build();
        QueryResultsIterable edges = this.getGraph().query(AUTHORIZATIONS_A).edges(propertiesFetchHints);
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)edges);
        GeAssert.assertEdgeIdsAnyOrder((Iterable)edges, (String[])new String[]{e1.getId(), e2.getId()});
        edges = this.getGraph().query(AUTHORIZATIONS_A_AND_B).edges(propertiesFetchHints);
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)edges);
        GeAssert.assertEdgeIdsAnyOrder((Iterable)edges, (String[])new String[]{e2.getId()});
        this.getGraph().markEdgeVisible(e1, VISIBILITY_B, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        edges = this.getGraph().query(AUTHORIZATIONS_A_AND_B).edges(propertiesFetchHints);
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)edges);
        GeAssert.assertEdgeIdsAnyOrder((Iterable)edges, (String[])new String[]{e1.getId(), e2.getId()});
    }

    @Test
    public void testMarkPropertyHidden() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addPropertyValue("key1", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_B).addPropertyValue("key2", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        Vertex vvv = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)vvv.getProperties("prop1")));
        v1.markPropertyHidden("key1", "prop1", VISIBILITY_A, VISIBILITY_A_AND_B, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        List properties = IterableUtils.toList((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getProperties("prop1"));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)properties));
        boolean foundProp1Key2 = false;
        boolean foundProp1Key1VisB = false;
        for (Property property : properties) {
            if (property.getName().equals("prop1")) {
                if (property.getKey().equals("key2")) {
                    foundProp1Key2 = true;
                    continue;
                }
                if (property.getKey().equals("key1")) {
                    if (property.getVisibility().equals((Object)VISIBILITY_B)) {
                        foundProp1Key1VisB = true;
                        continue;
                    }
                    throw new RuntimeException("Unexpected visibility " + property.getVisibility());
                }
                throw new RuntimeException("Unexpected property key " + property.getKey());
            }
            throw new RuntimeException("Unexpected property name " + property.getName());
        }
        GeAssert.assertTrue((String)"Prop1Key2 not found", (boolean)foundProp1Key2);
        GeAssert.assertTrue((String)"Prop1Key1VisB not found", (boolean)foundProp1Key1VisB);
        List hiddenProperties = IterableUtils.toList((Iterable)this.getGraph().getVertex("v1", FetchHints.ALL_INCLUDING_HIDDEN, AUTHORIZATIONS_A_AND_B).getProperties());
        GeAssert.assertEquals((long)3L, (long)hiddenProperties.size());
        boolean foundProp1Key1VisA = false;
        foundProp1Key2 = false;
        foundProp1Key1VisB = false;
        for (Property property : hiddenProperties) {
            if (property.getName().equals("prop1")) {
                if (property.getKey().equals("key2")) {
                    foundProp1Key2 = true;
                    GeAssert.assertFalse((String)"should not be hidden", (boolean)property.isHidden(AUTHORIZATIONS_A_AND_B));
                    continue;
                }
                if (property.getKey().equals("key1")) {
                    if (property.getVisibility().equals((Object)VISIBILITY_A)) {
                        foundProp1Key1VisA = true;
                        GeAssert.assertFalse((String)"should not be hidden", (boolean)property.isHidden(AUTHORIZATIONS_A));
                        GeAssert.assertTrue((String)"should be hidden", (boolean)property.isHidden(AUTHORIZATIONS_A_AND_B));
                        continue;
                    }
                    if (property.getVisibility().equals((Object)VISIBILITY_B)) {
                        foundProp1Key1VisB = true;
                        GeAssert.assertFalse((String)"should not be hidden", (boolean)property.isHidden(AUTHORIZATIONS_A_AND_B));
                        continue;
                    }
                    throw new RuntimeException("Unexpected visibility " + property.getVisibility());
                }
                throw new RuntimeException("Unexpected property key " + property.getKey());
            }
            throw new RuntimeException("Unexpected property name " + property.getName());
        }
        GeAssert.assertTrue((String)"Prop1Key2 not found", (boolean)foundProp1Key2);
        GeAssert.assertTrue((String)"Prop1Key1VisB not found", (boolean)foundProp1Key1VisB);
        GeAssert.assertTrue((String)"Prop1Key1VisA not found", (boolean)foundProp1Key1VisA);
        v1.markPropertyVisible("key1", "prop1", VISIBILITY_A, VISIBILITY_A_AND_B, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getProperties("prop1")));
    }

    @Test
    public void testSearchingForHiddenVertices() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        Vertex v2 = (Vertex)this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").addPropertyValue("key1", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        this.getGraph().markVertexHidden(v1, VISIBILITY_B, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        FetchHints propertiesFetchHints = FetchHints.builder().setIncludeAllProperties(true).build();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Value)Values.stringValue((String)"value1")).vertices(propertiesFetchHints);
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{v1.getId(), v2.getId()});
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop1", (Value)Values.stringValue((String)"value1")).vertices(propertiesFetchHints);
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{v2.getId()});
        this.getGraph().markVertexVisible(v1, VISIBILITY_B, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop1", (Value)Values.stringValue((String)"value1")).vertices(propertiesFetchHints);
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{v1.getId(), v2.getId()});
    }

    @Test
    public void testMarkVertexHiddenAndDeleteEdges() {
        Vertex w1 = this.getGraph().addVertex("w1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex w2 = this.getGraph().addVertex("w2", VISIBILITY_B, AUTHORIZATIONS_B, "thing");
        Vertex e1 = this.getGraph().addVertex("e1", VISIBILITY_EMPTY, AUTHORIZATIONS_A, "thing");
        Vertex e2 = this.getGraph().addVertex("e2", VISIBILITY_EMPTY, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("w1-e1", w1, e1, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("w2-e1", w2, e1, "label1", VISIBILITY_B, AUTHORIZATIONS_B);
        this.getGraph().addEdge("e1-e2", e1, e2, "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A);
        this.getGraph().flush();
        e1 = this.getGraph().getVertex("e1", AUTHORIZATIONS_EMPTY);
        this.getGraph().markVertexHidden(e1, VISIBILITY_A, AUTHORIZATIONS_EMPTY);
        this.getGraph().flush();
        w1 = this.getGraph().getVertex("w1", AUTHORIZATIONS_A);
        this.getGraph().deleteVertex("w1", AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((Object)"e2", (Object)((Vertex)IterableUtils.toList((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)).get(0)).getId());
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_B)));
        boolean foundW2 = false;
        boolean foundE1 = false;
        boolean foundE2 = false;
        for (Vertex v : this.getGraph().getVertices(AUTHORIZATIONS_B)) {
            if (v.getId().equals("w2")) {
                foundW2 = true;
                continue;
            }
            if (v.getId().equals("e1")) {
                foundE1 = true;
                continue;
            }
            if (v.getId().equals("e2")) {
                foundE2 = true;
                continue;
            }
            throw new GeException("Unexpected id: " + v.getId());
        }
        GeAssert.assertTrue((String)"w2", (boolean)foundW2);
        GeAssert.assertTrue((String)"e1", (boolean)foundE1);
        GeAssert.assertTrue((String)"e2", (boolean)foundE2);
    }

    @Test
    public void testDeleteVertexWithProperties() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Property prop1 = v1.getProperty("prop1");
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A)));
        this.getGraph().deleteVertex("v1", AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_A_AND_B)));
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new AddVertexEvent(this.getGraph(), v1), new AddPropertyEvent(this.getGraph(), (Element)v1, prop1), new DeleteVertexEvent(this.getGraph(), v1)});
    }

    @Test
    public void testSaveElementMutations() {
        ArrayList<Object> mutations = new ArrayList<Object>();
        for (int i = 0; i < 2; ++i) {
            ElementBuilder m = this.getGraph().prepareVertex("v" + i, VISIBILITY_A, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"joe"), VISIBILITY_A).addExtendedData("table1", "row1", "col1", (Value)Values.stringValue((String)"extended"), VISIBILITY_A);
            mutations.add(m);
        }
        List saveVertices = IterableUtils.toList((Iterable)this.getGraph().saveElementMutations(mutations, AUTHORIZATIONS_ALL));
        this.getGraph().flush();
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[]{new AddVertexEvent(this.getGraph(), (Vertex)saveVertices.get(0)), new AddPropertyEvent(this.getGraph(), (Element)saveVertices.get(0), ((Element)saveVertices.get(0)).getProperty("k1", "name")), new AddExtendedDataEvent(this.getGraph(), (Element)saveVertices.get(0), "table1", "row1", "col1", null, (Value)Values.stringValue((String)"extended"), VISIBILITY_A), new AddVertexEvent(this.getGraph(), (Vertex)saveVertices.get(1)), new AddPropertyEvent(this.getGraph(), (Element)saveVertices.get(1), ((Element)saveVertices.get(1)).getProperty("k1", "name")), new AddExtendedDataEvent(this.getGraph(), (Element)saveVertices.get(1), "table1", "row1", "col1", null, (Value)Values.stringValue((String)"extended"), VISIBILITY_A)});
        GeAssert.clearGraphEvents();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_ALL).vertices();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)vertices);
        QueryResultsIterable items = this.getGraph().query(AUTHORIZATIONS_ALL).has("col1", (Value)Values.stringValue((String)"extended")).search();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)items);
        mutations.clear();
        mutations.add(((Vertex)saveVertices.get(0)).prepareMutation());
        this.getGraph().saveElementMutations(mutations, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        GeAssert.assertEvents((GraphEvent[])new GraphEvent[0]);
    }

    @Test
    public void testSaveCombinedElementMutations() {
        VertexBuilder m;
        int i;
        ArrayList<VertexBuilder> mutations = new ArrayList<VertexBuilder>();
        for (i = 0; i < 2; ++i) {
            m = this.getGraph().prepareEdge("v" + i, "v" + (i + 1), "label1", VISIBILITY_A);
            mutations.add(m);
        }
        for (i = 0; i < 3; ++i) {
            m = this.getGraph().prepareVertex("v" + i, VISIBILITY_A, "thing");
            mutations.add(m);
        }
        Iterable elements = this.getGraph().saveElementMutations(mutations, AUTHORIZATIONS_ALL);
        GeAssert.assertEquals((long)5L, (long)IterableUtils.count((Iterable)elements));
    }

    @Test
    public void testAddValuesToExistingProperties() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        this.getGraph().flush();
        this.getGraph().defineProperty("p1").dataType(TextValue.class).sortable(true).textIndexHint((Collection)TextIndexHint.ALL).define();
        v1.addPropertyValue("k1", "p1", (Value)Values.stringValue((String)"val1"), VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        GeAssert.assertIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"val1")).vertexIds(), (String[])new String[]{"v1"});
        v1.addPropertyValue("k2", "p1", (Value)Values.stringValue((String)"val2"), VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        GeAssert.assertIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"val1")).vertexIds(), (String[])new String[]{"v1"});
        GeAssert.assertIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"val2")).vertexIds(), (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"val3")).vertexIds());
        v1.addPropertyValue("k1", "p1", (Value)Values.stringValue((String)"val3"), VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        GeAssert.assertIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"val3")).vertexIds(), (String[])new String[]{"v1"});
        GeAssert.assertIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"val2")).vertexIds(), (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"val1")).vertexIds());
    }

    @Test
    public void testRemoveValuesFromMultivalueProperties() {
        this.getGraph().defineProperty("p1").dataType(TextValue.class).sortable(true).textIndexHint((Collection)TextIndexHint.ALL).define();
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("k1", "p1", (Value)Values.stringValue((String)"v1"), VISIBILITY_A).addPropertyValue("k2", "p1", (Value)Values.stringValue((String)"v2"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        GeAssert.assertIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"v1")).vertexIds(), (String[])new String[]{"v1"});
        GeAssert.assertIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"v2")).vertexIds(), (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"v3")).vertexIds());
        v1.prepareMutation().addPropertyValue("k3", "p1", (Value)Values.stringValue((String)"v3"), VISIBILITY_A).deleteProperty("k1", "p1", VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        GeAssert.assertIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"v2")).vertexIds(), (String[])new String[]{"v1"});
        GeAssert.assertIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"v3")).vertexIds(), (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"v1")).vertexIds());
        v1.deleteProperty("k2", "p1", VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        GeAssert.assertIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"v3")).vertexIds(), (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"v1")).vertexIds());
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_ALL).has("p1", (Value)Values.stringValue((String)"v2")).vertexIds());
    }

    @Test
    public void testGetVertexWithBadAuthorizations() {
        this.getGraph().addVertex("v1", VISIBILITY_EMPTY, AUTHORIZATIONS_A, "thing");
        this.getGraph().flush();
        try {
            this.getGraph().getVertex("v1", AUTHORIZATIONS_BAD);
            throw new RuntimeException("Should throw " + SecurityGeException.class.getSimpleName());
        }
        catch (SecurityGeException securityGeException) {
            return;
        }
    }

    @Test
    public void testGetVerticesFromVertex() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v4 = this.getGraph().addVertex("v4", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v5 = this.getGraph().addVertex("v5", VISIBILITY_B, AUTHORIZATIONS_B, "thing");
        this.getGraph().addEdge(v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v1, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v1, v4, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v2, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v2, v5, "label1", VISIBILITY_A, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)v1.getVertices(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)v1.getVertices(Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getVertices(Direction.IN, AUTHORIZATIONS_A)));
        v2 = this.getGraph().getVertex("v2", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v2.getVertices(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v2.getVertices(Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v2.getVertices(Direction.IN, AUTHORIZATIONS_A)));
        v3 = this.getGraph().getVertex("v3", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v3.getVertices(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v3.getVertices(Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v3.getVertices(Direction.IN, AUTHORIZATIONS_A)));
        v4 = this.getGraph().getVertex("v4", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v4.getVertices(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v4.getVertices(Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v4.getVertices(Direction.IN, AUTHORIZATIONS_A)));
    }

    @Test
    public void testGetVertexIdsFromVertex() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v4 = this.getGraph().addVertex("v4", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v5 = this.getGraph().addVertex("v5", VISIBILITY_B, AUTHORIZATIONS_B, "thing");
        this.getGraph().addEdge(v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v1, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v1, v4, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v2, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge(v2, v5, "label1", VISIBILITY_A, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)v1.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)v1.getVertexIds(Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getVertexIds(Direction.IN, AUTHORIZATIONS_A)));
        v2 = this.getGraph().getVertex("v2", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)v2.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v2.getVertexIds(Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v2.getVertexIds(Direction.IN, AUTHORIZATIONS_A)));
        v3 = this.getGraph().getVertex("v3", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v3.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v3.getVertexIds(Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v3.getVertexIds(Direction.IN, AUTHORIZATIONS_A)));
        v4 = this.getGraph().getVertex("v4", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v4.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v4.getVertexIds(Direction.OUT, AUTHORIZATIONS_A)));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v4.getVertexIds(Direction.IN, AUTHORIZATIONS_A)));
    }

    @Test
    public void testBlankVisibilityString() {
        Vertex v = this.getGraph().addVertex("v1", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
        GeAssert.assertNotNull((Object)v);
        GeAssert.assertEquals((Object)"v1", (Object)v.getId());
        this.getGraph().flush();
        v = this.getGraph().getVertex("v1", AUTHORIZATIONS_EMPTY);
        GeAssert.assertNotNull((Object)v);
        GeAssert.assertEquals((Object)"v1", (Object)v.getId());
        GeAssert.assertEquals((Object)VISIBILITY_EMPTY, (Object)v.getVisibility());
    }

    @Test
    public void testElementMutationDoesntChangeObjectUntilSave() {
        Vertex v = this.getGraph().addVertex("v1", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL, "thing");
        v.setProperty("prop1", (Value)Values.stringValue((String)"value1-1"), VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        ElementMutation m = v.prepareMutation().setProperty("prop1", (Value)Values.stringValue((String)"value1-2"), VISIBILITY_A).setProperty("prop2", (Value)Values.stringValue((String)"value2-2"), VISIBILITY_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v.getProperties()));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1-1"), (Object)v.getPropertyValue("prop1"));
        v = (Vertex)m.save(AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v.getProperties()));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1-2"), (Object)v.getPropertyValue("prop1"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2-2"), (Object)v.getPropertyValue("prop2"));
    }

    @Test
    public void testEmptyPropertyMutation() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        v1.prepareMutation().save(AUTHORIZATIONS_ALL);
    }

    @Test
    public void testThreadedInserts() throws InterruptedException {
        AtomicInteger completedThreads = new AtomicInteger();
        new Thread(() -> {
            this.getGraph().addVertex("v1", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
            this.getGraph().flush();
            completedThreads.incrementAndGet();
        }).start();
        new Thread(() -> {
            this.getGraph().addVertex("v2", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
            this.getGraph().flush();
            completedThreads.incrementAndGet();
        }).start();
        while (completedThreads.get() < 2) {
            Thread.sleep(100L);
        }
        GeAssert.assertVertexIdsAnyOrder((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_EMPTY), (String[])new String[]{"v1", "v2"});
        GeAssert.assertVertexIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_EMPTY).vertices(), (String[])new String[]{"v1", "v2"});
    }

    @Test
    public void testThreadedInsertsNoFlushesInThreads() throws InterruptedException {
        AtomicInteger completedThreads = new AtomicInteger();
        new Thread(() -> {
            this.getGraph().addVertex("v1", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
            completedThreads.incrementAndGet();
        }).start();
        new Thread(() -> {
            this.getGraph().addVertex("v2", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
            completedThreads.incrementAndGet();
        }).start();
        while (completedThreads.get() < 2) {
            Thread.sleep(100L);
        }
        this.getGraph().flush();
        for (int i = 0; i <= 10; ++i) {
            try {
                GeAssert.assertVertexIdsAnyOrder((Iterable)this.getGraph().getVertices(AUTHORIZATIONS_EMPTY), (String[])new String[]{"v1", "v2"});
                GeAssert.assertVertexIdsAnyOrder((Iterable)this.getGraph().query(AUTHORIZATIONS_EMPTY).vertices(), (String[])new String[]{"v1", "v2"});
                break;
            }
            catch (AssertionError ex) {
                if (i == 10) {
                    throw ex;
                }
                Thread.sleep(500L);
                continue;
            }
        }
    }

    @Test
    public void testVertexHashCodeAndEquals() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        Vertex v2 = (Vertex)this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Vertex v1Loaded = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)v1Loaded.hashCode(), (long)v1.hashCode());
        GeAssert.assertTrue((boolean)v1Loaded.equals(v1));
        GeAssert.assertNotEquals((Object)v1Loaded.hashCode(), (Object)v2.hashCode());
        GeAssert.assertFalse((boolean)v1Loaded.equals(v2));
    }

    @Test
    public void testEdgeHashCodeAndEquals() {
        Vertex v1 = this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        Vertex v2 = this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        Edge e1 = (Edge)this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_A).setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        Edge e2 = (Edge)this.getGraph().prepareEdge("e2", v1, v2, "label1", VISIBILITY_A).setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Edge e1Loaded = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)e1Loaded.hashCode(), (long)e1.hashCode());
        GeAssert.assertTrue((boolean)e1Loaded.equals(e1));
        GeAssert.assertNotEquals((Object)e1Loaded.hashCode(), (Object)e2.hashCode());
        GeAssert.assertFalse((boolean)e1Loaded.equals(e2));
    }

    @Test
    public void testAddVertexWithoutIndexing() {
        Assume.assumeTrue((String)"add vertex without indexing not supported", (!this.isDefaultSearchIndex() ? 1 : 0) != 0);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).setIndexHint(IndexHint.DO_NOT_INDEX).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop1", (Value)Values.stringValue((String)"value1")).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[0]);
    }

    @Test
    public void testAlterVertexWithoutIndexing() {
        Assume.assumeTrue((String)"alter vertex without indexing not supported", (!this.isDefaultSearchIndex() ? 1 : 0) != 0);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setIndexHint(IndexHint.DO_NOT_INDEX).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        v1.prepareMutation().setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).setIndexHint(IndexHint.DO_NOT_INDEX).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Value)Values.stringValue((String)"value1")).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[0]);
    }

    @Test
    public void testAddEdgeWithoutIndexing() {
        Assume.assumeTrue((String)"add edge without indexing not supported", (!this.isDefaultSearchIndex() ? 1 : 0) != 0);
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_A).setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).setIndexHint(IndexHint.DO_NOT_INDEX).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable edges = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop1", (Value)Values.stringValue((String)"value1")).edges();
        GeAssert.assertEdgeIds((Iterable)edges, (String[])new String[0]);
    }

    @Test
    public void testLargeFieldValuesThatAreMarkedWithExactMatch() {
        this.getGraph().defineProperty("field1").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        StringBuilder largeText = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            largeText.append("test ");
        }
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("", "field1", (Value)Values.stringValue((String)largeText.toString()), VISIBILITY_EMPTY).save(AUTHORIZATIONS_EMPTY);
        this.getGraph().flush();
    }

    @Test
    public void testReturningAlterConceptAndEdgeType() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.intValue((int)1), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        Vertex v2 = (Vertex)this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("prop2", (Value)Values.intValue((int)1), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        Edge e1 = (Edge)this.getGraph().prepareEdge(v1, v2, "label1", VISIBILITY_A).setProperty("p1", (Value)Values.intValue((int)1), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((Object)"thing", (Object)v1.getConceptType());
        e1 = (Edge)e1.prepareMutation().alterEdgeLabel("label2").setProperty("p1", (Value)Values.intValue((int)2), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((Object)Values.intValue((int)2), (Object)e1.getProperty("p1").getValue());
        GeAssert.assertEquals((Object)"label2", (Object)e1.getLabel());
        v1 = (Vertex)v1.prepareMutation().alterConceptType("person").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((Object)"person", (Object)v1.getConceptType());
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((Object)"person", (Object)v1.getConceptType());
    }

    @Test
    public void testMetricsRepositoryStackTraceTracker() {
        StackTraceTracker flushStackTraceTracker = this.getGraph().getMetricsRegistry().getStackTraceTracker(this.getGraph().getClass(), new String[]{"flush", "stack"});
        this.getGraph().addVertex("vPrimer", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().flush();
        flushStackTraceTracker.reset();
        GeAssert.assertStackTraceTrackerCount((StackTraceTracker)flushStackTraceTracker, path -> {
            StackTraceTracker.StackTraceItem item = (StackTraceTracker.StackTraceItem)path.get(path.size() - 1);
            GeAssert.assertEquals((String)("count mismatch: " + item), (long)0L, (long)item.getCount());
        });
        this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().flush();
        GeAssert.assertStackTraceTrackerCount((StackTraceTracker)flushStackTraceTracker, path -> {
            StackTraceTracker.StackTraceItem item = (StackTraceTracker.StackTraceItem)path.get(path.size() - 1);
            GeAssert.assertEquals((String)("count mismatch: " + item), (long)1L, (long)item.getCount());
        });
        this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().flush();
        GeAssert.assertStackTraceTrackerCount((StackTraceTracker)flushStackTraceTracker, path -> {
            int expectedCount = 2;
            for (StackTraceTracker.StackTraceItem item : path) {
                if (item.toString().contains("testMetricsRepositoryStackTraceTracker")) {
                    expectedCount = 1;
                }
                GeAssert.assertEquals((String)("count mismatch: " + item), (long)expectedCount, (long)item.getCount());
            }
        });
    }

    @Test
    public void testDataTypes() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).prepareMutation().addPropertyValue("", "int", (Value)Values.intValue((int)5), VISIBILITY_A).addPropertyValue("", "intArray", (Value)Values.intArray((int[])new int[]{1, 2, 3}), VISIBILITY_A).addPropertyValue("", "double", (Value)Values.doubleValue((double)5.6), VISIBILITY_A).addPropertyValue("", "doubleArray", (Value)Values.doubleArray((double[])new double[]{5.6, 234.344, 123.777}), VISIBILITY_A).addPropertyValue("", "float", (Value)Values.floatValue((float)6.4f), VISIBILITY_A).addPropertyValue("", "float", (Value)Values.floatArray((float[])new float[]{6.4f, 45.66f, 12.66f}), VISIBILITY_A).addPropertyValue("", "string", (Value)Values.stringValue((String)"test"), VISIBILITY_A).addPropertyValue("", "stringArray", (Value)Values.stringArray((String[])new String[]{"str1", "str2", "str3", "str4"}), VISIBILITY_A).addPropertyValue("", "byte", (Value)Values.byteValue((byte)5), VISIBILITY_A).addPropertyValue("", "byteArray", (Value)Values.byteArray((byte[])"hello world".getBytes()), VISIBILITY_A).addPropertyValue("", "long", (Value)Values.longValue((long)5L), VISIBILITY_A).addPropertyValue("", "longArray", (Value)Values.longArray((long[])new long[]{5L, 6L, 7L}), VISIBILITY_A).addPropertyValue("", "boolean", (Value)BooleanValue.TRUE, VISIBILITY_A).addPropertyValue("", "booleanArray", (Value)Values.booleanArray((boolean[])new boolean[]{true, false, true, true}), VISIBILITY_A).addPropertyValue("", "geopoint", (Value)Values.geoPointValue((double)77.0, (double)-33.0), VISIBILITY_A).addPropertyValue("", "short", (Value)Values.shortValue((short)5), VISIBILITY_A).addPropertyValue("", "shortArray", (Value)Values.shortArray((short[])new short[]{1, 2, 3}), VISIBILITY_A).addPropertyValue("", "datetime", (Value)DateTimeValue.datetime((ZonedDateTime)ZonedDateTime.now()), VISIBILITY_A).addPropertyValue("", "dateTimeArray", (Value)Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[]{ZonedDateTime.now(), ZonedDateTime.now().plusMinutes(1L), ZonedDateTime.now().plusMinutes(2L)}), VISIBILITY_A).addPropertyValue("", "date", (Value)DateValue.date((LocalDate)LocalDate.now()), VISIBILITY_A).addPropertyValue("", "dateArray", (Value)Values.dateArray((LocalDate[])new LocalDate[]{LocalDate.now(), LocalDate.now().plusDays(1L), LocalDate.now().plusDays(2L)}), VISIBILITY_A).addPropertyValue("", "time", (Value)TimeValue.now((Clock)Clock.systemUTC()), VISIBILITY_A).addPropertyValue("", "timeArray", (Value)Values.timeArray((OffsetTime[])new OffsetTime[]{OffsetTime.now(), OffsetTime.now().plusMinutes(1L), OffsetTime.now().plusMinutes(2L)}), VISIBILITY_A).addPropertyValue("", "localDateTime", (Value)LocalDateTimeValue.now((Clock)Clock.systemUTC()), VISIBILITY_A).addPropertyValue("", "localDateTimeArray", (Value)Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[]{LocalDateTime.now(), LocalDateTime.now().plusMinutes(1L), LocalDateTime.now().plusMinutes(2L)}), VISIBILITY_A).addPropertyValue("", "localTime", (Value)LocalTimeValue.now((Clock)Clock.systemUTC()), VISIBILITY_A).addPropertyValue("", "localTimeArray", (Value)Values.localTimeArray((LocalTime[])new LocalTime[]{LocalTime.now(), LocalTime.now().plusMinutes(1L), LocalTime.now().plusMinutes(2L)}), VISIBILITY_A).addPropertyValue("", "duration", (Value)DurationValue.duration((Duration)Duration.ofHours(1L)), VISIBILITY_A).addPropertyValue("", "durationArray", (Value)Values.durationArray((DurationValue[])new DurationValue[]{DurationValue.duration((Duration)Duration.ofHours(1L)), DurationValue.duration((Duration)Duration.ofDays(1L)), DurationValue.duration((Period)Period.ofDays(1))}), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
    }

    @Test
    public void testEdgeIdFetchHints() {
        Vertex v1 = this.graph.prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        Vertex v2 = this.graph.prepareVertex("v2", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        Vertex v3 = this.graph.prepareVertex("v3", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.graph.prepareEdge(v1, v2, "label1", VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.graph.prepareEdge(v1, v3, "label1", VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.graph.flush();
        FetchHints fetchHintsNoEdgeIds = new FetchHintsBuilder(FetchHints.ALL).setIncludeEdgeIds(false).build();
        Vertex v1NoEdgeIds = this.graph.getVertex("v1", fetchHintsNoEdgeIds, AUTHORIZATIONS_A);
        Vertex v2NoEdgeIds = this.graph.getVertex("v2", fetchHintsNoEdgeIds, AUTHORIZATIONS_A);
        GeAssert.assertThrowsException(() -> v1NoEdgeIds.getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A));
        GeAssert.assertThrowsException(() -> v1NoEdgeIds.getEdgeIds(Direction.BOTH, "label1", AUTHORIZATIONS_A));
        GeAssert.assertThrowsException(() -> v1NoEdgeIds.getEdgeIds(Direction.BOTH, new String[]{"label1"}, AUTHORIZATIONS_A));
        GeAssert.assertThrowsException(() -> v1NoEdgeIds.getEdgeIds(v2NoEdgeIds, Direction.BOTH, AUTHORIZATIONS_A));
        GeAssert.assertThrowsException(() -> v1NoEdgeIds.getEdgeIds(v2NoEdgeIds, Direction.BOTH, "label1", AUTHORIZATIONS_A));
        GeAssert.assertThrowsException(() -> v1NoEdgeIds.getEdgeIds(v2NoEdgeIds, Direction.BOTH, new String[]{"label1"}, AUTHORIZATIONS_A));
        Assert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v1NoEdgeIds.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A)));
        for (EdgeInfo edgeInfo : v1NoEdgeIds.getEdgeInfos(Direction.BOTH, AUTHORIZATIONS_A)) {
            edgeInfo.getVertexId();
            edgeInfo.getLabel();
            edgeInfo.getDirection();
            GeAssert.assertThrowsException(() -> ((EdgeInfo)edgeInfo).getEdgeId());
        }
        FetchHints fetchHintsNoEdgeVertexIds = new FetchHintsBuilder(FetchHints.ALL).setIncludeEdgeVertexIds(false).build();
        Vertex v1NoEdgeVertexIds = this.graph.getVertex("v1", fetchHintsNoEdgeVertexIds, AUTHORIZATIONS_A);
        GeAssert.assertThrowsException(() -> v1NoEdgeVertexIds.getVertexIds(Direction.BOTH, AUTHORIZATIONS_A));
        GeAssert.assertThrowsException(() -> v1NoEdgeVertexIds.getVertexIds(Direction.BOTH, "label1", AUTHORIZATIONS_A));
        GeAssert.assertThrowsException(() -> v1NoEdgeVertexIds.getVertexIds(Direction.BOTH, new String[]{"label1"}, AUTHORIZATIONS_A));
        Assert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v1NoEdgeVertexIds.getEdgeIds(Direction.BOTH, AUTHORIZATIONS_A)));
        for (EdgeInfo edgeInfo : v1NoEdgeVertexIds.getEdgeInfos(Direction.BOTH, AUTHORIZATIONS_A)) {
            GeAssert.assertThrowsException(() -> ((EdgeInfo)edgeInfo).getVertexId());
            edgeInfo.getLabel();
            edgeInfo.getDirection();
            edgeInfo.getEdgeId();
        }
        GeAssert.assertThrowsException(() -> new FetchHintsBuilder(FetchHints.ALL).setIncludeEdgeVertexIds(false).setIncludeEdgeIds(false).build());
        new FetchHintsBuilder(FetchHints.ALL).setIncludeAllEdgeRefs(false).setIncludeOutEdgeRefs(false).setIncludeInEdgeRefs(false).setIncludeEdgeVertexIds(false).setIncludeEdgeIds(false).build();
    }

    private boolean isDefaultSearchIndex() {
        Graph graph = this.getGraph();
        if (!(graph instanceof GraphWithSearchIndex)) {
            return false;
        }
        GraphWithSearchIndex graphWithSearchIndex = (GraphWithSearchIndex)graph;
        return graphWithSearchIndex.getSearchIndex() instanceof DefaultSearchIndex;
    }
}

