/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.ElementBuilder;
import com.mware.ge.ElementType;
import com.mware.ge.Visibility;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElementBuilderTest {
    private TestElementBuilder mutation;

    @Before
    public void before() {
        this.mutation = new TestElementBuilder();
    }

    @Test
    public void testEmptyMutationHasChanges() {
        Assert.assertFalse((String)"should not have changes", (boolean)this.mutation.hasChanges());
    }

    @Test
    public void testHasChangesProperties() {
        this.mutation.addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"value1"), new Visibility(""));
        Assert.assertTrue((String)"should have changes", (boolean)this.mutation.hasChanges());
    }

    @Test
    public void testHasChangesDeleteProperty() {
        this.mutation.deleteProperty("key1", "name1", new Visibility(""));
        Assert.assertTrue((String)"should have changes", (boolean)this.mutation.hasChanges());
    }

    @Test
    public void testHasChangesSoftDeleteProperty() {
        this.mutation.softDeleteProperty("key1", "name1", new Visibility(""));
        Assert.assertTrue((String)"should have changes", (boolean)this.mutation.hasChanges());
    }

    private static class TestElementBuilder<T extends Element>
    extends ElementBuilder<T> {
        protected TestElementBuilder() {
            super(ElementType.VERTEX, "element1", new Visibility(""));
        }

        public T save(Authorizations authorizations) {
            return null;
        }
    }
}

