/*
 * Decompiled with CFR 0.152.
 */
package com.mware.bigconnect.image;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.mware.bigconnect.image.ImageTransform;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ImageTransformExtractor {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(ImageTransformExtractor.class);

    public static ImageTransform getImageTransform(byte[] data) {
        return ImageTransformExtractor.getImageTransform(new ByteArrayInputStream(data));
    }

    public static ImageTransform getImageTransform(InputStream inputStream) {
        try {
            BufferedInputStream in = new BufferedInputStream(inputStream);
            Metadata metadata = ImageMetadataReader.readMetadata((InputStream)in);
            return ImageTransformExtractor.getImageTransformFromMetadata(metadata);
        }
        catch (ImageProcessingException e) {
            LOGGER.error("drewnoakes metadata extractor threw ImageProcessingException when reading metadata. Returning default orientation for image.", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("drewnoakes metadata extractor threw IOException when reading metadata. Returning default orientation for image.", (Throwable)e);
        }
        return ImageTransformExtractor.getNoFlipNoRotationImageTransform();
    }

    public static ImageTransform getImageTransform(File localFile) {
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((File)localFile);
            return ImageTransformExtractor.getImageTransformFromMetadata(metadata);
        }
        catch (ImageProcessingException e) {
            LOGGER.error("drewnoakes metadata extractor threw ImageProcessingException when reading metadata. Returning default orientation for image.", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("drewnoakes metadata extractor threw IOException when reading metadata. Returning default orientation for image.", (Throwable)e);
        }
        return ImageTransformExtractor.getNoFlipNoRotationImageTransform();
    }

    private static ImageTransform getImageTransformFromMetadata(Metadata metadata) {
        Integer orientationInteger;
        ExifIFD0Directory directory;
        ImageTransform imageTransform = ImageTransformExtractor.getNoFlipNoRotationImageTransform();
        if (metadata != null && (directory = (ExifIFD0Directory)metadata.getFirstDirectoryOfType(ExifIFD0Directory.class)) != null && (orientationInteger = directory.getInteger(274)) != null) {
            imageTransform = ImageTransformExtractor.convertOrientationToTransform(orientationInteger);
        }
        return imageTransform;
    }

    private static ImageTransform getNoFlipNoRotationImageTransform() {
        return new ImageTransform(false, 0);
    }

    public static ImageTransform convertOrientationToTransform(int orientationInt) {
        switch (orientationInt) {
            case 1: {
                return ImageTransformExtractor.getNoFlipNoRotationImageTransform();
            }
            case 2: {
                return new ImageTransform(true, 0);
            }
            case 3: {
                return new ImageTransform(false, 180);
            }
            case 4: {
                return new ImageTransform(true, 180);
            }
            case 5: {
                return new ImageTransform(true, 270);
            }
            case 6: {
                return new ImageTransform(false, 90);
            }
            case 7: {
                return new ImageTransform(true, 90);
            }
            case 8: {
                return new ImageTransform(false, 270);
            }
        }
        return ImageTransformExtractor.getNoFlipNoRotationImageTransform();
    }
}

