/*
 * Decompiled with CFR 0.152.
 */
package com.mware.bigconnect.ffmpeg;

import com.google.common.base.Preconditions;
import com.mware.bigconnect.ffmpeg.AVMediaInfo;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.collection.Pair;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.ToLongFunction;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.bramp.ffmpeg.FFmpeg;
import net.bramp.ffmpeg.FFmpegExecutor;
import net.bramp.ffmpeg.FFprobe;
import net.bramp.ffmpeg.ProcessFunction;
import net.bramp.ffmpeg.builder.FFmpegBuilder;
import net.bramp.ffmpeg.builder.FFmpegOutputBuilder;
import net.bramp.ffmpeg.probe.FFmpegProbeResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class AVUtils {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(AVUtils.class);

    public static FFprobe ffprobe() throws IOException {
        String path = System.getenv("FFPROBE");
        return !StringUtils.isEmpty((CharSequence)path) ? new FFprobe(path) : new FFprobe();
    }

    public static FFmpeg ffmpeg() throws IOException {
        String path = System.getenv("FFMPEG");
        return !StringUtils.isEmpty((CharSequence)path) ? new FFmpeg(path) : new FFmpeg();
    }

    public static FFmpeg ffmpeg(ProcessFunction runFunction) throws IOException {
        String path = System.getenv("FFMPEG");
        return !StringUtils.isEmpty((CharSequence)path) ? new FFmpeg(path, runFunction) : new FFmpeg(runFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] createVideoPosterFrame(Path videoFile) {
        byte[] byArray;
        File destFile;
        block6: {
            FFmpegProbeResult probeResult = AVMediaInfo.probe(videoFile.toString());
            if (probeResult == null) {
                return new byte[0];
            }
            double duration = probeResult.format.duration;
            destFile = null;
            destFile = Files.createTempFile("poster-", ".png", new FileAttribute[0]).toFile();
            FFmpegOutputBuilder output = (FFmpegOutputBuilder)((FFmpegOutputBuilder)((FFmpegOutputBuilder)((FFmpegOutputBuilder)new FFmpegOutputBuilder().setVideoCodec("png")).setFrames(1)).disableAudio()).setFilename(destFile.getAbsolutePath());
            FFmpegBuilder builder = AVUtils.ffmpeg().builder().setInput(probeResult).addOutput(output).overrideOutputFiles(true).addExtraArgs(new String[]{"-itsoffset"}).addExtraArgs(new String[]{"-" + duration / 3.0});
            FFmpegExecutor executor = new FFmpegExecutor(AVUtils.ffmpeg(), AVUtils.ffprobe());
            executor.createJob(builder).run();
            if (!destFile.exists()) break block6;
            byte[] byArray2 = Files.readAllBytes(destFile.toPath());
            FileUtils.deleteQuietly((File)destFile);
            return byArray2;
        }
        try {
            LOGGER.warn("Failed to extract poster frame for an unknown reason.", new Object[0]);
            byArray = new byte[]{};
        }
        catch (IOException e) {
            try {
                LOGGER.warn("Could not create poster frame for video file: " + videoFile, new Object[0]);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(destFile);
                throw throwable;
            }
            FileUtils.deleteQuietly((File)destFile);
            return new byte[0];
        }
        FileUtils.deleteQuietly((File)destFile);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage createVideoPreviewImage(Path videoFileName) {
        tempDir = null;
        try {
            block26: {
                probeResult = AVMediaInfo.probe(videoFileName.toFile().getAbsolutePath());
                if (probeResult == null) {
                    var3_6 = null;
                    return var3_6;
                }
                videoDuration = probeResult.format.duration;
                defaultFPSToExtract = 1.0;
                if (videoDuration <= 20.0) {
                    defaultFPSToExtract = 20.0 / videoDuration;
                }
                tempDir = Files.createTempDirectory("frames-", new FileAttribute[0]).toFile();
                output = (FFmpegOutputBuilder)new FFmpegOutputBuilder().setFilename(new File(tempDir, "image-%8d.png").getAbsolutePath());
                builder = AVUtils.ffmpeg().builder().setInput(videoFileName.toFile().getAbsolutePath()).addOutput(output).addExtraArgs(new String[]{"-r"}).addExtraArgs(new String[]{String.valueOf(defaultFPSToExtract)});
                executor = new FFmpegExecutor(AVUtils.ffmpeg(), AVUtils.ffprobe());
                executor.createJob(builder).run();
                fileNamePattern = Pattern.compile("image-([0-9]+)\\.png");
                videoFrames = new ArrayList<Pair>();
                for (File frameFile : tempDir.listFiles()) {
                    m = fileNamePattern.matcher(frameFile.getName());
                    if (!m.matches()) continue;
                    frameStartTime = (long)(Double.parseDouble(m.group(1)) / defaultFPSToExtract * 1000.0);
                    videoFrames.add(Pair.of((Object)frameStartTime, (Object)frameFile));
                }
                videoFrames.sort(Comparator.comparingLong((ToLongFunction<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, first(), (Lcom/mware/ge/collection/Pair;)J)()));
                framesForPreview = new ArrayList<E>();
                skip = (double)videoFrames.size() / 20.0;
                for (i = 0.0; i < (double)videoFrames.size(); i += skip) {
                    framesForPreview.add(videoFrames.get((int)Math.floor(i)));
                }
                if (framesForPreview.size() < 20) {
                    framesForPreview.add(videoFrames.get(videoFrames.size() - 1));
                }
                if (framesForPreview.size() > 20) {
                    framesForPreview.remove(framesForPreview.size() - 1);
                }
                previewFrameWidth = 360;
                previewFrameHeight = 240;
                previewImage = null;
                g = null;
                for (i = 0; i < framesForPreview.size(); ++i) {
                    videoFrame = (Pair)framesForPreview.get(i);
                    img = AVUtils.loadImage((File)videoFrame.other());
                    widthImage = img.getWidth(null);
                    heightImage = img.getHeight(null);
                    if (i == 0) {
                        ratioContainer = (float)previewFrameWidth / (float)previewFrameHeight;
                        ratioImage = (float)widthImage / (float)heightImage;
                        if (ratioContainer > ratioImage) {
                            calculatedWidth = (float)widthImage * ((float)previewFrameHeight / (float)heightImage);
                            calculatedHeight = previewFrameHeight;
                        } else {
                            calculatedWidth = previewFrameWidth;
                            calculatedHeight = (float)heightImage * ((float)previewFrameWidth / (float)widthImage);
                        }
                        previewFrameWidth = (int)calculatedWidth;
                        previewFrameHeight = (int)calculatedHeight;
                        previewImage = new BufferedImage(previewFrameWidth * framesForPreview.size(), previewFrameHeight, 1);
                        g = previewImage.createGraphics();
                    }
                    dx1 = i * previewFrameWidth;
                    dy1 = 0;
                    dx2 = dx1 + previewFrameWidth;
                    dy2 = previewFrameHeight;
                    sx1 = 0;
                    sy1 = 0;
                    g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, widthImage, heightImage, null);
                }
                if (previewImage == null) break block26;
                g.dispose();
                var19_28 = previewImage;
                ** try [egrp 3[TRYBLOCK] [1 : 694->701)] { 
lbl73:
                // 1 sources

                ** GOTO lbl-1000
            }
            ** try [egrp 4[TRYBLOCK] [2 : 706->713)] { 
lbl76:
            // 1 sources

            ** GOTO lbl-1000
        }
        catch (IOException ex) {
            AVUtils.LOGGER.warn("Could not generate video preview.", (Throwable)ex);
            return null;
        }
lbl-1000:
        // 1 sources

        {
            FileUtils.deleteDirectory((File)tempDir);
            return var19_28;
        }
lbl82:
        // 1 sources

        catch (IOException var20_30) {
            // empty catch block
        }
        return var19_28;
lbl-1000:
        // 1 sources

        {
            FileUtils.deleteDirectory((File)tempDir);
            return null;
        }
lbl87:
        // 1 sources

        catch (IOException probeResult) {
            return null;
        }
        finally {
            try {
                FileUtils.deleteDirectory(tempDir);
            }
            catch (IOException var2_5) {}
        }
    }

    private static BufferedImage loadImage(File videoFrame) throws IOException {
        try (FileInputStream spvIn = new FileInputStream(videoFrame);){
            BufferedImage img = ImageIO.read(spvIn);
            Preconditions.checkNotNull((Object)img, (Object)("Could not load image from frame: " + videoFrame));
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
    }
}

