/*
 * Decompiled with CFR 0.152.
 */
package com.mware.bigconnect.ffmpeg;

import com.mware.bigconnect.ffmpeg.AVUtils;
import com.mware.bigconnect.ffmpeg.AudioCodec;
import com.mware.bigconnect.ffmpeg.AudioFormat;
import com.mware.bigconnect.ffmpeg.VideoCodec;
import com.mware.bigconnect.ffmpeg.VideoFormat;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.collection.Pair;
import com.mware.ge.type.GeoPoint;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.bramp.ffmpeg.FFprobe;
import net.bramp.ffmpeg.probe.FFmpegProbeResult;
import net.bramp.ffmpeg.probe.FFmpegStream;
import org.apache.commons.lang3.StringUtils;

public class AVMediaInfo {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(AVMediaInfo.class);

    public static FFmpegProbeResult probe(String absolutePath) {
        try {
            FFprobe ffProbe = AVUtils.ffprobe();
            return ffProbe.probe(absolutePath);
        }
        catch (IOException e) {
            LOGGER.error("exception running ffprobe", (Throwable)e);
            return null;
        }
    }

    public static boolean hasVideoStream(FFmpegProbeResult probeResult) {
        List streams = probeResult.getStreams();
        if (streams != null) {
            for (FFmpegStream stream : streams) {
                if (stream.codec_type != FFmpegStream.CodecType.VIDEO) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAudioStream(FFmpegProbeResult probeResult) {
        List streams = probeResult.getStreams();
        if (streams != null) {
            for (FFmpegStream stream : streams) {
                if (stream.codec_type != FFmpegStream.CodecType.AUDIO) continue;
                return true;
            }
        }
        return false;
    }

    public static VideoFormat getVideoFormat(FFmpegProbeResult probeResult) {
        if (!AVMediaInfo.hasVideoStream(probeResult)) {
            return null;
        }
        switch (probeResult.getFormat().format_name) {
            case "matroska,webm": {
                return VideoFormat.WEBM;
            }
            case "mov,mp4,m4a,3gp,3g2,mj2": {
                return VideoFormat.MP4;
            }
        }
        return VideoFormat.UNKNOWN;
    }

    public static AudioFormat getAudioFormat(FFmpegProbeResult probeResult) {
        if (!AVMediaInfo.hasAudioStream(probeResult)) {
            return null;
        }
        switch (probeResult.getFormat().format_name) {
            case "matroska,webm": {
                return AudioFormat.WEBM;
            }
            case "ogg": {
                return AudioFormat.OGG;
            }
            case "mov,mp4,m4a,3gp,3g2,mj2": {
                return AudioFormat.MP4;
            }
            case "mp3": {
                return AudioFormat.MP3;
            }
            case "wav": {
                return AudioFormat.WAV;
            }
        }
        return AudioFormat.UNKNOWN;
    }

    public static VideoCodec getVideoCodec(FFmpegProbeResult probeResult) {
        if (!AVMediaInfo.hasVideoStream(probeResult)) {
            return null;
        }
        for (FFmpegStream stream : probeResult.getStreams()) {
            if (stream.codec_type != FFmpegStream.CodecType.VIDEO) continue;
            return AVMediaInfo.parseVideoCodec(stream.codec_name);
        }
        return null;
    }

    public static AudioCodec getAudioCodec(FFmpegProbeResult probeResult) {
        if (!AVMediaInfo.hasAudioStream(probeResult)) {
            return null;
        }
        for (FFmpegStream stream : probeResult.getStreams()) {
            if (stream.codec_type != FFmpegStream.CodecType.AUDIO) continue;
            return AVMediaInfo.parseAudioCodec(stream.codec_name);
        }
        return null;
    }

    public static boolean isVideoPlayable(FFmpegProbeResult probeResult) {
        if (!AVMediaInfo.hasVideoStream(probeResult)) {
            return false;
        }
        VideoFormat format = AVMediaInfo.getVideoFormat(probeResult);
        VideoCodec codec = AVMediaInfo.getVideoCodec(probeResult);
        return format != VideoFormat.UNKNOWN && codec != VideoCodec.UNKNOWN;
    }

    public static boolean isAudioPlayable(FFmpegProbeResult probeResult) {
        if (!AVMediaInfo.hasAudioStream(probeResult)) {
            return false;
        }
        AudioFormat format = AVMediaInfo.getAudioFormat(probeResult);
        AudioCodec codec = AVMediaInfo.getAudioCodec(probeResult);
        return format != AudioFormat.UNKNOWN && codec != AudioCodec.UNKNOWN;
    }

    private static VideoCodec parseVideoCodec(String codec_name) {
        if (StringUtils.isEmpty((CharSequence)codec_name)) {
            return null;
        }
        switch (codec_name) {
            case "av1": {
                return VideoCodec.AV1;
            }
            case "h264": {
                return VideoCodec.H264;
            }
            case "theora": {
                return VideoCodec.THEORA;
            }
            case "vp8": {
                return VideoCodec.VP8;
            }
            case "vp9": {
                return VideoCodec.VP9;
            }
        }
        return VideoCodec.UNKNOWN;
    }

    private static AudioCodec parseAudioCodec(String codec_name) {
        if (StringUtils.isEmpty((CharSequence)codec_name)) {
            return null;
        }
        switch (codec_name) {
            case "aac": {
                return AudioCodec.AAC;
            }
            case "flac": {
                return AudioCodec.FLAC;
            }
            case "pcm_alaw": 
            case "pcm_mulaw": {
                return AudioCodec.G711;
            }
            case "adpcm_g722": {
                return AudioCodec.G722;
            }
            case "mp3": {
                return AudioCodec.MP3;
            }
            case "opus": {
                return AudioCodec.OPUS;
            }
            case "vorbis": {
                return AudioCodec.VORBIS;
            }
        }
        if (codec_name.startsWith("pcm_")) {
            return AudioCodec.PCM;
        }
        return AudioCodec.UNKNOWN;
    }

    public static Pair<Integer, Integer> getDimensions(FFmpegProbeResult probeResult) {
        if (probeResult == null) {
            return null;
        }
        List streams = probeResult.getStreams();
        if (streams != null) {
            for (FFmpegStream stream : streams) {
                if (stream.codec_type != FFmpegStream.CodecType.VIDEO) continue;
                return Pair.of((Object)stream.width, (Object)stream.height);
            }
        }
        return null;
    }

    public static ZonedDateTime getDateTaken(FFmpegProbeResult ffprobe) {
        if (ffprobe == null) {
            return null;
        }
        Map tags = ffprobe.getFormat().tags;
        if (tags != null) {
            Date date;
            String dateTaken = null;
            String optionalDateTaken = (String)tags.get("date");
            if (!StringUtils.isEmpty((CharSequence)optionalDateTaken)) {
                dateTaken = optionalDateTaken;
            } else {
                String optionalDateTakenEng = (String)tags.get("date-eng");
                if (!StringUtils.isEmpty((CharSequence)optionalDateTakenEng)) {
                    dateTaken = optionalDateTakenEng;
                }
            }
            if (dateTaken != null && !dateTaken.equals("") && (date = AVMediaInfo.parseDateTakenString(dateTaken)) != null) {
                return ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.systemDefault());
            }
        }
        LOGGER.debug("Could not extract dateTaken from json.", new Object[0]);
        return null;
    }

    public static GeoPoint getGeoPoint(FFmpegProbeResult probeResult) {
        GeoPoint geoPoint;
        String locationString;
        if (probeResult == null) {
            return null;
        }
        Map tags = probeResult.getFormat().tags;
        if (tags != null && !StringUtils.isEmpty((CharSequence)(locationString = (String)tags.get("location"))) && (geoPoint = AVMediaInfo.parseGeoLocationString(locationString)) != null) {
            return geoPoint;
        }
        LOGGER.debug("Could not retrieve a \"geoLocation\" value from the JSON object.", new Object[0]);
        return null;
    }

    private static GeoPoint parseGeoLocationString(String locationString) {
        String myRegularExpression = "(\\+|\\-|/)";
        String[] tempValues = locationString.split(myRegularExpression);
        String[] values = AVMediaInfo.removeNullsFromStringArray(tempValues);
        if (values.length < 2) {
            return null;
        }
        String latitudeValue = values[0];
        String latitudeSign = "";
        int indexOfLatitude = locationString.indexOf(latitudeValue);
        if (indexOfLatitude != 0) {
            latitudeSign = locationString.substring(0, 1);
        }
        String latitudeString = latitudeSign + latitudeValue;
        Double latitude = Double.parseDouble(latitudeString);
        String longitudeValue = values[1];
        String longitudeSign = "";
        int indexOfLongitude = locationString.indexOf(longitudeValue, indexOfLatitude + latitudeValue.length());
        String longitudePreviousChar = locationString.substring(indexOfLongitude - 1, indexOfLongitude);
        if (longitudePreviousChar.equals("-") || longitudePreviousChar.equals("+")) {
            longitudeSign = longitudePreviousChar;
        }
        String longitudeString = longitudeSign + longitudeValue;
        Double longitude = Double.parseDouble(longitudeString);
        String altitudeValue = null;
        Double altitude = null;
        if (values.length == 3) {
            altitudeValue = values[2];
            String altitudeSign = "";
            int indexOfAltitude = locationString.indexOf(altitudeValue, indexOfLongitude + longitudeValue.length());
            String altitudePreviousChar = locationString.substring(indexOfAltitude - 1, indexOfAltitude);
            if (altitudePreviousChar.equals("-") || altitudePreviousChar.equals("+")) {
                altitudeSign = altitudePreviousChar;
            }
            String altitudeString = altitudeSign + altitudeValue;
            altitude = Double.parseDouble(altitudeString);
        }
        if (latitude != null && longitude != null && altitude != null) {
            return new GeoPoint(latitude.doubleValue(), longitude.doubleValue(), altitude.doubleValue());
        }
        if (latitude != null && longitude != null && altitude == null) {
            return new GeoPoint(latitude.doubleValue(), longitude.doubleValue());
        }
        return null;
    }

    public static String[] removeNullsFromStringArray(String[] array) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || array[i].equals("")) continue;
            arrayList.add(array[i]);
        }
        String[] newArray = arrayList.toArray(new String[arrayList.size()]);
        return newArray;
    }

    private static Date parseDateTakenString(String dateTaken) {
        String dateFormat = "yyyy-MM-dd'T'HH:mm:ssZ";
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        try {
            Date parsedDate = format.parse(dateTaken);
            return parsedDate;
        }
        catch (ParseException e) {
            LOGGER.debug("ParseException: could not parse dateTaken: " + dateTaken + " with date format: " + dateFormat, new Object[0]);
            return null;
        }
    }
}

