/*
 * Decompiled with CFR 0.152.
 */
package com.bidtorrent.bidding;

import com.google.common.base.Function;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class PooledHttpClient {
    private final Timer timer;
    private ClientConnectionManager connectionManager;
    private HttpParams httpParameters;
    private Gson gson;
    private ListeningExecutorService executorService;
    private final LinkedBlockingQueue<PendingTask> pendingTasks;
    private boolean isNetworkAvailable;

    public PooledHttpClient(int timeout, boolean isNetworkAvailable) {
        this.isNetworkAvailable = isNetworkAvailable;
        this.gson = new GsonBuilder().create();
        this.httpParameters = new BasicHttpParams();
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpParameters, (int)timeout);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        this.connectionManager = new ThreadSafeClientConnManager(this.httpParameters, schemeRegistry);
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        this.pendingTasks = new LinkedBlockingQueue();
        this.timer = new Timer("pooledhttptimer");
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PooledHttpClient.this.runPendingTasks();
            }
        }, 0L, 500L);
    }

    public ListenableFuture<String> doGet(final String url) {
        return this.createFutureTask(new Callable<String>(){

            @Override
            public String call() throws Exception {
                HttpGet httpGet = new HttpGet(url);
                HttpResponse response = PooledHttpClient.this.getClient().execute((HttpUriRequest)httpGet);
                return PooledHttpClient.parseResponse(response);
            }
        });
    }

    private static String parseResponse(HttpResponse response) throws IOException {
        if (response != null && response.getEntity() != null) {
            return new String(ByteStreams.toByteArray((InputStream)response.getEntity().getContent()));
        }
        return null;
    }

    private DefaultHttpClient getClient() {
        DefaultHttpClient httpClient = new DefaultHttpClient(this.connectionManager, this.httpParameters);
        return httpClient;
    }

    public <T> ListenableFuture<T> jsonGet(String url, final Class<T> type) {
        return Futures.transform(this.doGet(url), (Function)new Function<String, T>(){

            @Nullable
            public T apply(String input) {
                if (input == null) {
                    return null;
                }
                return PooledHttpClient.this.gson.fromJson(input, type);
            }
        });
    }

    public <T> ListenableFuture<T> jsonGet(String url, final Type type) {
        return Futures.transform(this.doGet(url), (Function)new Function<String, T>(){

            @Nullable
            public T apply(String input) {
                if (input == null) {
                    return null;
                }
                return PooledHttpClient.this.gson.fromJson(input, type);
            }
        });
    }

    public <U, V> ListenableFuture<V> jsonPost(final String url, final U request, final Class<V> responseType) {
        return this.createFutureTask(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return PooledHttpClient.this.doPost(url, request, responseType);
            }
        });
    }

    private <U, V> V doPost(String url, U request, Class<V> responseType) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        StringEntity postJson = new StringEntity(this.gson.toJson(request));
        postJson.setContentType("application/json");
        httpPost.setEntity((HttpEntity)postJson);
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicClientCookie ids = new BasicClientCookie("Ids", "a%3A1%3A%7Bi%3A42%3Bs%3A36%3A%226024c0db-5907-4d5c-b43f-da5d7d8a3035%22%3B%7D");
        ids.setDomain("bidtorrent.io");
        ids.setPath("/");
        cookieStore.addCookie((Cookie)ids);
        DefaultHttpClient httpClient = this.getClient();
        httpClient.setCookieStore((CookieStore)cookieStore);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String responseJson = PooledHttpClient.parseResponse(response);
        if (responseJson == null) {
            return null;
        }
        return (V)this.gson.fromJson(responseJson, responseType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPendingTasks() {
        if (this.isNetworkAvailable) {
            LinkedBlockingQueue<PendingTask> linkedBlockingQueue = this.pendingTasks;
            synchronized (linkedBlockingQueue) {
                while (!this.pendingTasks.isEmpty()) {
                    PendingTask pendingTask;
                    if (!this.isNetworkAvailable || (pendingTask = this.pendingTasks.poll()) == null) continue;
                    this.executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            pendingTask.execute();
                        }
                    });
                }
            }
        }
    }

    public void setNetworkAvailable(boolean isNetworkAvailable) {
        this.isNetworkAvailable = isNetworkAvailable;
        this.runPendingTasks();
    }

    private <T> SettableFuture<T> createFutureTask(Callable<T> callable) {
        SettableFuture future = SettableFuture.create();
        this.pendingTasks.add(new PendingTask(future, callable));
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                PooledHttpClient.this.runPendingTasks();
            }
        });
        return future;
    }

    private class PendingTask<T> {
        public static final int INITIAL_RETRIES_COUNT = 3;
        private SettableFuture<T> future;
        private Callable<T> callable;
        private int pendingIntents;

        private PendingTask(SettableFuture<T> future, Callable<T> callable) {
            this.future = future;
            this.callable = callable;
            this.pendingIntents = 3;
        }

        public void execute() {
            try {
                T t = this.callable.call();
                this.future.set(t);
            }
            catch (Exception e) {
                --this.pendingIntents;
                if (this.pendingIntents == 0) {
                    this.future.setException((Throwable)e);
                }
                PooledHttpClient.this.pendingTasks.add(this);
            }
        }
    }
}

