/*
 * Decompiled with CFR 0.152.
 */
package com.bidtorrent.bidding;

import com.bidtorrent.bidding.BidOpportunity;
import com.bidtorrent.bidding.IBidder;
import com.bidtorrent.bidding.IErrorCallback;
import com.bidtorrent.bidding.IResponseConverter;
import com.bidtorrent.bidding.PooledHttpClient;
import com.bidtorrent.bidding.messages.App;
import com.bidtorrent.bidding.messages.Banner;
import com.bidtorrent.bidding.messages.BidRequest;
import com.bidtorrent.bidding.messages.BidResponse;
import com.bidtorrent.bidding.messages.Device;
import com.bidtorrent.bidding.messages.Ext;
import com.bidtorrent.bidding.messages.Geo;
import com.bidtorrent.bidding.messages.Imp;
import com.bidtorrent.bidding.messages.Publisher;
import com.bidtorrent.bidding.messages.User;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;

public class HttpBidder
implements IBidder {
    private long id;
    private final String name;
    private final String bidUrl;
    private final PooledHttpClient pooledHttpClient;

    public HttpBidder(long id, String name, String bidUrl, IResponseConverter<String> responseConverter, int timeout, PooledHttpClient pooledHttpClient) {
        this.id = id;
        this.name = name;
        this.bidUrl = bidUrl;
        this.pooledHttpClient = pooledHttpClient;
    }

    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static BidRequest createBidRequest(BidOpportunity bidOpportunity) {
        return new BidRequest(new User("MyID", "MyID"), new App("www.bbc.com", 1, new Publisher("123", "Yahoo")), "EUR", new Device(new Geo("USA"), "91.199.242.236", 1, "en", "Apple", "iPhone", "iOS", "Mozilla/5.0 (iPhone; CPU iPhone OS 6_1_3 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Mobile/10B329"), "39f95888-0450-4afc-9b8b-eabd81a69ddc", Arrays.asList(new Imp(new Banner(Arrays.asList(4), 300, 1, 250), 1.75f, "1", 1, false)), 100, new Ext(42));
    }

    @Override
    public ListenableFuture<BidResponse> bid(BidOpportunity opportunity, IErrorCallback errorCallback) {
        return this.pooledHttpClient.jsonPost(this.bidUrl, HttpBidder.createBidRequest(opportunity), BidResponse.class);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long getId() {
        return this.id;
    }
}

