/*
 * Decompiled with CFR 0.152.
 */
package com.bidtorrent.bidding;

import com.bidtorrent.bidding.messages.configuration.BidderConfiguration;
import com.bidtorrent.bidding.messages.configuration.PublisherConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;

public class BidderSelector {
    private Collection<BidderConfiguration> bidders;
    private PublisherConfiguration publisherConfiguration;
    private static Random random = ThreadLocalRandom.current();

    public BidderSelector(PublisherConfiguration publisherConfiguration) {
        this.publisherConfiguration = publisherConfiguration;
        this.bidders = new LinkedBlockingQueue<BidderConfiguration>();
    }

    public boolean acceptBidder(PublisherConfiguration publisherConfiguration, BidderConfiguration bidderConfiguration) {
        if (bidderConfiguration.id == null) {
            return false;
        }
        if (bidderConfiguration.bid_ep == null || bidderConfiguration.bid_ep.length() == 0) {
            return false;
        }
        if (bidderConfiguration.filters == null) {
            return true;
        }
        String country = publisherConfiguration.site.publisher.country;
        if (bidderConfiguration.filters.pub_ctry != null && bidderConfiguration.filters.pub_ctry.size() != 0 && country != null && (bidderConfiguration.filters.pub_ctry_wl == Boolean.TRUE ? !bidderConfiguration.filters.pub_ctry.contains(country) : bidderConfiguration.filters.pub_ctry.contains(country))) {
            return false;
        }
        String user_lang = Locale.getDefault().getDisplayLanguage();
        if (bidderConfiguration.filters.user_lang != null && bidderConfiguration.filters.user_lang.size() != 0 && (bidderConfiguration.filters.user_lang_wl != null && bidderConfiguration.filters.user_lang_wl == true ? !bidderConfiguration.filters.user_lang.contains(user_lang) : bidderConfiguration.filters.user_lang.contains(user_lang))) {
            return false;
        }
        List<String> cat_bl = publisherConfiguration.site.cat;
        if (bidderConfiguration.filters.cat_bl != null && cat_bl != null && cat_bl.size() > 0) {
            for (String cat : cat_bl) {
                if (!bidderConfiguration.filters.cat_bl.contains(cat)) continue;
                return false;
            }
        }
        return true;
    }

    public void addBidder(BidderConfiguration bidder) {
        this.bidders.add(bidder);
    }

    public List<BidderConfiguration> getAvailableBidders() {
        LinkedList<BidderConfiguration> bidderConfigurations = new LinkedList<BidderConfiguration>(this.bidders);
        Collections.shuffle(bidderConfigurations);
        ArrayList<BidderConfiguration> availableBidders = new ArrayList<BidderConfiguration>(PublisherConfiguration.maximumBidders);
        for (BidderConfiguration bidder : bidderConfigurations) {
            if (bidder.filters != null && bidder.filters.sampling.floatValue() < random.nextFloat() * 100.0f) continue;
            availableBidders.add(bidder);
            if (availableBidders.size() <= PublisherConfiguration.maximumBidders) continue;
            return availableBidders;
        }
        return availableBidders;
    }
}

