/*
 * Decompiled with CFR 0.152.
 */
package com.bidtorrent.bidding;

import com.bidtorrent.bidding.Auction;
import com.bidtorrent.bidding.AuctionResult;
import com.bidtorrent.bidding.BidOpportunity;
import com.bidtorrent.bidding.IAuctioneer;
import com.bidtorrent.bidding.IBidder;
import com.bidtorrent.bidding.IErrorCallback;
import com.bidtorrent.bidding.messages.BidResponse;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public class Auctioneer
implements IAuctioneer {
    public final long timeout;
    private final ExecutorService executor;

    public Auctioneer(long timeout, ExecutorService executor) {
        this.timeout = timeout;
        this.executor = executor;
    }

    @Override
    public Future<AuctionResult> runAuction(final Auction auction) {
        Future<AuctionResult> resultFuture = this.executor.submit(new Callable<AuctionResult>(){

            @Override
            public AuctionResult call() throws ExecutionException, InterruptedException {
                Collection responseFutures = Auctioneer.pushResponseFutures(auction.getOpportunity(), auction.getBidders());
                ListenableFuture responses = Auctioneer.getBidResponses(responseFutures);
                return (AuctionResult)Futures.lazyTransform((Future)responses, (Function)new Function<List<BidResponse>, AuctionResult>(){

                    @Nullable
                    public AuctionResult apply(List<BidResponse> input) {
                        input.removeAll(Collections.singleton(null));
                        return Auctioneer.buildAuctionResult(input, auction.getFloor(), auction.getBidders());
                    }
                }).get();
            }
        });
        return resultFuture;
    }

    private static AuctionResult buildAuctionResult(Collection<BidResponse> responses, float floor, Collection<IBidder> bidders) {
        float secondPrice;
        long runnerUp = 0L;
        TreeSet<BidResponse> sortedResponses = new TreeSet<BidResponse>(responses);
        Iterator iterator = sortedResponses.iterator();
        if (!iterator.hasNext()) {
            return new AuctionResult(null, 0.0f, null, responses, 0L);
        }
        BidResponse winningBid = (BidResponse)iterator.next();
        if (iterator.hasNext()) {
            BidResponse second = (BidResponse)iterator.next();
            secondPrice = second.getPrice();
            runnerUp = second.getBidderId();
        } else {
            secondPrice = floor;
        }
        return new AuctionResult(winningBid, secondPrice, Auctioneer.getBidderById(winningBid.getBidderId(), bidders), sortedResponses, runnerUp);
    }

    private static Collection<ListenableFuture<BidResponse>> pushResponseFutures(BidOpportunity opportunity, List<IBidder> bidders) {
        ArrayList<ListenableFuture<BidResponse>> responseFutures = new ArrayList<ListenableFuture<BidResponse>>(bidders.size());
        for (IBidder bidder : bidders) {
            responseFutures.add(bidder.bid(opportunity, new IErrorCallback(){

                @Override
                public void processError(Exception e) {
                    e.printStackTrace();
                }
            }));
        }
        return responseFutures;
    }

    private static ListenableFuture<List<BidResponse>> getBidResponses(Collection<ListenableFuture<BidResponse>> responseFutures) {
        return Futures.successfulAsList(responseFutures);
    }

    private static IBidder getBidderById(long bidderId, Collection<IBidder> bidders) {
        for (IBidder bidder : bidders) {
            if (bidder.getId() != bidderId) continue;
            return bidder;
        }
        return null;
    }
}

