/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.libraries;

import java.util.Iterator;

public class ImageListIterator
implements Iterator<String> {
    private String[] imageListElts = null;
    private int eltIdx = 0;
    private int maxEltIdx = 0;
    private int imgIdx = 0;
    private int maxImgIdx = -1;
    private boolean oneFileOnly = false;
    private String prefixStr = null;
    private String suffixStr = null;
    private int imageSeqNum = 0;
    private int maxImageSeqNum = -1;

    @Override
    public boolean hasNext() {
        return !(this.imgIdx > this.maxImgIdx && this.eltIdx >= this.maxEltIdx || this.maxImageSeqNum != -1 && this.imageSeqNum >= this.maxImageSeqNum);
    }

    private void nextElement() {
        ++this.eltIdx;
        String elt = this.imageListElts[this.eltIdx];
        int colonIdx = elt.indexOf(58);
        if (colonIdx == -1) {
            this.imgIdx = 1;
            this.maxImgIdx = 0;
            this.prefixStr = null;
            this.suffixStr = null;
            this.oneFileOnly = true;
            return;
        }
        this.oneFileOnly = false;
        int dotIdx = elt.lastIndexOf(46);
        String idxStr = elt.substring(dotIdx - 4, dotIdx);
        this.imgIdx = Integer.valueOf(idxStr);
        String nbImagesStr = elt.substring(colonIdx + 1);
        this.maxImgIdx = this.imgIdx + Integer.valueOf(nbImagesStr) - 1;
        this.prefixStr = elt.substring(0, dotIdx - 4);
        this.suffixStr = elt.substring(dotIdx, colonIdx);
    }

    @Override
    public String next() {
        if (this.imgIdx > this.maxImgIdx) {
            this.nextElement();
        }
        ++this.imageSeqNum;
        if (this.oneFileOnly) {
            return this.imageListElts[this.eltIdx];
        }
        String imgNumStr = String.format("%04d", this.imgIdx);
        ++this.imgIdx;
        return this.prefixStr + imgNumStr + this.suffixStr;
    }

    public ImageListIterator(String imageListString) {
        this.imageListElts = imageListString.split("\\|");
        this.eltIdx = -1;
        this.maxEltIdx = this.imageListElts.length - 1;
    }

    public ImageListIterator(String imageListString, int beginImageSeqNum, int endImageSeqNum) {
        this(imageListString);
        assert (endImageSeqNum == -1 || endImageSeqNum >= beginImageSeqNum);
        this.maxImageSeqNum = endImageSeqNum;
        if (beginImageSeqNum > 1) {
            while (this.imageSeqNum < beginImageSeqNum - 1 && this.eltIdx <= this.maxEltIdx) {
                if (this.imgIdx > this.maxImgIdx) {
                    if (this.eltIdx < this.maxEltIdx) {
                        this.nextElement();
                    } else {
                        this.eltIdx = this.maxEltIdx + 1;
                        break;
                    }
                }
                if (this.oneFileOnly) {
                    ++this.imageSeqNum;
                    continue;
                }
                int finalImageSeqNum = this.imageSeqNum + (this.maxImgIdx - this.imgIdx) + 1;
                if (finalImageSeqNum >= beginImageSeqNum) {
                    this.imgIdx = this.imgIdx + beginImageSeqNum - this.imageSeqNum - 1;
                    this.imageSeqNum = beginImageSeqNum - 1;
                    break;
                }
                this.imgIdx = this.maxImgIdx + 1;
                this.imageSeqNum = finalImageSeqNum;
            }
        }
    }
}

