/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.libraries;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class BDRCReasoner {
    private static boolean inferSymetry = false;
    public static final String BDO = "http://purl.bdrc.io/ontology/core/";
    public static Reasoner INSTANCE = null;

    private static void setSymetry(boolean symetry) {
        inferSymetry = symetry;
        INSTANCE = null;
    }

    public static boolean tagLeaves(Map<String, TaxTreeNode> uriToTreeNode) {
        boolean taggedLeaves = false;
        block0: for (TaxTreeNode n : uriToTreeNode.values()) {
            if (n.ruleToParentDone.booleanValue() || n.parent == null) {
                n.isLeave = false;
                continue;
            }
            for (TaxTreeNode child : n.children) {
                if (child.ruleToParentDone.booleanValue()) continue;
                continue block0;
            }
            n.isLeave = true;
            taggedLeaves = true;
        }
        return taggedLeaves;
    }

    public static List<String> getSubClassofUris(Model m) {
        ArrayList<String> subClassOfUris = new ArrayList<String>();
        StmtIterator it = m.listStatements((Resource)null, m.getProperty(BDO, "taxSubclassRelation"), (RDFNode)null);
        while (it.hasNext()) {
            Statement st = it.nextStatement();
            subClassOfUris.add(st.getObject().asResource().getURI());
        }
        return subClassOfUris;
    }

    public static List<Rule> getTaxonomyRules(Model m) {
        List<String> subClassOfUris = BDRCReasoner.getSubClassofUris(m);
        ArrayList<Rule> res = new ArrayList<Rule>();
        for (String propUri : subClassOfUris) {
            res.addAll(BDRCReasoner.getTaxonomyRules(m, propUri));
        }
        return res;
    }

    public static List<Rule> getTaxonomyRules(Model m, String propUri) {
        int i = 0;
        ArrayList<Rule> res = new ArrayList<Rule>();
        HashMap<String, TaxTreeNode> uriToTreeNode = new HashMap<String, TaxTreeNode>();
        StmtIterator it = m.listStatements((Resource)null, m.getProperty(propUri), (RDFNode)null);
        while (it.hasNext()) {
            TaxTreeNode parent;
            Statement t = it.nextStatement();
            String childUri = t.getSubject().getURI();
            TaxTreeNode child = uriToTreeNode.computeIfAbsent(childUri, x -> new TaxTreeNode((String)x));
            String parentUri = t.getObject().asResource().getURI();
            child.parent = parent = uriToTreeNode.computeIfAbsent(parentUri, x -> new TaxTreeNode((String)x));
            parent.children.add(child);
        }
        while (BDRCReasoner.tagLeaves(uriToTreeNode)) {
            for (TaxTreeNode n : uriToTreeNode.values()) {
                if (!n.isLeave.booleanValue() || n.parent == null) continue;
                String rule = "[tax" + i + ": (?a ?p " + n.uri + ") -> (?a ?p " + n.parent.uri + ")] ";
                res.add(Rule.parseRule((String)rule));
                ++i;
                n.ruleToParentDone = true;
            }
        }
        return res;
    }

    private static List<Rule> getRulesFromModel(Model m) {
        ArrayList<Rule> res = new ArrayList<Rule>();
        String queryString = "PREFIX bdo: <http://purl.bdrc.io/ontology/core/>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nSELECT distinct ?ancestor ?child ?type\nWHERE {\n  {\n     ?child owl:inverseOf ?ancestor .\n     BIND (\"i\" AS ?type)\n  } UNION {\n     ?ancestor a owl:SymmetricProperty .\n     BIND (\"s\" AS ?type).\n     BIND (?ancestor AS ?child)\n  } UNION {\n     ?ancestor bdo:inferSubTree \"true\"^^xsd:boolean .\n     ?child rdfs:subPropertyOf+ ?ancestor .\n     BIND (\"p\" AS ?type)\n  } UNION {\n     ?grandancestor bdo:inferSubTree \"true\"^^xsd:boolean .\n     ?child rdfs:subPropertyOf+ ?ancestor .\n     ?ancestor rdfs:subPropertyOf+ ?grandancestor .\n     BIND (\"p\" AS ?type)\n  } UNION {\n     ?ancestor bdo:inferSubTree \"true\"^^xsd:boolean .\n     ?child rdfs:subClassOf+ ?ancestor .\n     BIND (\"c\" AS ?type)\n  } UNION {\n     ?grandancestor bdo:inferSubTree \"true\"^^xsd:boolean .\n     ?child rdfs:subClassOf+ ?ancestor .\n     ?ancestor rdfs:subClassOf+ ?grandancestor .\n     BIND (\"c\" AS ?type)\n  }\n}\n";
        Query query = QueryFactory.create((String)queryString);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)m);){
            ResultSet results = qexec.execSelect();
            int i = 0;
            while (results.hasNext()) {
                String type;
                QuerySolution soln = results.nextSolution();
                String ancestorString = soln.get("ancestor").asResource().getURI();
                String childString = soln.get("child").asResource().getURI();
                switch (type = soln.get("type").asLiteral().getString()) {
                    case "c": {
                        String ruleString = "[subclass" + i + ": (?a " + RDF.type + " " + childString + ") -> (?a " + RDF.type + " " + ancestorString + ")] ";
                        res.add(Rule.parseRule((String)ruleString));
                        break;
                    }
                    case "p": {
                        String ruleString = "[subprop" + i + ": (?a " + childString + " ?b) -> (?a " + ancestorString + " ?b)] ";
                        res.add(Rule.parseRule((String)ruleString));
                        break;
                    }
                    case "s": {
                        if (!inferSymetry) break;
                        String ruleString = "[sym" + i + ": (?a " + ancestorString + " ?b) -> (?b " + ancestorString + " ?a)] ";
                        res.add(Rule.parseRule((String)ruleString));
                        break;
                    }
                    default: {
                        if (!inferSymetry) break;
                        String ruleString = "[inv" + i + ": (?a " + childString + " ?b) -> (?b " + ancestorString + " ?a)] ";
                        res.add(Rule.parseRule((String)ruleString));
                        ruleString = "[inv" + ++i + ": (?a " + ancestorString + " ?b) -> (?b " + childString + " ?a)] ";
                        res.add(Rule.parseRule((String)ruleString));
                    }
                }
                ++i;
            }
        }
        return res;
    }

    private static void addRulesFromSource(String source, List<Rule> rules, boolean urlSource) {
        try {
            InputStream rulesFile = null;
            if (urlSource) {
                rulesFile = new URL(source).openStream();
            } else {
                ClassLoader classLoader = BDRCReasoner.class.getClassLoader();
                rulesFile = classLoader.getResourceAsStream(source);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(rulesFile));
            Rule.Parser p = Rule.rulesParserFromReader((BufferedReader)in);
            rules.addAll(Rule.parseRules((Rule.Parser)p));
            rulesFile.close();
        }
        catch (IOException | Rule.ParserException e) {
            System.err.println("error parsing " + source + " while trying to add rules");
            e.printStackTrace(System.err);
        }
    }

    public static Reasoner getReasoner(Model m) {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll(BDRCReasoner.getRulesFromModel(m));
        rules.addAll(BDRCReasoner.getTaxonomyRules(m));
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        reasoner.setParameter(ReasonerVocabulary.PROPruleMode, (Object)"forward");
        INSTANCE = reasoner;
        return reasoner;
    }

    public static Reasoner getReasonerWithSymetry(Model m) {
        BDRCReasoner.setSymetry(true);
        if (INSTANCE != null) {
            return INSTANCE;
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        BDRCReasoner.addRulesFromSource("https://raw.githubusercontent.com/buda-base/owl-schema/master/reasoning/kinship.rules", rules, true);
        rules.addAll(BDRCReasoner.getRulesFromModel(m));
        rules.addAll(BDRCReasoner.getTaxonomyRules(m));
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        reasoner.setParameter(ReasonerVocabulary.PROPruleMode, (Object)"forward");
        INSTANCE = reasoner;
        return reasoner;
    }

    public static class TaxTreeNode {
        public TaxTreeNode parent = null;
        public List<TaxTreeNode> children = new ArrayList<TaxTreeNode>();
        public final String uri;
        public Boolean isLeave = false;
        public Boolean ruleToParentDone = false;

        public TaxTreeNode(String uri) {
            this.uri = uri;
        }

        public String toString() {
            return "uri: " + this.uri + ", parent: " + (this.parent != null) + ", children: " + this.children.size() + ", isLeave: " + this.isLeave + ", ruleToParentDone: " + this.ruleToParentDone;
        }
    }
}

