/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.libraries;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.SKOS;
import org.apache.jena.vocabulary.VCARD4;
import org.apache.jena.vocabulary.XSD;

public class Models {
    public static final String BDO = "http://purl.bdrc.io/ontology/core/";
    public static final String ADM = "http://purl.bdrc.io/ontology/admin/";
    public static final String BDA = "http://purl.bdrc.io/admindata/";
    public static final String BDG = "http://purl.bdrc.io/graph/";
    public static final String BDR = "http://purl.bdrc.io/resource/";
    public static final String VCARD = VCARD4.getURI();
    public static final String USER = "MigrationApp";
    public static final String EWTS_TAG = "bo-x-ewts";
    public static final boolean lowerCaseLangTags = true;
    public static final Map<String, String> typeToRepo = new HashMap<String, String>();
    public static MessageDigest md5;
    private static final int hashNbChars = 2;
    private static final int nbShaChars = 12;
    private static Map<String, FacetType> strToFacetType;

    private static void fillTypeToRepo() {
        typeToRepo.put("Corporation", "http://purl.bdrc.io/admindata/GR0001");
        typeToRepo.put("Etext", "http://purl.bdrc.io/admindata/GR0002");
        typeToRepo.put("EtextNonPaginated", "http://purl.bdrc.io/admindata/GR0002");
        typeToRepo.put("EtextPaginated", "http://purl.bdrc.io/admindata/GR0002");
        typeToRepo.put("Item", "http://purl.bdrc.io/admindata/GR0003");
        typeToRepo.put("ItemEtext", "http://purl.bdrc.io/admindata/GR0003");
        typeToRepo.put("ItemEtextNonPaginated", "http://purl.bdrc.io/admindata/GR0003");
        typeToRepo.put("ItemEtextPaginated", "http://purl.bdrc.io/admindata/GR0003");
        typeToRepo.put("ItemImageAsset", "http://purl.bdrc.io/admindata/GR0003");
        typeToRepo.put("ItemPhysicalAsset", "http://purl.bdrc.io/admindata/GR0003");
        typeToRepo.put("Lineage", "http://purl.bdrc.io/admindata/GR0004");
        typeToRepo.put("Place", "http://purl.bdrc.io/admindata/GR0005");
        typeToRepo.put("Person", "http://purl.bdrc.io/admindata/GR0006");
        typeToRepo.put("Product", "http://purl.bdrc.io/admindata/GR0011");
        typeToRepo.put("Topic", "http://purl.bdrc.io/admindata/GR0007");
        typeToRepo.put("Work", "http://purl.bdrc.io/admindata/GR0008");
        typeToRepo.put("AbstractWork", "http://purl.bdrc.io/admindata/GR0008");
        typeToRepo.put("PublishedWork", "http://purl.bdrc.io/admindata/GR0008");
        typeToRepo.put("SerialWork", "http://purl.bdrc.io/admindata/GR0008");
        typeToRepo.put("UnicodeWork", "http://purl.bdrc.io/admindata/GR0008");
        typeToRepo.put("VirtualWork", "http://purl.bdrc.io/admindata/GR0008");
        typeToRepo.put("UnspecifiedWorkClass", "http://purl.bdrc.io/admindata/GR0008");
        typeToRepo.put("EtextContent", "http://purl.bdrc.io/admindata/GR0009");
        typeToRepo.put("Role", "http://purl.bdrc.io/admindata/GR0010");
        typeToRepo.put("Product", "http://purl.bdrc.io/admindata/GR0011");
    }

    public static String getMd5(String resId) {
        try {
            String message = resId;
            byte[] bytesOfMessage = message.getBytes("UTF-8");
            byte[] hashBytes = md5.digest(bytesOfMessage);
            BigInteger bigInt = new BigInteger(1, hashBytes);
            return String.format("%032x", bigInt).substring(0, 2);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Resource createRoot(Model m, String uri, String typeUri) {
        Resource rez = m.createResource(uri);
        if (typeUri != null) {
            rez.addProperty(RDF.type, (RDFNode)m.createResource(typeUri));
        }
        rez.addLiteral(m.createProperty("http://purl.bdrc.io/ontology/core/isRoot"), true);
        return rez;
    }

    public static Resource getAdminData(Resource rez) {
        Resource admR;
        Model m = rez.getModel();
        if (!m.contains(admR = m.createResource(BDA + rez.getLocalName()), RDF.type, (RDFNode)m.createResource("http://purl.bdrc.io/ontology/admin/AdminData"))) {
            admR.addProperty(RDF.type, (RDFNode)m.createResource("http://purl.bdrc.io/ontology/admin/AdminData"));
            m.add(admR, m.createProperty("http://purl.bdrc.io/ontology/admin/adminAbout"), (RDFNode)rez);
        }
        return admR;
    }

    public static Resource getRepoFor(String typeName) {
        String repoUri = typeToRepo.get(typeName);
        if (repoUri != null) {
            return ResourceFactory.createResource((String)repoUri);
        }
        return null;
    }

    private static Resource getRezRepo(Resource rez) {
        Resource adClass = ResourceFactory.createResource((String)"http://purl.bdrc.io/ontology/admin/AdminData");
        String typeName = null;
        if (!rez.hasProperty(RDF.type, (RDFNode)adClass)) {
            Statement typeStmt = rez.getProperty(RDF.type);
            typeName = typeStmt != null ? typeStmt.getObject().asResource().getLocalName() : null;
        } else {
            StmtIterator iter = rez.listProperties(RDF.type);
            while (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                Resource typeR = stmt.getObject().asResource();
                if (typeR.equals((Object)adClass)) continue;
                typeName = typeR.getLocalName();
            }
        }
        return Models.getRepoFor(typeName);
    }

    public static Resource createAdminRoot(Resource rez) {
        Model m = rez.getModel();
        String rid = rez.getLocalName();
        Resource admR = Models.getAdminData(rez);
        Resource repoR = Models.getRezRepo(rez);
        if (repoR != null) {
            admR.addProperty(m.createProperty("http://purl.bdrc.io/ontology/admin/gitRepo"), (RDFNode)repoR);
            admR.addProperty(m.createProperty("http://purl.bdrc.io/ontology/admin/gitPath"), Models.getMd5(rid) + "/" + rid + ".trig");
            admR.addProperty(m.createProperty("http://purl.bdrc.io/ontology/admin/graphId"), (RDFNode)m.createResource(BDG + rid));
        }
        admR.addLiteral(m.createProperty("http://purl.bdrc.io/ontology/core/isRoot"), true);
        return admR;
    }

    public static Resource getAdminRoot(Resource rez) {
        return Models.getAdminRoot(rez, false);
    }

    public static Resource getAdminRoot(Resource rez, boolean create) {
        Resource admR = Models.getAdminRoot(rez.getModel());
        if (admR == null && create) {
            admR = Models.createAdminRoot(rez);
        }
        return admR;
    }

    public static Resource getAdminRoot(Model m) {
        ResIterator resIt = m.listResourcesWithProperty(RDF.type, (RDFNode)m.createResource("http://purl.bdrc.io/ontology/admin/AdminData"));
        while (resIt.hasNext()) {
            RDFNode node;
            Resource admR = (Resource)resIt.next();
            Statement stmt = m.getProperty(admR, m.createProperty("http://purl.bdrc.io/ontology/admin/gitInfo"));
            RDFNode rDFNode = node = stmt != null ? stmt.getObject() : null;
            if (node != null) {
                return admR;
            }
            if (!m.containsLiteral(admR, m.createProperty("http://purl.bdrc.io/ontology/core/isRoot"), true)) continue;
            return admR;
        }
        return null;
    }

    private static int getFacetIndex(Resource rootAdmRez) {
        Model m = rootAdmRez.getModel();
        Property inxP = m.createProperty("http://purl.bdrc.io/ontology/admin/facetIndex");
        Statement stmt = m.getProperty(rootAdmRez, inxP);
        int inx = 1;
        if (stmt != null) {
            inx = stmt.getInt();
            m.remove(stmt);
        }
        m.addLiteral(rootAdmRez, inxP, m.createTypedLiteral((Object)(inx + 1), (RDFDatatype)XSDDatatype.XSDinteger));
        return inx;
    }

    private static String bytesToHex(byte[] hash) {
        return DatatypeConverter.printHexBinary((byte[])hash);
    }

    public static String mintId(Resource rootAdmRez, String seed, String prefix) {
        try {
            String data = seed + Models.getFacetIndex(rootAdmRez);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(data.getBytes("UTF-8"));
            return prefix + Models.bytesToHex(hash).substring(0, 12);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String generateId(FacetType facet, Resource rez, String user, Resource rootAdmRez) {
        return Models.mintId(rootAdmRez, rez.getLocalName() + user, facet.getPrefix());
    }

    public static Resource getFacetNode(FacetType facet, Resource rez) {
        Resource nodeType = facet.getNodeType();
        return Models.getFacetNode(facet, BDR, rez, nodeType);
    }

    public static Resource getFacetNode(FacetType facet, Resource rez, Resource nodeType) {
        return Models.getFacetNode(facet, BDR, rez, nodeType);
    }

    public static Resource getFacetNode(FacetType facet, String nsUri, Resource rez) {
        Resource nodeType = facet.getNodeType();
        return Models.getFacetNode(facet, nsUri, rez, nodeType);
    }

    public static Resource getFacetNode(FacetType facet, String nsUri, Resource rez, Resource nodeType) {
        Model m = rez.getModel();
        Resource rootAdm = Models.getAdminRoot(rez);
        String id = Models.generateId(facet, rez, USER, rootAdm);
        Resource facetNode = m.createResource(nsUri + id);
        facetNode.addProperty(RDF.type, (RDFNode)nodeType);
        return facetNode;
    }

    public static Resource getEvent(Resource rez, String eventType, String eventProp) {
        Model m = rez.getModel();
        Property prop = m.createProperty(BDO, eventProp);
        StmtIterator it = rez.listProperties(prop);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            Resource event = s.getObject().asResource();
            Resource eventTypeR = event.getPropertyResourceValue(RDF.type);
            if (eventTypeR == null || !eventTypeR.getLocalName().equals(eventType)) continue;
            return event;
        }
        Resource event = Models.getFacetNode(FacetType.EVENT, rez, (Resource)m.createProperty(BDO + eventType));
        m.add(rez, prop, (RDFNode)event);
        return event;
    }

    public static void setPrefixes(Model m) {
        Models.setPrefixes(m, false);
    }

    public static void setPrefixes(Model m, String type) {
        Models.setPrefixes(m, type.equals("place"));
    }

    public static void setPrefixes(Model m, boolean addVcard) {
        m.setNsPrefix("", BDO);
        m.setNsPrefix("adm", ADM);
        m.setNsPrefix("bdr", BDR);
        m.setNsPrefix("bda", BDA);
        m.setNsPrefix("bdg", BDG);
        m.setNsPrefix("owl", OWL.getURI());
        m.setNsPrefix("rdf", RDF.getURI());
        m.setNsPrefix("rdfs", RDFS.getURI());
        m.setNsPrefix("skos", SKOS.getURI());
        m.setNsPrefix("xsd", XSD.getURI());
        m.setNsPrefix("rkts", "http://purl.rkts.eu/resource/");
        if (addVcard) {
            m.setNsPrefix("vcard", VCARD4.getURI());
        }
    }

    public static void addReleased(Model m, Resource r) {
        Models.addStatus(m, r, "released");
    }

    public static void addStatus(Model m, Resource r, String status) {
        if (status == null || status.isEmpty()) {
            return;
        }
        String statusName = "Status" + status.substring(0, 1).toUpperCase() + status.substring(1);
        r.addProperty(m.getProperty("http://purl.bdrc.io/ontology/admin/status"), (RDFNode)m.getResource(BDA + statusName));
    }

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        Models.fillTypeToRepo();
        strToFacetType = new HashMap<String, FacetType>();
    }

    public static enum FacetType {
        CORP_MEMBER("corporationMember", "CM", "http://purl.bdrc.io/ontology/core/CorporationMember"),
        CREATOR("creator", "CR", "http://purl.bdrc.io/ontology/core/AgentAsCreator"),
        ETEXT_CHUNK("etextChunk", "EC", "http://purl.bdrc.io/ontology/core/EtextChunk"),
        ETEXT_LINE("etextLine", "EL", "http://purl.bdrc.io/ontology/core/EtextLine"),
        ETEXT_PAGE("etextPage", "EP", "http://purl.bdrc.io/ontology/core/EtextPage"),
        ETEXT_REF("etextRef", "ER", "http://purl.bdrc.io/ontology/core/EtextRef"),
        EVENT("event", "EV", "http://purl.bdrc.io/ontology/core/Event"),
        HOLDER("lineageHolder", "LH", "http://purl.bdrc.io/ontology/core/LineageHolder"),
        LINEAGE_HOLDER("lineageHolder", "LH", "http://purl.bdrc.io/ontology/core/LineageHolder"),
        LOG_ENTRY("logEntry", "LG", "http://purl.bdrc.io/ontology/admin/LogEntry"),
        NAME("name", "NM", "http://purl.bdrc.io/ontology/core/PersonName"),
        NOTE("note", "NT", "http://purl.bdrc.io/ontology/core/Note"),
        PRODUCT_ORG("productOrg", "PG", "http://purl.bdrc.io/ontology/admin/ProductOrg"),
        TITLE("title", "TT", "http://purl.bdrc.io/ontology/core/WorkTitle"),
        VCARD_ADDR("vcardAddr", "VA", VCARD + "Address"),
        VOLUME("volume", "VL", "http://purl.bdrc.io/ontology/core/Volume"),
        WORK_LOC("workLoc", "WL", "http://purl.bdrc.io/ontology/core/WorkLocation"),
        MICROFILM("workMicrofilm", "MF", "http://purl.bdrc.io/ontology/core/ObjectTypeMicrofilm"),
        CATALOG("catalogLoc", "CT", "http://purl.bdrc.io/ontology/core/CatalogLocation"),
        DATE_INDICATION("dateIndication", "DT", "http://purl.bdrc.io/ontology/core/DateIndication");

        private String label;
        private String prefix;
        private String nodeTypeUri;

        private FacetType(String label, String prefix) {
            this(label, prefix, null);
        }

        private FacetType(String label, String prefix, String nodeTypeUri) {
            this.label = label;
            this.prefix = prefix;
            this.nodeTypeUri = nodeTypeUri;
            strToFacetType.put(prefix, this);
        }

        public static FacetType getType(String prefix) {
            return (FacetType)((Object)strToFacetType.get(prefix));
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Resource getNodeType() {
            return ResourceFactory.createResource((String)this.nodeTypeUri);
        }

        public String toString() {
            return this.label;
        }
    }
}

