/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.libraries;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.bdrc.libraries.IdentifierException;

public class Identifier {
    public static final int INVALID_IDENTIFIER_ERROR_CODE = 5002;
    public static final int MANIFEST_ID = 0;
    public static final int COLLECTION_ID = 1;
    public static final int COLLECTION_ID_ITEM = 2;
    public static final int COLLECTION_ID_WORK_IN_ITEM = 3;
    public static final int COLLECTION_ID_WORK_OUTLINE = 7;
    public static final int COLLECTION_ID_ITEM_VOLUME_OUTLINE = 9;
    public static final int MANIFEST_ID_WORK_IN_ITEM = 4;
    public static final int MANIFEST_ID_VOLUMEID = 5;
    public static final int MANIFEST_ID_WORK_IN_VOLUMEID = 6;
    public static final int MANIFEST_ID_VOLUMEID_OUTLINE = 8;
    @JsonProperty(value="id")
    String id = null;
    @JsonProperty(value="type")
    int type = -1;
    @JsonProperty(value="subtype")
    int subtype = -1;
    @JsonProperty(value="workId")
    String workId = null;
    @JsonProperty(value="itemId")
    String itemId = null;
    @JsonProperty(value="volumeId")
    String volumeId = null;
    @JsonProperty(value="bPageNum")
    Integer bPageNum = null;
    @JsonProperty(value="ePageNum")
    Integer ePageNum = null;

    public void setPageNumFromIdPart(String idPart) throws IdentifierException {
        if (idPart == null || idPart.isEmpty()) {
            return;
        }
        String[] parts = idPart.split("-");
        if (parts.length == 0 || parts.length > 3) {
            throw new IdentifierException("cannot parse page numbers in identifier");
        }
        if (!parts[0].isEmpty()) {
            try {
                this.bPageNum = Integer.parseInt(parts[0]);
            }
            catch (NumberFormatException e) {
                throw new IdentifierException("cannot parse page numbers in identifier");
            }
            if (this.bPageNum < 1) {
                throw new IdentifierException("cannot parse page numbers in identifier");
            }
        }
        if (parts.length < 2) {
            return;
        }
        try {
            this.ePageNum = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new IdentifierException("cannot parse page numbers in identifier");
        }
        if (this.ePageNum < 1) {
            throw new IdentifierException("cannot parse page numbers in identifier");
        }
    }

    public Identifier(String iiifIdentifier, int idType) throws IdentifierException {
        if (iiifIdentifier == null || iiifIdentifier.isEmpty()) {
            throw new IdentifierException("cannot parse identifier");
        }
        int firstColIndex = iiifIdentifier.indexOf(58);
        if (firstColIndex < 1) {
            throw new IdentifierException("cannot parse identifier");
        }
        String typestr = iiifIdentifier.substring(0, firstColIndex);
        String[] parts = iiifIdentifier.substring(firstColIndex + 1).split("::");
        if (parts.length == 0 || parts.length > 3) {
            throw new IdentifierException("cannot parse identifier");
        }
        String firstId = parts[0];
        if (firstId.isEmpty()) {
            throw new IdentifierException("cannot parse identifier");
        }
        String secondId = parts.length > 1 && !parts[1].isEmpty() ? parts[1] : null;
        String thirdId = parts.length > 2 && !parts[2].isEmpty() ? parts[2] : null;
        int nbMaxPartsExpected = 0;
        this.id = iiifIdentifier;
        this.type = idType;
        if (idType == 1) {
            switch (typestr) {
                case "i": {
                    this.itemId = firstId;
                    nbMaxPartsExpected = 1;
                    this.subtype = 2;
                    break;
                }
                case "ivo": {
                    this.itemId = firstId;
                    nbMaxPartsExpected = 1;
                    this.subtype = 9;
                    break;
                }
                case "wi": {
                    this.workId = firstId;
                    this.itemId = secondId;
                    nbMaxPartsExpected = 2;
                    this.subtype = 3;
                    break;
                }
                case "wio": {
                    this.workId = firstId;
                    this.itemId = secondId;
                    nbMaxPartsExpected = 2;
                    this.subtype = 7;
                    break;
                }
                default: {
                    throw new IdentifierException("cannot parse identifier: invalid type \"" + typestr + "\"");
                }
            }
            return;
        }
        switch (typestr) {
            case "wi": {
                this.workId = firstId;
                this.itemId = secondId;
                this.setPageNumFromIdPart(thirdId);
                nbMaxPartsExpected = 3;
                this.subtype = 4;
                break;
            }
            case "v": {
                this.volumeId = firstId;
                this.setPageNumFromIdPart(secondId);
                nbMaxPartsExpected = 2;
                this.subtype = 5;
                break;
            }
            case "vo": {
                this.volumeId = firstId;
                nbMaxPartsExpected = 1;
                this.subtype = 8;
                break;
            }
            case "wv": {
                this.workId = firstId;
                this.volumeId = secondId;
                this.setPageNumFromIdPart(thirdId);
                nbMaxPartsExpected = 3;
                this.subtype = 6;
                break;
            }
            default: {
                throw new IdentifierException("cannot parse identifier: invalid type \"" + typestr + "\"");
            }
        }
        if (nbMaxPartsExpected < parts.length) {
            throw new IdentifierException("cannot parse identifier: not enough parts");
        }
        if (!(this.isWellFormedId(this.workId) && this.isWellFormedId(this.itemId) && this.isWellFormedId(this.volumeId))) {
            throw new IdentifierException("cannot parse identifier: ill formed IDs");
        }
    }

    public int getType() {
        return this.type;
    }

    public int getSubType() {
        return this.subtype;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public String getWorkId() {
        return this.workId;
    }

    public String getId() {
        return this.id;
    }

    public Integer getBPageNum() {
        return this.bPageNum;
    }

    public Integer getEPageNum() {
        return this.ePageNum;
    }

    private boolean isWellFormedId(String id) {
        if (id == null) {
            return true;
        }
        return id.indexOf(34) == -1 && id.indexOf(92) == -1 && id.indexOf(10) == -1;
    }

    public String toString() {
        return "Identifier [id=" + this.id + ", type=" + this.type + ", subtype=" + this.subtype + ", workId=" + this.workId + ", itemId=" + this.itemId + ", volumeId=" + this.volumeId + ", bPageNum=" + this.bPageNum + ", ePageNum=" + this.ePageNum + "]";
    }
}

