/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.libraries;

import com.atlascopco.hunspell.Hunspell;
import io.bdrc.ewtsconverter.EwtsConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class LangStrings {
    public static final String EWTS_TAG = "bo-x-ewts";
    public static final boolean lowerCaseLangTags = true;
    public static final String IMAGE_ITEM_SUFFIX = "";
    public static final EwtsConverter converter = new EwtsConverter();
    public static final EwtsConverter converterAlalc = new EwtsConverter(true, true, false, false, EwtsConverter.Mode.ALALC);
    public static final String hunspellBoPath = "src/main/resources/hunspell-bo/";
    public static final Hunspell speller = new Hunspell("src/main/resources/hunspell-bo/bo.dic", "src/main/resources/hunspell-bo/bo.aff");
    public static final Map<Integer, Boolean> isTraditional = new HashMap<Integer, Boolean>();
    private static final List<Character> unihanPinyinDiacritics;
    private static Pattern p;
    static final Pattern englishP;

    private static void getTcList() {
        ClassLoader classLoader = LangStrings.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("tclist.txt");
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        try {
            while ((line = in.readLine()) != null) {
                isTraditional.put(line.codePointAt(0), true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getBCP47Suffix(String encoding) {
        switch (encoding) {
            case "extendedWylie": {
                return "-x-ewts";
            }
            case "wadeGiles": {
                return "-latn-wadegile";
            }
            case "pinyin": {
                return "-latn-pinyin";
            }
            case "libraryOfCongress": {
                return "-alalc97";
            }
            case "native": {
                return IMAGE_ITEM_SUFFIX;
            }
            case "none": {
                return IMAGE_ITEM_SUFFIX;
            }
            case "rma": {
                return "-x-rma";
            }
            case "sansDiacritics": {
                return "-x-ndia";
            }
            case "withDiacritics": {
                return "-x-iast";
            }
            case "transliteration": {
                return "-x-trans";
            }
            case "acip": {
                return "-x-acip";
            }
            case "tbrcPhonetic": {
                return "-x-phon-en-m-tbrc";
            }
            case "alternatePhonetic": {
                return "-x-phon-en";
            }
            case "syllables": {
                return "-x-syx";
            }
            case "": {
                return IMAGE_ITEM_SUFFIX;
            }
        }
        throw new IllegalArgumentException("unknown encoding: " + encoding);
    }

    public static String getIso639(String language) throws IllegalArgumentException {
        switch (language) {
            case "tibetan": {
                return "bo";
            }
            case "pali": {
                return "pi";
            }
            case "english": {
                return "en";
            }
            case "chinese": {
                return "zh";
            }
            case "sanskrit": {
                return "sa";
            }
            case "mongolian": {
                return "mn";
            }
            case "french": {
                return "fr";
            }
            case "russian": {
                return "ru";
            }
            case "zhangZhung": {
                return "xzh";
            }
            case "dzongkha": {
                return "dz";
            }
            case "miNyag": {
                return "mvm";
            }
            case "german": {
                return "de";
            }
            case "": {
                return "en";
            }
            case "japanese": {
                return "ja";
            }
            case "unspecified": {
                throw new IllegalArgumentException("unknown language: " + language);
            }
        }
        throw new IllegalArgumentException("unknown language: " + language);
    }

    public static String getBCP47(String language, String encoding) throws IllegalArgumentException {
        if (language == null || language.isEmpty()) {
            if (encoding != null && !encoding.isEmpty()) {
                if (encoding.equals("extendedWylie")) {
                    return EWTS_TAG;
                }
                if (encoding.equals("tbrcPhonetic")) {
                    return "bo-x-phon-en-m-tbrc";
                }
                throw new IllegalArgumentException("encoding with no language!");
            }
            return null;
        }
        if ("khmer".equals(language)) {
            if ("km".equals(encoding)) {
                return "km";
            }
            if ("kmfemc".equals(encoding)) {
                return "km-x-kmfemc";
            }
        } else if ("p\u0101li".equals(language)) {
            if ("km".equals(encoding)) {
                return "pi-Khmr";
            }
            if ("kmfemc".equals(encoding)) {
                return "pi-x-kmfemc";
            }
        }
        return LangStrings.getIso639(language) + LangStrings.getBCP47Suffix(encoding);
    }

    private static boolean isAllEwtsChars(String input) {
        boolean res = true;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if ((c <= '\u007f' || c == '\u2019') && c != 'x') continue;
            res = false;
            break;
        }
        return res;
    }

    private static boolean isAllLatn(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= '\u036f') continue;
            return false;
        }
        return true;
    }

    private static boolean isPinyinNDia(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c > '0' && c < '9') {
                return false;
            }
            if (!unihanPinyinDiacritics.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllTibetanUnicode(String input) {
        int len = input.length();
        if (len == 0) {
            return false;
        }
        double nbNonTibUni = 0.0;
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (c >= '\u0f00' && c <= '\u0fff' || c == ' ') continue;
            nbNonTibUni += 1.0;
        }
        return nbNonTibUni / (double)len < 0.1;
    }

    private static boolean isAllChineseUnicode(String input) {
        boolean isChinese = true;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= '\u2e00' || c == '\u00b7') continue;
            isChinese = false;
            break;
        }
        return isChinese;
    }

    private static boolean isHant(String input) {
        int codepoint;
        int length = input.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
            codepoint = input.codePointAt(offset);
            if (!isTraditional.containsKey(codepoint)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMostLikelyEwts(String input) {
        if (!LangStrings.isAllEwtsChars(input)) {
            return false;
        }
        ArrayList warns = new ArrayList();
        String uni = converter.toUnicode(input, warns, true);
        if (warns.size() > 0) {
            return false;
        }
        Matcher m = p.matcher(uni);
        while (m.find()) {
            if (speller.isCorrect(m.group(0))) continue;
            return false;
        }
        return true;
    }

    public static String getBCP47(Element e) {
        String lang = e.getAttribute("lang");
        String encoding = e.getAttribute("encoding");
        if (lang.isEmpty() && !(lang = e.getAttribute("type")).equals("sanskrit") && !lang.equals("tibetan")) {
            lang = IMAGE_ITEM_SUFFIX;
        }
        String res = "en";
        if (lang.equals("english") && !encoding.isEmpty() && !encoding.equals("native")) {
            return "en-x-mixed";
        }
        try {
            res = LangStrings.getBCP47(lang, encoding);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String value = e.getTextContent().trim();
        if ("bo".equals(res) && LangStrings.isAllEwtsChars(value)) {
            res = EWTS_TAG;
        }
        if ((res == null || !res.equals("bo")) && LangStrings.isAllTibetanUnicode(value)) {
            res = "bo";
        }
        if ((res == null || !res.equals("zh")) && LangStrings.isAllChineseUnicode(value)) {
            res = "zh";
        }
        if (res != null && res.equals("zh")) {
            res = LangStrings.isHant(value) ? "zh-hant" : "zh-hans";
        }
        if (res != null && res.toLowerCase().equals("zh-latn-pinyin") && LangStrings.isPinyinNDia(value)) {
            res = res + "-x-ndia";
        }
        if ((res == null || res == "en") && LangStrings.isMostLikelyEwts(value)) {
            res = EWTS_TAG;
        }
        if (res != null && res.equals("pi") && LangStrings.isAllLatn(value)) {
            res = "pi-x-iast";
        }
        return res;
    }

    public static String getBCP47(Element e, String dflt) {
        String res = LangStrings.getBCP47(e);
        if (dflt != null && (res == null || res.isEmpty())) {
            return dflt;
        }
        return res;
    }

    public static String normalizeTibetan(String s) {
        String res = Normalizer.normalize(s, Normalizer.Form.NFD);
        res = res.replace("\u0f79", "\u0fb3\u0f71\u0f80");
        res = res.replace("\u0f77", "\u0fb2\u0f71\u0f80");
        res = res.replace("\u0f81", "\u0f71\u0f80");
        res = res.replace("\u0f75", "\u0f71\u0f74");
        res = res.replace("\u0f73", "\u0f71\u0f72");
        return res;
    }

    public static String addEwtsShad(String s) {
        if (s == null) {
            return s;
        }
        int sLen = s.length();
        if (sLen < 2) {
            return s;
        }
        int last = s.codePointAt(sLen - 1);
        if (last == 97 || last == 105 || last == 101 || last == 111) {
            last = s.codePointAt(sLen - 2);
        }
        if (sLen > 2 && last == 103 && s.codePointAt(sLen - 3) == 110) {
            return s + " /";
        }
        if (last == 103 || last == 107 || sLen == 3 && last == 104 && s.codePointAt(sLen - 3) == 115 || sLen > 3 && last == 104 && s.codePointAt(sLen - 3) == 115 && s.codePointAt(sLen - 4) != 116) {
            return s;
        }
        if (last < 65 || last > 122 || last > 90 && last < 97) {
            return s;
        }
        return s + "/";
    }

    public static String normalizeEwts(String s) {
        return LangStrings.addEwtsShad(s.replace('\u2019', '\''));
    }

    public static boolean isStandardTibetan(String s) {
        String[] words;
        for (String word : words = s.split("[ \u0f04-\u0f14\u0f20-\u0f34\u0f3a-\u0f3f]")) {
            if (speller.spell(word)) continue;
            return false;
        }
        return words.length > 0;
    }

    public static boolean isDeva(String s) {
        char c = s.charAt(0);
        return c >= '\u0900' && c <= '\u097f';
    }

    public static boolean isLikelyEnglish(String value) {
        Matcher m = englishP.matcher(value);
        return m.find();
    }

    static {
        LangStrings.getTcList();
        unihanPinyinDiacritics = Arrays.asList(Character.valueOf('\u0100'), Character.valueOf('\u00c1'), Character.valueOf('\u01cd'), Character.valueOf('\u00c0'), Character.valueOf('\u0101'), Character.valueOf('\u00e1'), Character.valueOf('\u01ce'), Character.valueOf('\u00e0'), Character.valueOf('\u0112'), Character.valueOf('\u00c9'), Character.valueOf('\u011a'), Character.valueOf('\u00c8'), Character.valueOf('\u0113'), Character.valueOf('\u00e9'), Character.valueOf('\u011b'), Character.valueOf('\u00e8'), Character.valueOf('\u012a'), Character.valueOf('\u00cd'), Character.valueOf('\u01cf'), Character.valueOf('\u00cc'), Character.valueOf('\u012b'), Character.valueOf('\u00ed'), Character.valueOf('\u01d0'), Character.valueOf('\u00ec'), Character.valueOf('\u014c'), Character.valueOf('\u00d3'), Character.valueOf('\u01d1'), Character.valueOf('\u00d2'), Character.valueOf('\u014d'), Character.valueOf('\u00f3'), Character.valueOf('\u01d2'), Character.valueOf('\u00f2'), Character.valueOf('\u016a'), Character.valueOf('\u00da'), Character.valueOf('\u01d3'), Character.valueOf('\u00d9'), Character.valueOf('\u016b'), Character.valueOf('\u00fa'), Character.valueOf('\u01d4'), Character.valueOf('\u00f9'), Character.valueOf('\u01d5'), Character.valueOf('\u01d7'), Character.valueOf('\u01d9'), Character.valueOf('\u01db'), Character.valueOf('\u00dc'), Character.valueOf('\u01d6'), Character.valueOf('\u01d8'), Character.valueOf('\u01da'), Character.valueOf('\u01dc'), Character.valueOf('\u00fc'));
        p = Pattern.compile("[\u0f40-\u0fbc]+");
        englishP = Pattern.compile("\\b(of|is|it|and|that|has|have|for|not|as|if)\\b");
    }
}

