/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.libraries.formatters;

import io.bdrc.jena.sttl.CompareComplex;
import io.bdrc.jena.sttl.ComparePredicates;
import io.bdrc.jena.sttl.STTLWriter;
import java.util.List;
import java.util.SortedMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.vocabulary.SKOS;

public class TTLRDFWriter {
    public static final Lang sttl = STTLWriter.registerWriter();
    public static final String strLangSttl = "STTL";
    static final SortedMap<String, Integer> nsPrio = ComparePredicates.getDefaultNSPriorities();
    static final List<String> predicatesPrio = CompareComplex.getDefaultPropUris();
    static final Context ctx = new Context();

    public static RDFWriter getSTTLRDFWriter(Model m, String baseURI) {
        return RDFWriter.create().source(m.getGraph()).base(baseURI).context(ctx).lang(sttl).build();
    }

    static {
        nsPrio.put(SKOS.getURI(), 1);
        nsPrio.put("http://purl.bdrc.io/ontology/admin/", 5);
        nsPrio.put("http://purl.bdrc.io/ontology/toberemoved/", 6);
        predicatesPrio.add("http://purl.bdrc.io/ontology/admin/logDate");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/seqNum");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/onYear");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/notBefore");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/notAfter");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/noteText");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/noteWork");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/noteLocationStatement");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/volumeNumber");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/eventWhere");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/eventWho");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/lineageWho");
        ctx.set(Symbol.create((String)"http://bdrc.io/sttl#nsPriorities"), nsPrio);
        ctx.set(Symbol.create((String)"http://bdrc.io/sttl#nsDefaultPriority"), (Object)2);
        ctx.set(Symbol.create((String)"http://bdrc.io/sttl#complexPredicatesPriorities"), predicatesPrio);
        ctx.set(Symbol.create((String)"http://bdrc.io/sttl#indentBase"), (Object)3);
        ctx.set(Symbol.create((String)"http://bdrc.io/sttl#predicateBaseWidth"), (Object)12);
    }
}

