/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.libraries;

import io.bdrc.libraries.LibProps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapStd;
import org.apache.jena.shared.PrefixMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Prefix {
    public static final Logger log = LoggerFactory.getLogger(Prefix.class);
    private static final PrefixMap pMap = new PrefixMapStd();
    private static final HashMap<String, String> map = new HashMap();
    private static String prefixesString;
    private static final PrefixMapping PREFIXES_MAP;

    public Prefix(String path) {
        try {
            this.loadPrefixes(path);
        }
        catch (IOException ex) {
            log.error("Prefixes initialization error", (Throwable)ex);
        }
    }

    public Prefix() {
        try {
            this.loadPrefixes(LibProps.getProperty("prefixeFile"));
        }
        catch (IOException ex) {
            log.error("Prefixes initialization error", (Throwable)ex);
        }
    }

    public String getPrefixesString() {
        return prefixesString;
    }

    public void loadPrefixes(String filePath) throws IOException {
        log.info("reading prefixes from {}", (Object)filePath);
        File file = new File(filePath);
        BufferedReader br = new BufferedReader(new FileReader(file));
        StringBuilder sb = new StringBuilder();
        PREFIXES_MAP.clearNsPrefixMap();
        pMap.clear();
        String line = "";
        while ((line = br.readLine()) != null) {
            sb.append(line);
            if (line.length() < 10 || line.startsWith("#")) continue;
            String uri = line.substring(line.indexOf(60) + 1, line.indexOf(62));
            String prefix = line.substring(7, line.indexOf(58)).trim();
            map.put(prefix, uri);
            pMap.add(prefix, uri);
            PREFIXES_MAP.setNsPrefix(prefix, uri);
        }
        prefixesString = sb.toString();
        br.close();
    }

    public PrefixMap getPrefixMap() {
        return pMap;
    }

    public HashMap<String, String> getMap() {
        return map;
    }

    public PrefixMapping getPrefixMapping() {
        return PREFIXES_MAP;
    }

    public String getFullIRI(String prefix) {
        if (prefix != null) {
            return PREFIXES_MAP.getNsPrefixURI(prefix);
        }
        return null;
    }

    public String getPrefix(String IRI) {
        if (IRI != null) {
            return PREFIXES_MAP.getNsURIPrefix(IRI);
        }
        return "";
    }

    public String getPrefixedIRI(String IRI) {
        if (IRI != null) {
            return PREFIXES_MAP.shortForm(IRI);
        }
        return "";
    }

    static {
        PREFIXES_MAP = PrefixMapping.Factory.create();
    }
}

