/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.libraries;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bdrc.jena.sttl.CompareComplex;
import io.bdrc.jena.sttl.ComparePredicates;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Hex;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.vocabulary.SKOS;

public class GlobalHelpers {
    public static Context createWriterContext() {
        SortedMap nsPrio = ComparePredicates.getDefaultNSPriorities();
        nsPrio.put(SKOS.getURI(), 1);
        nsPrio.put("http://purl.bdrc.io/ontology/admin/", 5);
        nsPrio.put("http://purl.bdrc.io/ontology/toberemoved/", 6);
        List predicatesPrio = CompareComplex.getDefaultPropUris();
        predicatesPrio.add("http://purl.bdrc.io/ontology/admin/logDate");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/seqNum");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/onYear");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/notBefore");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/notAfter");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/noteText");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/noteSource");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/noteLocationStatement");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/volumeNumber");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/eventWho");
        predicatesPrio.add("http://purl.bdrc.io/ontology/core/eventWhere");
        Context ctx = new Context();
        ctx.set(Symbol.create((String)"http://bdrc.io/sttl#nsPriorities"), (Object)nsPrio);
        ctx.set(Symbol.create((String)"http://bdrc.io/sttl#nsDefaultPriority"), (Object)2);
        ctx.set(Symbol.create((String)"http://bdrc.io/sttl#complexPredicatesPriorities"), (Object)predicatesPrio);
        ctx.set(Symbol.create((String)"http://bdrc.io/sttl#indentBase"), (Object)4);
        ctx.set(Symbol.create((String)"http://bdrc.io/sttl#predicateBaseWidth"), (Object)18);
        return ctx;
    }

    public static String getTwoLettersBucket(String st) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        md.reset();
        md.update(st.getBytes(Charset.forName("UTF8")));
        return new String(Hex.encodeHex((byte[])md.digest())).substring(0, 2);
    }

    public static List<String> getFileList(String dir, String ext) throws IOException {
        ArrayList<String> files = new ArrayList();
        Path dpath = Paths.get(dir, new String[0]);
        Stream<Path> walk = Files.walk(dpath, new FileVisitOption[0]);
        files = walk.map(x -> x.toString()).filter(f -> f.endsWith(ext)).collect(Collectors.toList());
        walk.close();
        return files;
    }

    public static String readFileContent(String filename) throws IOException {
        File f = new File(filename);
        FileInputStream fis = new FileInputStream(f);
        byte[] b = new byte[(int)f.length()];
        fis.read(b);
        fis.close();
        return new String(b, "UTF-8");
    }

    public static byte[] getJsonBytes(Object obj) throws JsonProcessingException {
        return new ObjectMapper().writeValueAsBytes(obj);
    }
}

