/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.libraries;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.bdrc.jena.sttl.STriGWriter;
import io.bdrc.libraries.BudaMediaTypes;
import io.bdrc.libraries.GlobalHelpers;
import io.bdrc.libraries.formatters.JSONLDFormatter;
import io.bdrc.libraries.formatters.TTLRDFWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.core.DatasetGraph;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

public class StreamingHelpers {
    public static final ObjectMapper om = new ObjectMapper();
    public static boolean prettyPrint = false;

    public static StreamingResponseBody getStream(final String obj) {
        StreamingResponseBody stream = new StreamingResponseBody(){

            public void writeTo(OutputStream os) throws IOException {
                os.write(obj.getBytes());
            }
        };
        return stream;
    }

    public static StreamingResponseBody getModelStream(final Model model, final String format, final PrefixMap pm) {
        return new StreamingResponseBody(){

            public void writeTo(OutputStream os) {
                String JenaFormat = null;
                if (format == null) {
                    JenaFormat = "STTL";
                } else {
                    if (format.equals("jsonld")) {
                        JSONLDFormatter.writeModelAsCompact(model, os, pm);
                        return;
                    }
                    JenaFormat = BudaMediaTypes.getJenaFromExtension(format);
                }
                if (JenaFormat == null || JenaFormat.equals("STTL") || JenaFormat.contentEquals("TriG")) {
                    RDFWriter writer = TTLRDFWriter.getSTTLRDFWriter(model, null);
                    writer.output(os);
                    return;
                }
                model.write(os, JenaFormat);
            }
        };
    }

    public static StreamingResponseBody getModelStream(final Model model, final String format, final String res, final JSONLDFormatter.DocType docType, final PrefixMap prefixes) {
        return new StreamingResponseBody(){

            public void writeTo(OutputStream os) {
                if (format.equals("jsonld")) {
                    Map<String, Object> json = JSONLDFormatter.modelToJsonObject(model, res, docType, prefixes);
                    JSONLDFormatter.jsonObjectToOutputStream(json, os);
                } else {
                    String JenaFormat = BudaMediaTypes.getJenaFromExtension(format);
                    if (JenaFormat == null || JenaFormat.equals("STTL")) {
                        RDFWriter writer = TTLRDFWriter.getSTTLRDFWriter(model, null);
                        writer.output(os);
                        return;
                    }
                    if (JenaFormat.contentEquals("TriG")) {
                        DatasetGraph dsg = DatasetFactory.create().asDatasetGraph();
                        dsg.addGraph(ResourceFactory.createResource((String)res).asNode(), model.getGraph());
                        new STriGWriter().write(os, dsg, prefixes, "", GlobalHelpers.createWriterContext());
                        return;
                    }
                    model.write(os, JenaFormat);
                }
            }
        };
    }

    public static StreamingResponseBody getJsonObjectStream(final Object obj) {
        return new StreamingResponseBody(){

            public void writeTo(OutputStream os) throws IOException {
                if (prettyPrint) {
                    om.writerWithDefaultPrettyPrinter().writeValue(os, obj);
                } else {
                    om.writeValue(os, obj);
                }
            }
        };
    }
}

