/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.libraries;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class BDRCReasoner {
    public static final String BDO = "http://purl.bdrc.io/ontology/core/";

    private static List<Rule> getRulesFromModel(Model m, boolean inferSymetry) {
        ArrayList<Rule> res = new ArrayList<Rule>();
        String queryString = "PREFIX bdo: <http://purl.bdrc.io/ontology/core/>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nSELECT distinct ?ancestor ?child ?type\nWHERE {\n  {\n     ?child owl:inverseOf ?ancestor .\n     BIND (\"i\" AS ?type)\n  } UNION {\n     ?ancestor a owl:SymmetricProperty .\n     BIND (\"s\" AS ?type).\n     BIND (?ancestor AS ?child)\n  } UNION {\n     ?ancestor bdo:inferSubTree \"true\"^^xsd:boolean .\n     ?child rdfs:subPropertyOf+ ?ancestor .\n     BIND (\"p\" AS ?type)\n  } UNION {\n     ?grandancestor bdo:inferSubTree \"true\"^^xsd:boolean .\n     ?child rdfs:subPropertyOf+ ?ancestor .\n     ?ancestor rdfs:subPropertyOf+ ?grandancestor .\n     BIND (\"p\" AS ?type)\n  } UNION {\n     ?ancestor bdo:inferSubTree \"true\"^^xsd:boolean .\n     ?child rdfs:subClassOf+ ?ancestor .\n     BIND (\"c\" AS ?type)\n  } UNION {\n     ?grandancestor bdo:inferSubTree \"true\"^^xsd:boolean .\n     ?child rdfs:subClassOf+ ?ancestor .\n     ?ancestor rdfs:subClassOf+ ?grandancestor .\n     BIND (\"c\" AS ?type)\n  }\n}\n";
        Query query = QueryFactory.create((String)queryString);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)m);){
            ResultSet results = qexec.execSelect();
            int i = 0;
            while (results.hasNext()) {
                String type;
                QuerySolution soln = results.nextSolution();
                String ancestorString = soln.get("ancestor").asResource().getURI();
                String childString = soln.get("child").asResource().getURI();
                switch (type = soln.get("type").asLiteral().getString()) {
                    case "c": {
                        String ruleString = "[subclass" + i + ": (?a " + RDF.type + " " + childString + ") -> (?a " + RDF.type + " " + ancestorString + ")] ";
                        res.add(Rule.parseRule((String)ruleString));
                        break;
                    }
                    case "p": {
                        String ruleString = "[subprop" + i + ": (?a " + childString + " ?b) -> (?a " + ancestorString + " ?b)] ";
                        res.add(Rule.parseRule((String)ruleString));
                        break;
                    }
                    case "s": {
                        if (!inferSymetry) break;
                        String ruleString = "[sym" + i + ": (?a " + ancestorString + " ?b) -> (?b " + ancestorString + " ?a)] ";
                        res.add(Rule.parseRule((String)ruleString));
                        break;
                    }
                    default: {
                        if (!inferSymetry) break;
                        String ruleString = "[inv" + i + ": (?a " + childString + " ?b) -> (?b " + ancestorString + " ?a)] ";
                        res.add(Rule.parseRule((String)ruleString));
                        ruleString = "[inv" + ++i + ": (?a " + ancestorString + " ?b) -> (?b " + childString + " ?a)] ";
                        res.add(Rule.parseRule((String)ruleString));
                    }
                }
                ++i;
            }
        }
        return res;
    }

    private static void addRulesFromSource(String filePath, List<Rule> rules) {
        try {
            FileInputStream rulesFile = new FileInputStream(filePath);
            BufferedReader in = new BufferedReader(new InputStreamReader(rulesFile));
            Rule.Parser p = Rule.rulesParserFromReader((BufferedReader)in);
            rules.addAll(Rule.parseRules((Rule.Parser)p));
            ((InputStream)rulesFile).close();
        }
        catch (IOException | Rule.ParserException e) {
            System.err.println("error parsing " + filePath + " while trying to add rules");
            e.printStackTrace(System.err);
        }
    }

    public static Reasoner getReasoner(Model ontModel, String rulesPath, boolean symmetry) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll(BDRCReasoner.getRulesFromModel(ontModel, symmetry));
        BDRCReasoner.addRulesFromSource(rulesPath, rules);
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        reasoner.setParameter(ReasonerVocabulary.PROPruleMode, (Object)"forward");
        return reasoner;
    }

    public static Model getUnreasonable(Model ontModel, Model m) {
        Dataset union = DatasetFactory.create();
        union.addNamedModel("http://example.com/ont", ontModel);
        union.addNamedModel("http://example.com/other", m);
        String queryString = "PREFIX bdo: <http://purl.bdrc.io/ontology/core/>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nCONSTRUCT {?s ?p ?o .} WHERE {\n  {\n     graph <http://example.com/ont> { ?subclass rdfs:subClassOf+ ?o . } graph <http://example.com/other> { ?s rdf:type ?subclass, ?o . } BIND(rdf:type as ?p) \n  } UNION {\n     graph <http://example.com/ont> { ?subprop rdfs:subPropertyOf+ ?p . } graph <http://example.com/other> { ?s ?subprop ?o ; ?p ?o . } \n  }\n}\n";
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)union);
        return qexec.execConstruct();
    }
}

