/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.libraries.formatters;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.utils.JsonUtils;
import io.bdrc.libraries.LibProps;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.JsonLDWriteContext;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.writer.JsonLDWriter;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONLDFormatter {
    protected static final Map<DocType, Object> typeToFrameObject = new EnumMap<DocType, Object>(DocType.class);
    static final ObjectMapper mapper = new ObjectMapper();
    public static final Map<String, Object> bdoContextObject = JSONLDFormatter.getBDOContext();
    public static final Map<String, Object> annContextObject = JSONLDFormatter.getAnnMergedContext();
    public static final Map<String, Object> oaContextObject = JSONLDFormatter.getOaMergedContext();
    public static final Logger log = LoggerFactory.getLogger(JSONLDFormatter.class);
    public static final String simpleContext = "http://purl.bdrc.io/context.jsonld";
    public static final String annoContext = "http://www.w3.org/ns/anno.jsonld";
    public static final String oaContext = "http://www.w3.org/ns/oa.jsonld";
    public static final String ldpContext = "http://www.w3.org/ns/ldp.jsonld";
    public static boolean prettyPrint = true;
    public static final String ANN_PREFIX_SHORT = "bdan";
    public static final String ANC_PREFIX_SHORT = "bdac";
    public static final JsonLdOptions jsonLdOptions = new JsonLdOptions();
    public static final Map<DocType, Object> docTypeToSimpleContext;
    public static final Map<DocType, Object> docTypeToContextObject;
    public static final Map<String, DocType> typeToDocType;
    public static final Map<DocType, Object> typeToRootShortUri;

    public static Map<String, Object> getBDOContext() {
        Map map = null;
        try {
            FileInputStream in = new FileInputStream(LibProps.getProperty("jsonldContextFile"));
            map = (Map)mapper.readValue((InputStream)in, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
            in.close();
        }
        catch (Exception e) {
            log.error("Error reading context file :" + e);
            e.printStackTrace();
            return null;
        }
        return (Map)map.get("@context");
    }

    public static Map<String, Object> getAnnMergedContext() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.putAll(bdoContextObject);
        Map map = null;
        ClassLoader classLoader = JSONLDFormatter.class.getClassLoader();
        try {
            InputStream is = classLoader.getResourceAsStream("contexts/ldp.jsonld");
            map = (Map)mapper.readValue(is, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
            res.putAll((Map)map.get("@context"));
            is = classLoader.getResourceAsStream("contexts/anno.jsonld");
            map = (Map)mapper.readValue(is, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
            res.putAll((Map)map.get("@context"));
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        res.remove(ANN_PREFIX_SHORT);
        res.remove(ANC_PREFIX_SHORT);
        return res;
    }

    public static Map<String, Object> getOaMergedContext() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        ClassLoader classLoader = JSONLDFormatter.class.getClassLoader();
        res.putAll(bdoContextObject);
        Map map = null;
        try {
            InputStream is = classLoader.getResourceAsStream("contexts/oa.jsonld");
            map = (Map)mapper.readValue(is, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
            res.putAll((Map)map.get("@context"));
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        res.remove(ANN_PREFIX_SHORT);
        res.remove(ANC_PREFIX_SHORT);
        return res;
    }

    private static void initializeAnnFrameObjects() {
        Map res = null;
        ClassLoader classLoader = JSONLDFormatter.class.getClassLoader();
        try {
            InputStream is = classLoader.getResourceAsStream("contexts/annotation_frame.jsonld");
            res = (Map)mapper.readValue(is, (TypeReference)new TypeReference<Map<String, Object>>(){});
            res.put("@context", annContextObject);
            typeToFrameObject.put(DocType.ANN, res);
            typeToFrameObject.put(DocType.OA, res);
            is = classLoader.getResourceAsStream("contexts/collection_frame.jsonld");
            res = (Map)mapper.readValue(is, (TypeReference)new TypeReference<Map<String, Object>>(){});
            res.put("@context", annContextObject);
            typeToFrameObject.put(DocType.ANC, res);
            is = classLoader.getResourceAsStream("contexts/page_frame.jsonld");
            res = (Map)mapper.readValue(is, (TypeReference)new TypeReference<Map<String, Object>>(){});
            res.put("@context", annContextObject);
            typeToFrameObject.put(DocType.ANP, res);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Object getFrameObject(DocType type, String mainResourceUri) {
        boolean needsId;
        boolean bl = needsId = type == DocType.WORK || type == DocType.TEST;
        if (!needsId && typeToFrameObject.containsKey((Object)type)) {
            return typeToFrameObject.get((Object)type);
        }
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        if (needsId) {
            jsonObject.put("@id", mainResourceUri);
        } else {
            jsonObject.put("@type", typeToRootShortUri.get((Object)type));
            typeToFrameObject.put(type, jsonObject);
        }
        jsonObject.put("@context", bdoContextObject);
        return jsonObject;
    }

    protected static void insertRec(String k, Object v, SortedMap<String, Object> tm) throws IllegalArgumentException {
        if (k.equals("@graph")) {
            if (v instanceof ArrayList) {
                if (((ArrayList)v).size() == 0) {
                    tm.put(k, v);
                    return;
                }
                Object o = ((ArrayList)v).get(0);
                if (o instanceof Map) {
                    Map<String, Object> orderedo = JSONLDFormatter.orderEntries((Map)o);
                    ((ArrayList)v).set(0, orderedo);
                }
                tm.put(k, v);
            } else {
                tm.put(k, JSONLDFormatter.orderEntries((Map)v));
            }
        } else {
            tm.put(k, v);
        }
    }

    protected static Map<String, Object> orderEntries(Map<String, Object> input) throws IllegalArgumentException {
        TreeMap<String, Object> res = new TreeMap<String, Object>(new JsonLDComparator());
        input.forEach((k, v) -> JSONLDFormatter.insertRec(k, v, res));
        return res;
    }

    public static DocType getDocType(Model m, String mainResourceUri) {
        NodeIterator ni = m.listObjectsOfProperty(m.getResource(mainResourceUri), RDF.type);
        DocType res = null;
        while (ni.hasNext()) {
            RDFNode n = ni.next();
            String t = n.asResource().getLocalName();
            res = typeToDocType.get(t);
            if (res == null) continue;
            return res;
        }
        return res;
    }

    public static Map<String, Object> modelToJsonObject(Model m, String mainResourceUri, DocType type, PrefixMap pm) {
        if (type == null && (type = JSONLDFormatter.getDocType(m, mainResourceUri)) == null) {
            log.info("not able to determine type of resource {} for frame output, outputting compact", (Object)mainResourceUri);
            return JSONLDFormatter.modelToJsonObject(m, null, mainResourceUri, RDFFormat.JSONLD_COMPACT_PRETTY, false, pm);
        }
        return JSONLDFormatter.modelToJsonObject(m, type, mainResourceUri, RDFFormat.JSONLD_FRAME_PRETTY, false, pm);
    }

    public static Map<String, Object> modelToJsonObject(Model m, DocType type, String mainResourceUri, RDFFormat format, boolean reorder, PrefixMap pm) {
        Map<String, Object> tm;
        JsonLDWriteContext ctx = new JsonLDWriteContext();
        if (format.equals((Object)RDFFormat.JSONLD_FRAME_PRETTY) || format.equals((Object)RDFFormat.JSONLD_FRAME_FLAT)) {
            Object frameObj = JSONLDFormatter.getFrameObject(type, mainResourceUri);
            ctx.setFrame(frameObj);
        }
        RDFFormat.JSONLDVariant variant = (RDFFormat.JSONLDVariant)format.getVariant();
        ctx.setJsonLDContext(docTypeToContextObject.get((Object)type));
        ctx.setOptions(jsonLdOptions);
        DatasetGraph g = DatasetFactory.create((Model)m).asDatasetGraph();
        try {
            tm = (Map<String, Object>)JsonLDWriter.toJsonLDJavaAPI((RDFFormat.JSONLDVariant)variant, (DatasetGraph)g, (PrefixMap)pm, null, (Context)ctx);
            tm.replace("@context", docTypeToSimpleContext.get((Object)type));
            if (reorder) {
                tm = JSONLDFormatter.orderEntries(tm);
            }
        }
        catch (JsonLdError | IOException e) {
            e.printStackTrace();
            return null;
        }
        return tm;
    }

    public static void jsonObjectToOutputStream(Object jsonObject, OutputStream out) {
        OutputStreamWriter wr = new OutputStreamWriter(out, Chars.charsetUTF8);
        try {
            if (prettyPrint) {
                JsonUtils.writePrettyPrint((Writer)wr, (Object)jsonObject);
                wr.write("\n");
            } else {
                JsonUtils.write((Writer)wr, (Object)jsonObject);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IO.flush((Writer)wr);
    }

    public static void writeModelAsCompact(Model m, OutputStream out, PrefixMap pm) {
        Map<String, Object> jsonO = JSONLDFormatter.modelToJsonObject(m, null, null, RDFFormat.JSONLD_COMPACT_PRETTY, false, pm);
        JSONLDFormatter.jsonObjectToOutputStream(jsonO, out);
    }

    static {
        jsonLdOptions.setProcessingMode("json-ld-1.1");
        jsonLdOptions.setUseNativeTypes(Boolean.valueOf(true));
        jsonLdOptions.setCompactArrays(Boolean.valueOf(true));
        jsonLdOptions.setPruneBlankNodeIdentifiers(Boolean.valueOf(true));
        JSONLDFormatter.initializeAnnFrameObjects();
        docTypeToSimpleContext = new HashMap<DocType, Object>();
        docTypeToSimpleContext.put(null, simpleContext);
        docTypeToSimpleContext.put(DocType.PERSON, simpleContext);
        docTypeToSimpleContext.put(DocType.VOLUME, simpleContext);
        docTypeToSimpleContext.put(DocType.WORK, simpleContext);
        docTypeToSimpleContext.put(DocType.PLACE, simpleContext);
        docTypeToSimpleContext.put(DocType.TOPIC, simpleContext);
        docTypeToSimpleContext.put(DocType.LINEAGE, simpleContext);
        docTypeToSimpleContext.put(DocType.CORPORATION, simpleContext);
        docTypeToSimpleContext.put(DocType.PRODUCT, simpleContext);
        docTypeToSimpleContext.put(DocType.ITEM, simpleContext);
        docTypeToSimpleContext.put(DocType.ROLE, simpleContext);
        docTypeToSimpleContext.put(DocType.ANN, Arrays.asList(simpleContext, annoContext));
        docTypeToSimpleContext.put(DocType.ANC, Arrays.asList(simpleContext, annoContext, ldpContext));
        docTypeToSimpleContext.put(DocType.ANP, Arrays.asList(simpleContext, annoContext));
        docTypeToSimpleContext.put(DocType.OA, Arrays.asList(simpleContext, oaContext));
        docTypeToContextObject = new HashMap<DocType, Object>();
        docTypeToContextObject.put(null, bdoContextObject);
        docTypeToContextObject.put(DocType.PERSON, bdoContextObject);
        docTypeToContextObject.put(DocType.VOLUME, bdoContextObject);
        docTypeToContextObject.put(DocType.WORK, bdoContextObject);
        docTypeToContextObject.put(DocType.PLACE, bdoContextObject);
        docTypeToContextObject.put(DocType.TOPIC, bdoContextObject);
        docTypeToContextObject.put(DocType.LINEAGE, bdoContextObject);
        docTypeToContextObject.put(DocType.CORPORATION, bdoContextObject);
        docTypeToContextObject.put(DocType.PRODUCT, bdoContextObject);
        docTypeToContextObject.put(DocType.ITEM, bdoContextObject);
        docTypeToContextObject.put(DocType.ROLE, bdoContextObject);
        docTypeToContextObject.put(DocType.ANN, annContextObject);
        docTypeToContextObject.put(DocType.ANC, annContextObject);
        docTypeToContextObject.put(DocType.ANP, annContextObject);
        docTypeToContextObject.put(DocType.OA, oaContextObject);
        typeToDocType = new HashMap<String, DocType>();
        typeToDocType.put("Person", DocType.PERSON);
        typeToDocType.put("Volume", DocType.VOLUME);
        typeToDocType.put("Work", DocType.WORK);
        typeToDocType.put("Place", DocType.PLACE);
        typeToDocType.put("Topic", DocType.TOPIC);
        typeToDocType.put("Lineage", DocType.LINEAGE);
        typeToDocType.put("Corporation", DocType.CORPORATION);
        typeToDocType.put("Product", DocType.PRODUCT);
        typeToDocType.put("Item", DocType.ITEM);
        typeToDocType.put("Role", DocType.ROLE);
        typeToDocType.put("Annotation", DocType.ANN);
        typeToDocType.put("OrderedCollection", DocType.ANC);
        typeToDocType.put("OrderedCollectionPage", DocType.ANP);
        typeToRootShortUri = new EnumMap<DocType, Object>(DocType.class);
        typeToRootShortUri.put(DocType.PERSON, "Person");
        typeToRootShortUri.put(DocType.VOLUME, Arrays.asList("Volume", "VolumeImageAsset", "VolumePhysicalAsset"));
        typeToRootShortUri.put(DocType.WORK, "Work");
        typeToRootShortUri.put(DocType.PLACE, "Place");
        typeToRootShortUri.put(DocType.TOPIC, "Topic");
        typeToRootShortUri.put(DocType.LINEAGE, "Lineage");
        typeToRootShortUri.put(DocType.CORPORATION, "Corporation");
        typeToRootShortUri.put(DocType.PRODUCT, "adm:Product");
        typeToRootShortUri.put(DocType.ITEM, Arrays.asList("Item", "ItemImageAsset", "ItemInputEtext", "ItemOCREtext", "ItemPhysicalAsset"));
        typeToRootShortUri.put(DocType.ROLE, "Role");
        typeToRootShortUri.put(DocType.ANN, "Annotation");
        typeToRootShortUri.put(DocType.ANC, "as:OrderedCollection");
        typeToRootShortUri.put(DocType.ANP, "AnnotationPage");
    }

    static class JsonLDComparator
    implements Comparator<String> {
        JsonLDComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1.equals("adm:logEntry")) {
                return 1;
            }
            if (s2.equals("adm:logEntry")) {
                return -1;
            }
            if (s1.startsWith("adm:")) {
                return 1;
            }
            if (s1.startsWith("tbr:")) {
                return 1;
            }
            if (s2.startsWith("adm:")) {
                return -1;
            }
            if (s2.startsWith("tbr:")) {
                return -1;
            }
            if (s1.equals("@context")) {
                return 1;
            }
            if (s1.equals("@graph")) {
                return -1;
            }
            if (s1.equals("rdfs:label")) {
                return -1;
            }
            if (s1.equals("skos:prefLabel")) {
                return -1;
            }
            if (s1.equals("skos:altLabel")) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }

    public static enum DocType {
        CORPORATION,
        LINEAGE,
        ETEXT,
        ETEXTCONTENT,
        ROLE,
        PERSON,
        VOLUME,
        PLACE,
        TOPIC,
        ITEM,
        WORK,
        PRODUCT,
        TEST,
        ANN,
        ANC,
        ANP,
        OA;

    }
}

