/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.libraries;

import io.bdrc.libraries.Models;
import io.bdrc.libraries.Prefixes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.reasoner.Reasoner;

public class SparqlCommons {
    public static boolean validateResultVars(Query q, ArrayList<String> expectedVars) {
        Collections.sort(expectedVars);
        List vars = q.getResultVars();
        Collections.sort(vars);
        return expectedVars.equals(vars);
    }

    public static boolean validateResultVars(String query, ArrayList<String> expectedVars) {
        Query q = QueryFactory.create((String)(Prefixes.getPrefixesString() + query));
        return SparqlCommons.validateResultVars(q, expectedVars);
    }

    public static HashMap<String, ArrayList<String>> getGraphsForResourceByGitRepos(String resUri, String fusekiUrl) {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        String query = "SELECT DISTINCT ?g ?rep\nWHERE{\nGRAPH ?g {\n{\n?s ?p <" + resUri + "> .\n} \n    union {\n<" + resUri + "> ?pp ?oo .\n}\n?ad adm:graphId ?g .\n?ad adm:gitRepo ?rep\n}\n}ORDER BY ?rep";
        Query q = QueryFactory.create((String)(Prefixes.getPrefixesString() + query));
        System.out.println(q.toString());
        QueryExecution qe = QueryExecutionFactory.sparqlService((String)fusekiUrl, (Query)q);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            String rep = qs.get("?rep").asResource().getURI();
            ArrayList<String> list = map.get(rep);
            if (list == null) {
                list = new ArrayList();
            }
            list.add(qs.get("?g").asResource().getURI());
            map.put(rep, list);
        }
        return map;
    }

    public static HashMap<String, ArrayList<String>> getGraphsByGitRepos(ArrayList<String> graphUris, String fusekiUrl) {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        String query = "select ?g ?rep\nwhere{\t?ad adm:graphId ?g .    ?ad adm:gitRepo ?rep  values ?g { ";
        for (String uri : graphUris) {
            query = query + " <" + uri + "> ";
        }
        query = query + " } }";
        System.out.println(query);
        Query q = QueryFactory.create((String)(Prefixes.getPrefixesString() + query));
        QueryExecution qe = QueryExecutionFactory.sparqlService((String)fusekiUrl, (Query)q);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            String rep = qs.get("?rep").asResource().getURI();
            ArrayList<String> uris = map.get(rep);
            if (uris == null) {
                uris = new ArrayList();
            }
            uris.add(qs.get("?g").asResource().getURI());
            map.put(rep, uris);
        }
        return map;
    }

    public static HashMap<String, ArrayList<String>> getGraphsByGitRepos(String query, String fusekiUrl) {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        Query q = QueryFactory.create((String)(Prefixes.getPrefixesString() + query));
        ArrayList<String> vars = new ArrayList<String>(Arrays.asList("g", "rep"));
        if (!SparqlCommons.validateResultVars(q, vars)) {
            return map;
        }
        QueryExecution qe = QueryExecutionFactory.sparqlService((String)fusekiUrl, (Query)q);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            String rep = qs.get("?rep").asResource().getURI();
            ArrayList<String> uris = map.get(rep);
            if (uris == null) {
                uris = new ArrayList();
            }
            uris.add(qs.get("?g").asResource().getURI());
            map.put(rep, uris);
        }
        return map;
    }

    public static HashMap<String, ArrayList<String>> getGraphsByGitReposHavingProp(ArrayList<String> graphUris, String propUri, String fusekiUrl) {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        String query = "select distinct ?g ?rep where {   graph ?g {?s <" + propUri + "> ?o .}   ?ad adm:graphId ?g .   ?ad adm:gitRepo ?rep }";
        System.out.println(query);
        Query q = QueryFactory.create((String)(Prefixes.getPrefixesString() + query));
        QueryExecution qe = QueryExecutionFactory.sparqlService((String)fusekiUrl, (Query)q);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            String rep = qs.get("?rep").asResource().getURI();
            ArrayList<String> uris = map.get(rep);
            if (uris == null) {
                uris = new ArrayList();
            }
            uris.add(qs.get("?g").asResource().getURI());
            map.put(rep, uris);
        }
        return map;
    }

    public static Model replaceRefInModel(Model mod, String graphUri, String toReplaceUri, String newUri, Reasoner bdrcReasoner) {
        String query = "with <" + graphUri + "> \nDELETE { <" + toReplaceUri + "> ?p ?s.}\nINSERT { <" + newUri + "> ?p ?s .}\nWHERE\n{ <" + toReplaceUri + "> ?p ?s .};\nwith <" + graphUri + "> \nDELETE { ?s1 ?p1 <" + toReplaceUri + ">}\nINSERT { ?s1 ?p1 <" + newUri + ">}\nWHERE\n  { ?s1 ?p1 <" + toReplaceUri + ">}";
        query = Prefixes.getPrefixesString() + " " + query;
        Dataset ds = DatasetFactory.create();
        ds.addNamedModel(graphUri, mod);
        RDFConnection conn = RDFConnectionFactory.connect((Dataset)ds);
        conn.update(query);
        conn.commit();
        conn.close();
        Model m = ds.getNamedModel(graphUri);
        if (bdrcReasoner != null) {
            m = ModelFactory.createInfModel((Reasoner)bdrcReasoner, (Model)m);
        }
        return m;
    }

    public static Model setStatusWithDrawn(Model m, String adminGraphUri, String statusUri) {
        StmtIterator stmt = m.listStatements();
        Statement stt = ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)adminGraphUri), (Property)ResourceFactory.createProperty((String)Models.STATUS_PROP), (RDFNode)ResourceFactory.createResource((String)Models.STATUS_WITHDRAWN));
        ArrayList<Statement> to_remove = new ArrayList<Statement>();
        ArrayList<Statement> to_add = new ArrayList<Statement>();
        while (stmt.hasNext()) {
            Statement st = (Statement)stmt.next();
            if (!st.getPredicate().equals(ResourceFactory.createProperty((String)Models.STATUS_PROP))) continue;
            to_remove.add(st);
            to_add.add(stt);
        }
        for (Statement str : to_remove) {
            m.remove(str);
        }
        for (Statement sta : to_add) {
            m.add(sta);
        }
        m.add(stt);
        return m;
    }

    public static Model setPropValue(Model m, String adminGraphUri, Property p, Resource value) {
        StmtIterator stmt = m.listStatements();
        Statement stt = ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)adminGraphUri), (Property)p, (RDFNode)value);
        ArrayList<Statement> to_remove = new ArrayList<Statement>();
        ArrayList<Statement> to_add = new ArrayList<Statement>();
        while (stmt.hasNext()) {
            Statement st = (Statement)stmt.next();
            if (!st.getPredicate().equals(p)) continue;
            to_remove.add(st);
            to_add.add(stt);
        }
        for (Statement str : to_remove) {
            m.remove(str);
        }
        for (Statement sta : to_add) {
            m.add(sta);
        }
        m.add(stt);
        return m;
    }

    public static Model setLiteralPropValue(Model m, String adminGraphUri, Property p, String value, String lang) {
        StmtIterator stmt = m.listStatements();
        Literal l = null;
        l = lang != null ? ResourceFactory.createLangLiteral((String)value, (String)lang) : ResourceFactory.createPlainLiteral((String)value);
        Statement stt = ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)adminGraphUri), (Property)p, (RDFNode)l);
        ArrayList<Statement> to_remove = new ArrayList<Statement>();
        ArrayList<Statement> to_add = new ArrayList<Statement>();
        while (stmt.hasNext()) {
            Statement st = (Statement)stmt.next();
            if (!st.getPredicate().equals(p)) continue;
            to_remove.add(st);
            to_add.add(stt);
        }
        for (Statement str : to_remove) {
            m.remove(str);
        }
        for (Statement sta : to_add) {
            m.add(sta);
        }
        m.add(stt);
        return m;
    }

    public static Model setGitRevision(Model m, String adminGraphUri, String revNumber) {
        StmtIterator stmt = m.listStatements();
        Statement stt = ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)adminGraphUri), (Property)ResourceFactory.createProperty((String)Models.GIT_REVISION), (RDFNode)ResourceFactory.createPlainLiteral((String)revNumber));
        ArrayList<Statement> to_remove = new ArrayList<Statement>();
        ArrayList<Statement> to_add = new ArrayList<Statement>();
        while (stmt.hasNext()) {
            Statement st = (Statement)stmt.next();
            if (!st.getPredicate().equals(ResourceFactory.createProperty((String)Models.GIT_REVISION))) continue;
            to_remove.add(st);
            to_add.add(stt);
        }
        for (Statement str : to_remove) {
            m.remove(str);
        }
        for (Statement sta : to_add) {
            m.add(sta);
        }
        m.add(stt);
        return m;
    }

    public static Model addResourceValueForPropInGraph(Model m, Property p, Resource ro) {
        ResIterator it = m.listResourcesWithProperty(p);
        ArrayList<Statement> to_add = new ArrayList<Statement>();
        while (it.hasNext()) {
            Resource rs = (Resource)it.next();
            Statement stt = ResourceFactory.createStatement((Resource)rs, (Property)p, (RDFNode)ro);
            to_add.add(stt);
        }
        for (Statement st : to_add) {
            m.add(st);
        }
        return m;
    }

    public static Model addLiteralValueForPropInGraph(Model m, Property p, String value, String lang) {
        Literal l = null;
        l = lang != null ? ResourceFactory.createLangLiteral((String)value, (String)lang) : ResourceFactory.createPlainLiteral((String)value);
        ArrayList<Statement> to_add = new ArrayList<Statement>();
        ResIterator it = m.listResourcesWithProperty(p);
        while (it.hasNext()) {
            Resource rs = (Resource)it.next();
            Statement stt = ResourceFactory.createStatement((Resource)rs, (Property)p, (RDFNode)l);
            to_add.add(stt);
        }
        return m;
    }

    public static Model renamePropInGraph(Model m, Property oldProp, Property newProp) {
        StmtIterator stmt = m.listStatements();
        ArrayList<Statement> to_remove = new ArrayList<Statement>();
        ArrayList<Statement> to_add = new ArrayList<Statement>();
        while (stmt.hasNext()) {
            Statement st = (Statement)stmt.next();
            if (!st.getPredicate().equals(oldProp)) continue;
            to_remove.add(st);
            Statement stt = ResourceFactory.createStatement((Resource)st.getSubject(), (Property)newProp, (RDFNode)st.getObject());
            to_add.add(stt);
        }
        for (Statement str : to_remove) {
            m.remove(str);
        }
        for (Statement sta : to_add) {
            m.add(sta);
        }
        return m;
    }

    public static void main(String[] args) throws IOException {
        ArrayList<String> uris = new ArrayList<String>();
        uris.add("http://purl.bdrc.io/graph/P1583");
        uris.add("http://purl.bdrc.io/graph/P1585");
        uris.add("http://purl.bdrc.io/graph/W22703");
        uris.add("http://purl.bdrc.io/graph/T2423");
        System.out.println(SparqlCommons.getGraphsByGitRepos(uris, "http://buda1.bdrc.io:13180/fuseki/testrw/query"));
        String q = "select ?g ?rep\nwhere{\t?ad adm:graphId ?g .    ?ad adm:gitRepo ?rep  values ?g {  <http://purl.bdrc.io/graph/P1583>  <http://purl.bdrc.io/graph/P1585>  <http://purl.bdrc.io/graph/W22703>  <http://purl.bdrc.io/graph/T2423>  } }\n";
        SparqlCommons.getGraphsByGitRepos(q, "http://buda1.bdrc.io:13180/fuseki/testrw/query");
    }
}

