/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.rdf;

import io.bdrc.auth.AuthProps;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelUpdate
implements Runnable {
    public static final Logger log = LoggerFactory.getLogger((String)ModelUpdate.class.getName());

    @Override
    public void run() {
        if (AuthProps.getProperty("serviceUpdates") != null) {
            List<String> serviceUpdates = Arrays.asList(AuthProps.getProperty("serviceUpdates").split(","));
            log.info("Auth model needs to be updated on {} ", serviceUpdates);
            for (String baseUrl : serviceUpdates) {
                try {
                    int code = this.dispatchAuthUpdate(baseUrl.trim());
                    if (code != 200) {
                        log.error("Auth model was not updated on {}, http code is {}", (Object)baseUrl, (Object)code);
                    }
                    log.info("Auth model update signal was sent to {}, http code is {}", (Object)baseUrl, (Object)code);
                }
                catch (IOException e) {
                    log.error("Auth model was not updated on {}, exception message is {}", (Object)baseUrl, (Object)e.getMessage());
                }
            }
        }
    }

    private int dispatchAuthUpdate(String urlBase) throws ClientProtocolException, IOException {
        CloseableHttpClient client = HttpClientBuilder.create().disableCookieManagement().build();
        HttpPost post = new HttpPost(urlBase + "/callbacks/github/bdrc-auth");
        HttpResponse response = client.execute((HttpUriRequest)post);
        return response.getStatusLine().getStatusCode();
    }
}

