/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.model;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.util.iterator.ExtendedIterator;

public class ResourceAccess {
    String policy = "";
    String permission = "";

    public ResourceAccess(Model model, String resourceId) {
        Triple t = new Triple(NodeFactory.createURI((String)resourceId), Node.ANY, Node.ANY);
        ExtendedIterator ext = model.getGraph().find(t);
        while (ext.hasNext()) {
            String prop;
            Triple tmp = (Triple)ext.next();
            switch (prop = tmp.getPredicate().getURI()) {
                case "http://purl.bdrc.io/ontology/ext/auth/forPermission": {
                    this.permission = tmp.getObject().getLocalName();
                    break;
                }
                case "http://purl.bdrc.io/ontology/ext/auth/policy": {
                    this.policy = tmp.getObject().getLocalName();
                }
            }
        }
    }

    public ResourceAccess() {
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policyLocalName) {
        this.policy = policyLocalName;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permissionLocalName) {
        this.permission = permissionLocalName;
    }

    public String toString() {
        return "ResourceAccess [policy=" + this.policy + ", permission=" + this.permission + "]";
    }
}

