/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.bdrc.auth.rdf.RdfConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class Group {
    String id;
    String name;
    String desc;
    ArrayList<String> members;
    ArrayList<String> roles;
    Model model;
    static final ObjectMapper mapper = new ObjectMapper();

    public Group(JsonNode json) throws IOException {
        Iterator it;
        this.id = this.getJsonValue(json, "_id");
        this.name = this.getJsonValue(json, "name");
        this.desc = this.getJsonValue(json, "description");
        this.members = new ArrayList();
        ArrayNode array = (ArrayNode)json.findValue("members");
        if (array != null) {
            it = ((ArrayNode)json.findValue("members")).iterator();
            while (it.hasNext()) {
                this.members.add(((JsonNode)it.next()).asText());
            }
        }
        this.roles = new ArrayList();
        array = (ArrayNode)json.findValue("roles");
        if (array != null) {
            it = array.iterator();
            while (it.hasNext()) {
                this.roles.add(((JsonNode)it.next()).asText());
            }
        }
        this.model = this.buildModel();
    }

    public Group() {
        this.id = "";
        this.name = "";
        this.desc = "";
        this.members = new ArrayList();
        this.roles = new ArrayList();
    }

    String getJsonValue(JsonNode json, String key) {
        JsonNode tmp = json.findValue(key);
        if (tmp != null) {
            return tmp.asText();
        }
        return "";
    }

    Model buildModel() {
        Resource gp = ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-nc/auth/" + this.id));
        Model res = ModelFactory.createDefaultModel();
        res.add(gp, RDF.type, (RDFNode)RdfConstants.GROUP);
        res.add(gp, RDFS.label, (RDFNode)ResourceFactory.createStringLiteral((String)this.name));
        res.add(gp, RdfConstants.DESC, (RDFNode)ResourceFactory.createStringLiteral((String)this.desc));
        for (String memb : this.members) {
            String memberUri = "http://purl.bdrc.io/resource-nc/auth/" + memb.substring(memb.indexOf("|") + 1);
            Resource member = ResourceFactory.createResource((String)memberUri);
            res.add(gp, RdfConstants.HAS_MEMBER, (RDFNode)member);
            res.add(member, RdfConstants.FOR_GROUP, (RDFNode)gp);
        }
        for (String role : this.roles) {
            res.add(gp, RdfConstants.HAS_ROLE, (RDFNode)ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-nc/auth/" + role)));
        }
        return res;
    }

    public void setMembers(ArrayList<String> members) {
        this.members = members;
    }

    public void setRoles(ArrayList<String> roles) {
        this.roles = roles;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public ArrayList<String> getMembers() {
        return this.members;
    }

    public ArrayList<String> getRoles() {
        return this.roles;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public boolean isValidRole(String role) {
        return this.roles.contains(role);
    }

    public boolean isMember(String member) {
        return this.members.contains(member);
    }

    public String toString() {
        return "Group [id=" + this.id + ", name=" + this.name + ", desc=" + this.desc + ", members=" + this.members + ", roles=" + this.roles + ", model=" + this.model + "]";
    }
}

