/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.model;

import io.bdrc.auth.AuthProps;
import io.bdrc.auth.model.BudaRdfUser;
import java.util.HashMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;

public class BudaUserInfo {
    public static final String SKOS_PREF_LABEL = "http://www.w3.org/2004/02/skos/core#prefLabel";
    public static final String BDOU_PFX = "http://purl.bdrc.io/ontology/ext/user/";
    private static HashMap<String, BudaRdfUser> budaUserByAuth0Id;

    private static Model loadModel() {
        String fusekiUrl = AuthProps.getProperty("fusekiAuthData");
        Model infos = ModelFactory.createDefaultModel();
        String query = "construct {  ?s <http://purl.bdrc.io/ontology/ext/user/hasUserProfile> ?pr. ?s <http://www.w3.org/2004/02/skos/core#prefLabel> ?label. } where { { ?s ?p ?o. ?s a <http://purl.bdrc.io/ontology/ext/user/User>. ?s <http://purl.bdrc.io/ontology/ext/user/hasUserProfile> ?pr. ?s <http://www.w3.org/2004/02/skos/core#prefLabel> ?label. }}";
        RDFConnection conn = RDFConnectionRemote.create().destination(fusekiUrl).build();
        infos = conn.queryConstruct(query);
        conn.close();
        return infos;
    }

    public static HashMap<String, BudaRdfUser> getBudaRdfUsers() {
        if (budaUserByAuth0Id == null) {
            Model m = BudaUserInfo.loadModel();
            budaUserByAuth0Id = new HashMap();
            ResIterator it = m.listSubjects();
            Property authId = ResourceFactory.createProperty((String)"http://purl.bdrc.io/ontology/ext/user/hasUserProfile");
            Property lab = ResourceFactory.createProperty((String)SKOS_PREF_LABEL);
            while (it.hasNext()) {
                Resource rs = (Resource)it.next();
                String auth0Id = rs.getPropertyResourceValue(authId).getURI();
                String key = auth0Id.substring(auth0Id.lastIndexOf("/") + 1);
                String label = rs.getProperty(lab).getObject().asLiteral().getString();
                budaUserByAuth0Id.put(key, new BudaRdfUser(rs.getURI(), auth0Id, label));
            }
        }
        return budaUserByAuth0Id;
    }

    public static BudaRdfUser getBudaRdfInfo(String auth0Id) {
        return BudaUserInfo.getBudaRdfUsers().get(auth0Id);
    }
}

