/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Verification;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bdrc.auth.AuthProps;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BdrcJwks {
    static JsonNode node;
    static RSAPublicKey publicKey;
    static Algorithm algo;
    static Verification verification;
    static JWTVerifier verifier;
    public static final Logger log;
    public static final String ALG = "alg";
    public static final String KID = "kid";
    public static final String KTY = "kty";
    public static final String USE = "use";
    public static final String X5C = "x5c";
    public static final String N = "n";
    public static final String E = "e";
    public static final String X5T = "x5t";

    public static String getValue(String key) {
        if (key.equals(X5C)) {
            return node.findValue(X5C).get(0).asText();
        }
        return node.findValue(key).asText();
    }

    static RSAPublicKey buildPublicKey() throws CertificateException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        BigInteger modulus = new BigInteger(1, Base64.getUrlDecoder().decode(BdrcJwks.getValue(N)));
        BigInteger exponent = new BigInteger(1, Base64.getUrlDecoder().decode(BdrcJwks.getValue(E)));
        return (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, exponent));
    }

    public static RSAPublicKey getPublicKey() {
        return publicKey;
    }

    static {
        log = LoggerFactory.getLogger((String)BdrcJwks.class.getName());
        try {
            ObjectMapper mapper = new ObjectMapper();
            URL url = new URL(AuthProps.getProperty("jwksUrl"));
            node = mapper.readTree(url);
            publicKey = BdrcJwks.buildPublicKey();
            algo = Algorithm.RSA256((RSAPublicKey)publicKey, null);
            verifier = JWT.require((Algorithm)algo).build();
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            log.error("initialization error", (Throwable)e);
        }
    }
}

