/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth;

import io.bdrc.auth.UserProfile;
import io.bdrc.auth.model.Endpoint;
import io.bdrc.auth.model.ResourceAccess;
import io.bdrc.auth.model.User;
import io.bdrc.auth.rdf.RdfAuthModel;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Access {
    final UserProfile user;
    final Endpoint endpoint;
    public static final Logger log = LoggerFactory.getLogger((String)Access.class.getName());

    public Access(UserProfile user, Endpoint endpoint) {
        this.user = user;
        this.endpoint = endpoint;
        log.info("Initialized Access with User {}", (Object)user);
    }

    public Access() {
        this.user = new UserProfile();
        this.endpoint = new Endpoint();
        log.info("Initialized Access with default empty user and endpoint");
    }

    public boolean hasEndpointAccess() {
        boolean acc = this.matchGroup() || this.matchRole() || this.matchPermissions();
        log.info("User {} has enpoint Access ? {}", (Object)this.user, (Object)acc);
        return acc;
    }

    public boolean hasResourceAccess(String accessType) {
        if ("AccessOpen".equals(accessType)) {
            log.info("User {} has resource Access ?", (Object)this.user);
            return true;
        }
        boolean acc = this.matchResourcePermissions(accessType);
        log.info("Does User {} have resource Access ?", (Object)this.user, (Object)acc);
        return acc;
    }

    public boolean isUserLoggedIn() {
        return !this.getUser().getUserId().equals("");
    }

    public AccessLevel hasResourceAccess(String resourceAccessLocalName, String resourceStatusLocalName, String resourceUri) {
        String accessPermission;
        if (!this.canUserAccessStatus(resourceStatusLocalName)) {
            if (this.canUserAccessResource(resourceUri)) {
                return AccessLevel.OPEN;
            }
            return AccessLevel.NOACCESS;
        }
        if ("AccessOpen".equals(resourceAccessLocalName)) {
            return AccessLevel.OPEN;
        }
        ResourceAccess access = RdfAuthModel.getResourceAccess(resourceAccessLocalName);
        if (access != null && this.user.hasPermission(accessPermission = access.getPermission())) {
            return AccessLevel.OPEN;
        }
        if (this.canUserAccessResource(resourceUri)) {
            return AccessLevel.OPEN;
        }
        if ("AccessFairUse".equals(resourceAccessLocalName)) {
            return AccessLevel.FAIR_USE;
        }
        if ("AccessMixed".equals(resourceAccessLocalName)) {
            return AccessLevel.MIXED;
        }
        return AccessLevel.NOACCESS;
    }

    public boolean canUserAccessStatus(String resourceStatusLocalName) {
        if ("StatusReleased".equals(resourceStatusLocalName)) {
            log.info("User {} can access status {} ", (Object)this.user, (Object)resourceStatusLocalName);
            return true;
        }
        ArrayList<String> groups = this.user.getGroups();
        ArrayList<String> anyStatusGroups = RdfAuthModel.getAnyStatusGroup();
        for (String s : groups) {
            if (!anyStatusGroups.contains("http://purl.bdrc.io/resource-nc/auth/" + s)) continue;
            log.info("User {} with groups {} can access status {} ", new Object[]{this.user, groups, s});
            return true;
        }
        log.info("User {} with groups {} cannot get access for statusGroups {} ", new Object[]{this.user, groups, anyStatusGroups});
        return false;
    }

    public boolean canUserAccessResource(String resourceUri) {
        ArrayList<String> personalAccess = RdfAuthModel.getPersonalAccess("http://purl.bdrc.io/resource-nc/auth/" + this.user.getUser().getUserId());
        log.info("User {} has personnal access {}", (Object)this.user, personalAccess);
        if (personalAccess != null) {
            boolean acc = personalAccess.contains(resourceUri);
            log.info("User {} has personnal access to {}  ? {}", new Object[]{this.user, resourceUri, acc});
            return acc;
        }
        log.info("User {} cannot access resource {} ", (Object)this.user, (Object)resourceUri);
        return false;
    }

    public boolean matchGroup() {
        boolean match = false;
        for (String gp : this.user.getGroups()) {
            if (!this.endpoint.getGroups().contains(gp)) continue;
            return true;
        }
        log.info("Do user groups {} match endpoint {} groups {} : {}", new Object[]{this.user.getGroups(), this.endpoint, this.endpoint.getGroups(), match});
        return match;
    }

    public boolean matchRole() {
        boolean match = false;
        for (String r : this.user.getRoles()) {
            if (!this.endpoint.getRoles().contains(r)) continue;
            return true;
        }
        log.info("Do user roles {} match endpoint {} roles {} : {}", new Object[]{this.user.getRoles(), this.endpoint, this.endpoint.getRoles(), match});
        return match;
    }

    public boolean matchPermissions() {
        boolean match = false;
        for (String pm : this.user.getPermissions()) {
            if (!this.endpoint.getPermissions().contains(pm)) continue;
            return true;
        }
        log.info("Do user permissions {} match endpoint {} permissions {} : {}", new Object[]{this.user.getPermissions(), this.endpoint, this.endpoint.getPermissions(), match});
        return match;
    }

    public boolean matchResourcePermissions(String accessTypeLocalName) {
        if ("AccessOpen".equals(accessTypeLocalName)) {
            log.info("Resource access is OPEN");
            return true;
        }
        ResourceAccess access = RdfAuthModel.getResourceAccess(accessTypeLocalName);
        log.info("Resource access is not OPEN it is {} for type parameter {} ", (Object)access, (Object)accessTypeLocalName);
        if (access != null) {
            for (String pm : this.user.getPermissions()) {
                if (!access.getPermission().equals(pm)) continue;
                log.info("User permissions {} match ResourceAccess {} permission {} ", new Object[]{this.user.getPermissions(), access, access.getPermission()});
                return true;
            }
        }
        log.info("User permissions {} DO NOT match ResourceAccess {} permission {} ", new Object[]{this.user.getPermissions(), access, access.getPermission()});
        return false;
    }

    public User getUser() {
        return this.user.getUser();
    }

    public String toString() {
        return "Access [user=" + this.user + ", endpoint=" + this.endpoint + "]";
    }

    public static enum AccessLevel {
        OPEN,
        FAIR_USE,
        MIXED,
        NOACCESS;

    }
}

