/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.rdf;

import io.bdrc.auth.AuthProps;
import io.bdrc.auth.rdf.RdfAuthModel;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.TimerTask;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelUpdate
extends TimerTask {
    public static final Logger log = LoggerFactory.getLogger((String)TimerTask.class.getName());

    @Override
    public void run() {
        Long lastLocalUpdate = RdfAuthModel.getUpdated();
        if (lastLocalUpdate == null) {
            lastLocalUpdate = 1L;
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(AuthProps.getProperty("authUpdatePath"));
        try {
            HttpResponse resp = client.execute((HttpUriRequest)get);
            if (resp.getStatusLine().getStatusCode() != 200) {
                throw new Exception("Update failed: " + AuthProps.getProperty("authUpdatePath") + " is not available");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            resp.getEntity().writeTo((OutputStream)baos);
            long lastDistUpdate = Long.parseLong(baos.toString());
            if (lastDistUpdate > lastLocalUpdate) {
                RdfAuthModel.readAuthModel();
            }
        }
        catch (Exception e) {
            log.error("error running ModelUpdate", (Throwable)e);
        }
    }
}

