/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.model;

import java.util.ArrayList;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.util.iterator.ExtendedIterator;

public class Endpoint {
    String path;
    String appId;
    ArrayList<String> groups = new ArrayList();
    ArrayList<String> roles = new ArrayList();
    ArrayList<String> permissions = new ArrayList();

    public Endpoint(Model model, String resourceId) {
        Triple t = new Triple(NodeFactory.createURI((String)resourceId), Node.ANY, Node.ANY);
        ExtendedIterator ext = model.getGraph().find(t);
        while (ext.hasNext()) {
            String prop;
            Triple tmp = (Triple)ext.next();
            String value = tmp.getObject().toString().replaceAll("\"", "");
            switch (prop = tmp.getPredicate().getURI()) {
                case "http://purl.bdrc.io/ontology/ext/auth/appId": {
                    this.appId = this.getShortName(value);
                    break;
                }
                case "http://purl.bdrc.io/ontology/ext/auth/path": {
                    this.path = value;
                    break;
                }
                case "http://purl.bdrc.io/ontology/ext/auth/forRole": {
                    this.roles.add(this.getShortName(value));
                    break;
                }
                case "http://purl.bdrc.io/ontology/ext/auth/forGroup": {
                    this.groups.add(this.getShortName(value));
                    break;
                }
                case "http://purl.bdrc.io/ontology/ext/auth/forPermission": {
                    this.permissions.add(this.getShortName(value));
                }
            }
        }
    }

    public Endpoint() {
        this.appId = "";
        this.path = "";
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setAppId(String app) {
        this.appId = app;
    }

    public void setGroups(ArrayList<String> groups) {
        this.groups = groups;
    }

    public void setRoles(ArrayList<String> roles) {
        this.roles = roles;
    }

    public void setPermissions(ArrayList<String> permissions) {
        this.permissions = permissions;
    }

    public String getPath() {
        return this.path;
    }

    public String getAppId() {
        return this.appId;
    }

    public ArrayList<String> getGroups() {
        return this.groups;
    }

    public ArrayList<String> getRoles() {
        return this.roles;
    }

    public ArrayList<String> getPermissions() {
        return this.permissions;
    }

    public String getShortName(String st) {
        return st.substring(st.lastIndexOf("/") + 1);
    }

    public String toString() {
        return "Endpoint [path=" + this.path + ", appId=" + this.appId + ", groups=" + this.groups + ", roles=" + this.roles + ", permissions=" + this.permissions + "]";
    }
}

