/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bdrc.auth.AuthProps;
import io.bdrc.auth.model.Application;
import io.bdrc.auth.model.Endpoint;
import io.bdrc.auth.model.Group;
import io.bdrc.auth.model.Permission;
import io.bdrc.auth.model.ResourceAccess;
import io.bdrc.auth.model.Role;
import io.bdrc.auth.model.User;
import io.bdrc.auth.rdf.RdfConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthDataModelBuilder {
    ArrayList<Group> groups;
    ArrayList<Role> roles;
    ArrayList<Permission> permissions;
    ArrayList<User> users;
    ArrayList<Endpoint> endpoints;
    ArrayList<ResourceAccess> access;
    ArrayList<Application> apps;
    ArrayList<String> paths;
    Model model;
    static final ObjectMapper mapper = new ObjectMapper();
    public static final Logger log = LoggerFactory.getLogger((String)AuthDataModelBuilder.class.getName());
    public static final String webTaskBaseUrl = AuthProps.getProperty("webTaskBaseUrl");
    public static final String auth0BaseUrl = AuthProps.getProperty("auth0BaseUrl");

    public AuthDataModelBuilder() throws ClientProtocolException, IOException {
        log.info("URL >> " + AuthProps.getProperty("policiesUrl"));
        HttpURLConnection connection = (HttpURLConnection)new URL(AuthProps.getProperty("policiesUrl")).openConnection();
        InputStream stream = connection.getInputStream();
        Model authMod = ModelFactory.createDefaultModel();
        authMod.read(stream, "", "TURTLE");
        stream.close();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost post = null;
        post = new HttpPost(auth0BaseUrl + "oauth/token");
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("grant_type", "client_credentials");
        json.put("client_id", AuthProps.getProperty("lds-pdiClientID"));
        json.put("client_secret", AuthProps.getProperty("lds-pdiClientSecret"));
        json.put("audience", "urn:auth0-authz-api");
        String post_data = mapper.writer().writeValueAsString(json);
        StringEntity se = new StringEntity(post_data);
        se.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
        post.setEntity((HttpEntity)se);
        HttpResponse response = client.execute((HttpUriRequest)post);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        response.getEntity().writeTo((OutputStream)baos);
        String json_resp = baos.toString();
        baos.close();
        JsonNode node = mapper.readTree(json_resp);
        String token = node.findValue("access_token").asText();
        this.model = ModelFactory.createDefaultModel();
        this.model.add(authMod);
        this.setGroups(token);
        this.setRoles(token);
        this.setPermissions(token);
        this.setUsers(token);
        this.setEndpoints(authMod);
        this.setResourceAccess(authMod);
        client = HttpClientBuilder.create().build();
        post = new HttpPost(auth0BaseUrl + "oauth/token");
        json = new HashMap();
        json.put("grant_type", "client_credentials");
        json.put("client_id", AuthProps.getProperty("lds-pdiClientID"));
        json.put("client_secret", AuthProps.getProperty("lds-pdiClientSecret"));
        json.put("audience", auth0BaseUrl + "api/v2/");
        post_data = mapper.writer().writeValueAsString(json);
        se = new StringEntity(post_data);
        se.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
        post.setEntity((HttpEntity)se);
        response = client.execute((HttpUriRequest)post);
        baos = new ByteArrayOutputStream();
        response.getEntity().writeTo((OutputStream)baos);
        json_resp = baos.toString();
        baos.close();
        node = mapper.readTree(json_resp);
        token = node.findValue("access_token").asText();
        this.setApps(token);
    }

    private void setApps(String token) throws ClientProtocolException, IOException {
        this.apps = new ArrayList();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(auth0BaseUrl + "api/v2/clients?fields=name,description,client_id,app_type&include_fields=true");
        get.addHeader("Authorization", "Bearer " + token);
        HttpResponse resp = client.execute((HttpUriRequest)get);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        resp.getEntity().writeTo((OutputStream)baos);
        JsonNode node = mapper.readTree(baos.toString());
        Iterator it = node.elements();
        while (it.hasNext()) {
            Application app = new Application((JsonNode)it.next());
            this.apps.add(app);
            this.model.add(app.getModel());
        }
        baos.close();
    }

    private void setGroups(String token) throws ClientProtocolException, IOException {
        this.groups = new ArrayList();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(webTaskBaseUrl + "groups");
        get.addHeader("Authorization", "Bearer " + token);
        HttpResponse resp = client.execute((HttpUriRequest)get);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        resp.getEntity().writeTo((OutputStream)baos);
        JsonNode node = mapper.readTree(baos.toString());
        baos.close();
        Iterator it = node.at("/groups").elements();
        while (it.hasNext()) {
            Group gp = new Group((JsonNode)it.next());
            this.groups.add(gp);
            this.model.add(gp.getModel());
        }
    }

    private void setRoles(String token) throws ClientProtocolException, IOException {
        this.roles = new ArrayList();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(webTaskBaseUrl + "roles");
        get.addHeader("Authorization", "Bearer " + token);
        HttpResponse resp = client.execute((HttpUriRequest)get);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        resp.getEntity().writeTo((OutputStream)baos);
        JsonNode node1 = mapper.readTree(baos.toString());
        baos.close();
        Iterator it = node1.at("/roles").elements();
        while (it.hasNext()) {
            Role role = new Role((JsonNode)it.next());
            this.roles.add(role);
            this.model.add(role.getModel());
        }
    }

    private void setPermissions(String token) throws ClientProtocolException, IOException {
        this.permissions = new ArrayList();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(webTaskBaseUrl + "permissions");
        get.addHeader("Authorization", "Bearer " + token);
        HttpResponse resp = client.execute((HttpUriRequest)get);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        resp.getEntity().writeTo((OutputStream)baos);
        JsonNode node1 = mapper.readTree(baos.toString());
        baos.close();
        Iterator it = node1.at("/permissions").elements();
        while (it.hasNext()) {
            Permission perm = new Permission((JsonNode)it.next());
            this.permissions.add(perm);
            this.model.add(perm.getModel());
        }
    }

    private void setUsers(String token) throws ClientProtocolException, IOException {
        this.users = new ArrayList();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(webTaskBaseUrl + "users");
        get.addHeader("Authorization", "Bearer " + token);
        HttpResponse resp = client.execute((HttpUriRequest)get);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        resp.getEntity().writeTo((OutputStream)baos);
        JsonNode node1 = mapper.readTree(baos.toString());
        baos.close();
        Iterator it = node1.at("/users").elements();
        while (it.hasNext()) {
            JsonNode tmp = (JsonNode)it.next();
            String authId = tmp.findValue("user_id").asText();
            User user = new User(tmp, this.getUserRoles(token, authId.replace("|", "%7C")));
            this.users.add(user);
            this.model.add(user.getModel());
        }
    }

    private ArrayList<String> getUserRoles(String token, String id) throws ClientProtocolException, IOException {
        ArrayList<String> roleList = new ArrayList<String>();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(webTaskBaseUrl + "users/" + id + "/roles/calculate");
        get.addHeader("Authorization", "Bearer " + token);
        HttpResponse resp = client.execute((HttpUriRequest)get);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        resp.getEntity().writeTo((OutputStream)baos);
        JsonNode node1 = mapper.readTree(baos.toString());
        baos.close();
        Iterator it = node1.elements();
        while (it.hasNext()) {
            roleList.add(this.getJsonValue((JsonNode)it.next(), "_id"));
        }
        return roleList;
    }

    private void setEndpoints(Model authMod) throws ClientProtocolException, IOException {
        this.endpoints = new ArrayList();
        this.paths = new ArrayList();
        Triple t = new Triple(Node.ANY, RDF.type.asNode(), RdfConstants.ENDPOINT.asNode());
        ExtendedIterator ext = authMod.getGraph().find(t);
        while (ext.hasNext()) {
            String st = ((Triple)ext.next()).getSubject().getURI();
            Endpoint end = new Endpoint(authMod, st);
            this.endpoints.add(end);
            this.paths.add(end.getPath());
        }
    }

    private void setResourceAccess(Model authMod) throws ClientProtocolException, IOException {
        this.access = new ArrayList();
        Triple t = new Triple(Node.ANY, RDF.type.asNode(), RdfConstants.RES_ACCESS.asNode());
        ExtendedIterator ext = authMod.getGraph().find(t);
        while (ext.hasNext()) {
            String st = ((Triple)ext.next()).getSubject().getURI();
            ResourceAccess acc = new ResourceAccess(authMod, st);
            this.access.add(acc);
        }
    }

    public Model getModel() {
        return this.model;
    }

    final String getJsonValue(JsonNode json, String key) {
        JsonNode tmp = json.findValue(key);
        if (tmp != null) {
            return tmp.asText();
        }
        return "";
    }

    public String toString() {
        return "AuthDataModelBuilder [groups=" + this.groups + ", roles=" + this.roles + ", permissions=" + this.permissions + ", users=" + this.users + ", endpoints=" + this.endpoints + ", access=" + this.access + ", apps=" + this.apps + ", paths=" + this.paths + ", model=" + this.model + "]";
    }
}

