/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth;

import io.bdrc.auth.UserProfile;
import io.bdrc.auth.model.Endpoint;
import io.bdrc.auth.model.ResourceAccess;
import io.bdrc.auth.model.User;
import io.bdrc.auth.rdf.RdfAuthModel;
import java.util.ArrayList;

public class Access {
    final UserProfile user;
    final Endpoint endpoint;

    public Access(UserProfile user, Endpoint endpoint) {
        this.user = user;
        this.endpoint = endpoint;
    }

    public Access() {
        this.user = new UserProfile();
        this.endpoint = new Endpoint();
    }

    public boolean hasEndpointAccess() {
        return this.matchGroup() || this.matchRole() || this.matchPermissions();
    }

    public boolean hasResourceAccess(String accessType) {
        if ("AccessOpen".equals(accessType)) {
            return true;
        }
        return this.matchResourcePermissions(accessType);
    }

    public boolean isUserLoggedIn() {
        return !this.getUser().getUserId().equals("");
    }

    public AccessLevel hasResourceAccess(String resourceAccessLocalName, String resourceStatusLocalName, String resourceUri) {
        String accessPermission;
        if (!this.canUserAccessStatus(resourceStatusLocalName)) {
            if (this.canUserAccessResource(resourceUri)) {
                return AccessLevel.OPEN;
            }
            return AccessLevel.NOACCESS;
        }
        if ("AccessOpen".equals(resourceAccessLocalName)) {
            return AccessLevel.OPEN;
        }
        ResourceAccess access = RdfAuthModel.getResourceAccess(resourceAccessLocalName);
        if (access != null && this.user.hasPermission(accessPermission = access.getPermission())) {
            return AccessLevel.OPEN;
        }
        if (this.canUserAccessResource(resourceUri)) {
            return AccessLevel.OPEN;
        }
        if ("AccessFairUse".equals(resourceAccessLocalName)) {
            return AccessLevel.FAIR_USE;
        }
        if ("AccessMixed".equals(resourceAccessLocalName)) {
            return AccessLevel.MIXED;
        }
        return AccessLevel.NOACCESS;
    }

    public boolean canUserAccessStatus(String resourceStatusLocalName) {
        if ("StatusReleased".equals(resourceStatusLocalName)) {
            return true;
        }
        ArrayList<String> groups = this.user.getGroups();
        ArrayList<String> anyStatusGroups = RdfAuthModel.getAnyStatusGroup();
        for (String s : groups) {
            if (!anyStatusGroups.contains("http://purl.bdrc.io/resource-nc/auth/" + s)) continue;
            return true;
        }
        return false;
    }

    public boolean canUserAccessResource(String resourceUri) {
        ArrayList<String> personalAccess = RdfAuthModel.getPersonalAccess("http://purl.bdrc.io/resource-nc/auth/" + this.user.getUser().getUserId());
        if (personalAccess != null) {
            return personalAccess.contains(resourceUri);
        }
        return false;
    }

    public boolean matchGroup() {
        boolean match = false;
        for (String gp : this.user.getGroups()) {
            if (!this.endpoint.getGroups().contains(gp)) continue;
            return true;
        }
        return match;
    }

    public boolean matchRole() {
        boolean match = false;
        for (String r : this.user.getRoles()) {
            if (!this.endpoint.getRoles().contains(r)) continue;
            return true;
        }
        return match;
    }

    public boolean matchPermissions() {
        boolean match = false;
        for (String pm : this.user.getPermissions()) {
            if (!this.endpoint.getPermissions().contains(pm)) continue;
            return true;
        }
        return match;
    }

    public boolean matchResourcePermissions(String accessTypeLocalName) {
        if ("AccessOpen".equals(accessTypeLocalName)) {
            return true;
        }
        ResourceAccess access = RdfAuthModel.getResourceAccess(accessTypeLocalName);
        if (access != null) {
            for (String pm : this.user.getPermissions()) {
                if (!access.getPermission().equals(pm)) continue;
                return true;
            }
        }
        return false;
    }

    public User getUser() {
        return this.user.getUser();
    }

    public String toString() {
        return "Access [user=" + this.user + ", endpoint=" + this.endpoint + "]";
    }

    public static enum AccessLevel {
        OPEN,
        FAIR_USE,
        MIXED,
        NOACCESS;

    }
}

