/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.rdf;

import io.bdrc.auth.AuthProps;
import io.bdrc.auth.model.Application;
import io.bdrc.auth.model.AuthDataModelBuilder;
import io.bdrc.auth.model.Endpoint;
import io.bdrc.auth.model.Group;
import io.bdrc.auth.model.Permission;
import io.bdrc.auth.model.ResourceAccess;
import io.bdrc.auth.model.Role;
import io.bdrc.auth.model.User;
import io.bdrc.auth.rdf.ModelUpdate;
import io.bdrc.auth.rdf.RdfConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.jena.query.DatasetAccessor;
import org.apache.jena.query.DatasetAccessorFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfAuthModel
implements Runnable {
    static Model authMod;
    static HashMap<String, User> users;
    static HashMap<String, Group> groups;
    static HashMap<String, Role> roles;
    static ArrayList<Permission> permissions;
    static ArrayList<Endpoint> endpoints;
    static ArrayList<ResourceAccess> access;
    static ArrayList<Application> applications;
    static HashMap<String, ArrayList<String>> paths;
    static Long updated;
    private static int PERIOD_MS;
    private static final int DELAY_MS = 5000;
    public static final Logger log;

    public static void init() {
        RdfAuthModel.readAuthModel();
        ModelUpdate task = new ModelUpdate();
        Timer timer = new Timer();
        PERIOD_MS = Integer.parseInt(AuthProps.getProperty("updatePeriod"));
        timer.schedule((TimerTask)task, 5000L, (long)PERIOD_MS);
    }

    public static void initForTest(boolean update, boolean isTest) {
        if (update) {
            RdfAuthModel.updateAuthData(null);
        } else {
            RdfAuthModel.readAuthModel();
        }
    }

    public static void initForStaticTests() {
        InputStream stream = Application.class.getClassLoader().getResourceAsStream("rdfAuthTestModel.ttl");
        Model m = ModelFactory.createDefaultModel();
        m.read(stream, "", "TURTLE");
        RdfAuthModel.resetModel(m);
    }

    public static Long getUpdated() {
        return updated;
    }

    public static void update(long updatedTime) {
        updated = updatedTime;
    }

    public static Model getFullModel() {
        return authMod;
    }

    public static boolean isSecuredEndpoint(String appId, String path) {
        ArrayList<String> pth = paths.get(appId);
        if (pth != null) {
            return pth.contains(path);
        }
        return false;
    }

    public static HashMap<String, User> getUsers() {
        if (users != null) {
            return users;
        }
        users = new HashMap();
        ResIterator it = authMod.listResourcesWithProperty(RDF.type, (RDFNode)RdfConstants.USER);
        while (it.hasNext()) {
            Statement st;
            Resource rs = (Resource)it.next();
            User user = new User();
            user.setAuthId(rs.getProperty(RdfConstants.AUTHID).getObject().toString());
            user.setName(rs.getProperty(FOAF.name).getObject().toString());
            user.setEmail(rs.getProperty(FOAF.mbox).getObject().toString());
            user.setIsSocial(rs.getProperty(RdfConstants.IS_SOCIAL).getObject().toString());
            String userId = rs.getURI();
            user.setUserId(RdfAuthModel.getShortName(userId));
            user.setProvider(rs.getProperty(RdfConstants.PROVIDER).getObject().toString());
            user.setConnection(rs.getProperty(RdfConstants.CONNECTION).getObject().toString());
            StmtIterator sit = rs.listProperties(RdfConstants.HAS_ROLE);
            while (sit.hasNext()) {
                st = (Statement)sit.next();
                String role = st.getObject().toString();
                user.getRoles().add(RdfAuthModel.getShortName(role));
            }
            sit = rs.listProperties(RdfConstants.FOR_GROUP);
            while (sit.hasNext()) {
                st = (Statement)sit.next();
                String gp = st.getObject().toString();
                user.getGroups().add(RdfAuthModel.getShortName(gp));
            }
            users.put(RdfAuthModel.getShortName(userId), user);
        }
        return users;
    }

    public static HashMap<String, Group> getGroups() {
        if (groups != null) {
            return groups;
        }
        groups = new HashMap();
        ResIterator it = authMod.listResourcesWithProperty(RDF.type, (RDFNode)RdfConstants.GROUP);
        while (it.hasNext()) {
            Group gp = new Group();
            Resource rs = (Resource)it.next();
            StmtIterator sit = rs.listProperties(RdfConstants.HAS_MEMBER);
            while (sit.hasNext()) {
                String member = ((Statement)sit.next()).getObject().toString();
                gp.getMembers().add(RdfAuthModel.getShortName(member));
            }
            sit = rs.listProperties(RdfConstants.HAS_ROLE);
            while (sit.hasNext()) {
                String role = ((Statement)sit.next()).getObject().toString();
                gp.getRoles().add(RdfAuthModel.getShortName(role));
            }
            gp.setId(RdfAuthModel.getShortName(rs.getURI()));
            gp.setName(rs.getProperty(RDFS.label).getObject().toString());
            gp.setDesc(rs.getProperty(RdfConstants.DESC).getObject().toString());
            groups.put(RdfAuthModel.getShortName(rs.getURI()), gp);
        }
        return groups;
    }

    public static HashMap<String, Role> getRoles() {
        if (roles != null) {
            return roles;
        }
        roles = new HashMap();
        ResIterator it = authMod.listResourcesWithProperty(RDF.type, (RDFNode)RdfConstants.ROLE);
        while (it.hasNext()) {
            Role role = new Role();
            Resource rs = (Resource)it.next();
            StmtIterator sit = rs.listProperties(RdfConstants.HAS_PERMISSION);
            while (sit.hasNext()) {
                role.getPermissions().add(RdfAuthModel.getShortName(((Statement)sit.next()).getObject().toString()));
            }
            role.setId(RdfAuthModel.getShortName(rs.getURI()));
            role.setName(rs.getProperty(RDFS.label).getObject().toString());
            role.setDesc(rs.getProperty(RdfConstants.DESC).getObject().toString());
            String appId = rs.getProperty(RdfConstants.APPID).getObject().toString();
            role.setAppId(RdfAuthModel.getShortName(appId));
            role.setAppType(rs.getProperty(RdfConstants.APPTYPE).getObject().toString());
            roles.put(RdfAuthModel.getShortName(rs.getURI()), role);
        }
        return roles;
    }

    public static ArrayList<Permission> getPermissions() {
        if (permissions != null) {
            return permissions;
        }
        permissions = new ArrayList();
        ResIterator it = authMod.listResourcesWithProperty(RDF.type, (RDFNode)RdfConstants.PERMISSION);
        while (it.hasNext()) {
            Permission perm = new Permission();
            Resource rs = (Resource)it.next();
            perm.setId(RdfAuthModel.getShortName(rs.getURI()));
            perm.setName(rs.getProperty(RDFS.label).getObject().toString());
            perm.setDesc(rs.getProperty(RdfConstants.DESC).getObject().toString());
            String appId = rs.getProperty(RdfConstants.APPID).getObject().toString();
            perm.setAppId(RdfAuthModel.getShortName(appId));
            permissions.add(perm);
        }
        return permissions;
    }

    public static ArrayList<String> getPermissions(ArrayList<String> rls, ArrayList<String> gps) {
        ArrayList<String> perm = new ArrayList<String>();
        for (String rl : rls) {
            Role role = roles.get(rl);
            if (role == null) continue;
            for (String p : role.getPermissions()) {
                perm.add(p);
            }
        }
        for (String rl : rls) {
            Group gp = groups.get(rl);
            if (gp == null) continue;
            for (String p : gp.getRoles()) {
                Role role = roles.get(p);
                if (role == null) continue;
                for (String pp : role.getPermissions()) {
                    perm.add(pp);
                }
            }
        }
        return perm;
    }

    public static ArrayList<Endpoint> getEndpoints() {
        if (endpoints != null) {
            return endpoints;
        }
        endpoints = new ArrayList();
        paths = new HashMap();
        ResIterator it = authMod.listResourcesWithProperty(RDF.type, (RDFNode)RdfConstants.ENDPOINT);
        while (it.hasNext()) {
            Endpoint endp = new Endpoint();
            Resource rs = (Resource)it.next();
            StmtIterator sit = rs.listProperties(RdfConstants.FOR_GROUP);
            while (sit.hasNext()) {
                endp.getGroups().add(RdfAuthModel.getShortName(((Statement)sit.next()).getObject().toString()));
            }
            sit = rs.listProperties(RdfConstants.FOR_ROLE);
            while (sit.hasNext()) {
                String role = ((Statement)sit.next()).getObject().toString();
                endp.getRoles().add(role.substring(role.lastIndexOf("/") + 1));
            }
            sit = rs.listProperties(RdfConstants.FOR_PERM);
            while (sit.hasNext()) {
                endp.getPermissions().add(RdfAuthModel.getShortName(((Statement)sit.next()).getObject().toString()));
            }
            endp.setPath(rs.getProperty(RdfConstants.PATH).getObject().toString());
            String appId = rs.getProperty(RdfConstants.APPID).getObject().toString();
            endp.setAppId(RdfAuthModel.getShortName(appId));
            endpoints.add(endp);
            ArrayList<String> path = paths.get(endp.getAppId());
            if (path == null) {
                path = new ArrayList();
            }
            path.add(endp.getPath());
            paths.put(endp.getAppId(), path);
        }
        return endpoints;
    }

    public static ArrayList<ResourceAccess> getResourceAccess() {
        if (access != null) {
            return access;
        }
        access = new ArrayList();
        ResIterator it = authMod.listResourcesWithProperty(RDF.type, (RDFNode)RdfConstants.RES_ACCESS);
        while (it.hasNext()) {
            ResourceAccess acc = new ResourceAccess();
            Resource rs = (Resource)it.next();
            acc.setPermission(rs.getProperty(RdfConstants.FOR_PERM).getObject().toString());
            acc.setPolicy(rs.getProperty(RdfConstants.POLICY).getObject().toString());
            access.add(acc);
        }
        return access;
    }

    public static ArrayList<Application> getApplications() {
        if (applications != null) {
            return applications;
        }
        applications = new ArrayList();
        ResIterator it = authMod.listResourcesWithProperty(RDF.type, (RDFNode)RdfConstants.APPLICATION);
        while (it.hasNext()) {
            Resource rs = (Resource)it.next();
            Application app = new Application();
            app.setName(rs.getProperty(RDFS.label).getObject().toString());
            app.setAppId(RdfAuthModel.getShortName(rs.getURI()));
            app.setAppType(rs.getProperty(RdfConstants.APPTYPE).getObject().toString());
            app.setDesc(rs.getProperty(RdfConstants.DESC).getObject().toString());
            applications.add(app);
        }
        return applications;
    }

    public static User getUser(String userId) {
        return users.get(userId);
    }

    public static HashMap<String, ArrayList<String>> getPaths() {
        return paths;
    }

    public static Endpoint getEndpoint(String path) {
        for (Endpoint e : endpoints) {
            if (!e.getPath().equals(path)) continue;
            return e;
        }
        return null;
    }

    public static ResourceAccess getResourceAccess(String accessType) {
        for (ResourceAccess acc : access) {
            String policy = acc.getPolicy();
            if (!policy.equals(accessType)) continue;
            return acc;
        }
        return null;
    }

    public static void readAuthModel() {
        String fusekiUrl = AuthProps.getProperty("fusekiUrl");
        DatasetAccessor access = DatasetAccessorFactory.createHTTP((String)(fusekiUrl = fusekiUrl.substring(0, fusekiUrl.lastIndexOf("/"))));
        Model m = access.getModel(AuthProps.getProperty("authDataGraph"));
        if (m != null) {
            RdfAuthModel.resetModel(m);
            RdfAuthModel.update(System.currentTimeMillis());
        }
    }

    static void resetModel(Model m) {
        authMod = m;
        RdfAuthModel.getUsers();
        RdfAuthModel.getGroups();
        RdfAuthModel.getRoles();
        RdfAuthModel.getPermissions();
        RdfAuthModel.getEndpoints();
        RdfAuthModel.getApplications();
        RdfAuthModel.getResourceAccess();
        RdfAuthModel.update(System.currentTimeMillis());
    }

    public static void updateAuthData(String fusekiUrl) {
        if (fusekiUrl == null) {
            fusekiUrl = AuthProps.getProperty("fusekiUrl");
        }
        fusekiUrl = fusekiUrl.substring(0, fusekiUrl.lastIndexOf("/"));
        log.info("Service fuseki >> " + fusekiUrl);
        log.info("authDataGraph >> " + AuthProps.getProperty("authDataGraph"));
        DatasetAccessor access = DatasetAccessorFactory.createHTTP((String)fusekiUrl);
        try {
            AuthDataModelBuilder auth = new AuthDataModelBuilder();
            access.putModel(AuthProps.getProperty("authDataGraph"), auth.getModel());
            RdfAuthModel.resetModel(auth.getModel());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getShortName(String st) {
        return st.substring(st.lastIndexOf("/") + 1);
    }

    @Override
    public void run() {
        try {
            RdfAuthModel.updateAuthData(null);
        }
        catch (Exception e) {
            log.error("Running error", (Throwable)e);
        }
        log.info("Done loading and updating rdfAuth Model");
    }

    static {
        updated = null;
        log = LoggerFactory.getLogger((String)RdfAuthModel.class.getName());
    }
}

