/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.bdrc.auth.rdf.RdfConstants;
import java.util.ArrayList;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.RDF;

public class User {
    String userId;
    String authId;
    String name;
    String email;
    String isSocial;
    String provider;
    String connection;
    ArrayList<String> roles;
    ArrayList<String> groups;
    Model model;

    public User(JsonNode json, ArrayList<String> roles) throws JsonProcessingException {
        this.authId = this.getJsonValue(json, "user_id");
        this.name = this.getJsonValue(json, "name");
        this.email = this.getJsonValue(json, "email");
        this.roles = roles;
        this.groups = new ArrayList();
        JsonNode ids = json.findValue("identities");
        if (ids != null) {
            this.isSocial = this.getJsonValue(ids, "isSocial");
            this.userId = this.getJsonValue(ids, "user_id");
            this.provider = this.getJsonValue(ids, "provider");
            this.connection = this.getJsonValue(ids, "connection");
        }
        this.model = this.buildModel();
    }

    public User() {
        this.authId = "";
        this.name = "";
        this.email = "";
        this.isSocial = "";
        this.userId = "";
        this.provider = "";
        this.connection = "";
        this.roles = new ArrayList();
        this.groups = new ArrayList();
        this.model = null;
    }

    Model buildModel() {
        Resource usr = ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-auth/" + this.userId));
        Model res = ModelFactory.createDefaultModel();
        res.add(usr, RDF.type, (RDFNode)RdfConstants.USER);
        res.add(usr, RdfConstants.IS_SOCIAL, (RDFNode)ResourceFactory.createStringLiteral((String)this.isSocial));
        res.add(usr, RdfConstants.PROVIDER, (RDFNode)ResourceFactory.createStringLiteral((String)this.provider));
        res.add(usr, RdfConstants.CONNECTION, (RDFNode)ResourceFactory.createStringLiteral((String)this.connection));
        res.add(usr, FOAF.name, (RDFNode)ResourceFactory.createStringLiteral((String)this.name));
        res.add(usr, RdfConstants.AUTHID, (RDFNode)ResourceFactory.createStringLiteral((String)this.authId));
        res.add(usr, FOAF.mbox, (RDFNode)ResourceFactory.createStringLiteral((String)this.email));
        for (String role : this.roles) {
            res.add(usr, RdfConstants.HAS_ROLE, (RDFNode)ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-auth/" + role)));
        }
        return res;
    }

    String getJsonValue(JsonNode json, String key) {
        JsonNode tmp = json.findValue(key);
        if (tmp != null) {
            return tmp.asText();
        }
        return "";
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setAuthId(String authId) {
        this.authId = authId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setIsSocial(String isSocial) {
        this.isSocial = isSocial;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public ArrayList<String> getRoles() {
        return this.roles;
    }

    public ArrayList<String> getGroups() {
        return this.groups;
    }

    public String getIsSocial() {
        return this.isSocial;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getConnection() {
        return this.connection;
    }

    public Model getModel() {
        return this.model;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAuthId() {
        return this.authId;
    }

    public String toString() {
        return "User [userId=" + this.userId + ", authId=" + this.authId + ", name=" + this.name + ", email=" + this.email + ", isSocial=" + this.isSocial + ", provider=" + this.provider + ", connection=" + this.connection + ", roles=" + this.roles + ", groups=" + this.groups + ", model=" + this.model + "]";
    }
}

