/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.model;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.util.iterator.ExtendedIterator;

public class ResourceAccess {
    String policy;
    String permission;

    public ResourceAccess(Model model, String resourceId) {
        Triple t = new Triple(NodeFactory.createURI((String)resourceId), Node.ANY, Node.ANY);
        ExtendedIterator ext = model.getGraph().find(t);
        while (ext.hasNext()) {
            String prop;
            Triple tmp = (Triple)ext.next();
            String value = tmp.getObject().toString().replaceAll("\"", "");
            switch (prop = tmp.getPredicate().getURI()) {
                case "http://purl.bdrc.io/ontology/ext/auth/forPermission": {
                    this.permission = this.getShortName(value);
                    break;
                }
                case "http://purl.bdrc.io/ontology/ext/auth/policy": {
                    this.policy = this.getShortName(value);
                }
            }
        }
    }

    public ResourceAccess() {
        this.policy = "";
        this.permission = "";
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = this.getShortName(policy);
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = this.getShortName(permission);
    }

    public String toString() {
        return "ResourceAccess [policy=" + this.policy + ", permission=" + this.permission + "]";
    }

    public String getShortName(String st) {
        return st.substring(st.lastIndexOf("/") + 1);
    }
}

