/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.bdrc.auth.rdf.RdfConstants;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class Permission {
    String id;
    String appId;
    String name;
    String desc;
    Model model;

    public Permission(JsonNode json) throws JsonProcessingException {
        this.id = this.getJsonValue(json, "_id");
        this.name = this.getJsonValue(json, "name");
        this.desc = this.getJsonValue(json, "description");
        this.appId = this.getJsonValue(json, "applicationId");
        this.model = this.buildModel();
    }

    public Permission() {
        this.id = "";
        this.name = "";
        this.desc = "";
        this.appId = "";
    }

    String getJsonValue(JsonNode json, String key) {
        JsonNode tmp = json.findValue(key);
        if (tmp != null) {
            return tmp.asText();
        }
        return "";
    }

    Model buildModel() {
        Resource perm = ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-auth/" + this.id));
        Model res = ModelFactory.createDefaultModel();
        res.add(perm, RDF.type, (RDFNode)RdfConstants.PERMISSION);
        res.add(perm, RDFS.label, (RDFNode)ResourceFactory.createStringLiteral((String)this.name));
        res.add(perm, RdfConstants.DESC, (RDFNode)ResourceFactory.createStringLiteral((String)this.desc));
        res.add(perm, RdfConstants.APPID, (RDFNode)ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-auth/" + this.appId)));
        return res;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Model getModel() {
        return this.model;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String toString() {
        return "Permission [id=" + this.id + ", appId=" + this.appId + ", name=" + this.name + ", desc=" + this.desc + ", model=" + this.model + "]";
    }
}

