/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.bdrc.auth.rdf.RdfConstants;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class Application {
    String appType;
    String appId;
    String name;
    String desc;
    Model model;

    public Application(JsonNode json) throws JsonProcessingException {
        this.name = this.getJsonValue(json, "name");
        this.desc = this.getJsonValue(json, "description");
        this.appType = this.getJsonValue(json, "app_type");
        this.appId = this.getJsonValue(json, "client_id");
        this.model = this.buildModel();
    }

    public Application() {
        this.name = "";
        this.desc = "";
        this.appType = "";
        this.appId = "";
    }

    Model buildModel() {
        Resource app = ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-auth/" + this.appId));
        Model res = ModelFactory.createDefaultModel();
        res.add(app, RDF.type, (RDFNode)RdfConstants.APPLICATION);
        res.add(app, RDFS.label, (RDFNode)ResourceFactory.createStringLiteral((String)this.name));
        res.add(app, RdfConstants.APPTYPE, (RDFNode)ResourceFactory.createStringLiteral((String)this.appType));
        res.add(app, RdfConstants.DESC, (RDFNode)ResourceFactory.createStringLiteral((String)this.desc));
        return res;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getAppType() {
        return this.appType;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Model getModel() {
        return this.model;
    }

    String getJsonValue(JsonNode json, String key) {
        JsonNode tmp = json.findValue(key);
        if (tmp != null) {
            return tmp.asText();
        }
        return "";
    }

    public String toString() {
        return "Application [appType=" + this.appType + ", appId=" + this.appId + ", name=" + this.name + ", desc=" + this.desc + ", model=" + this.model + "]";
    }
}

