/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth;

import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.bdrc.auth.BdrcJwks;
import io.bdrc.auth.UserProfile;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenValidation {
    public static final Logger log = LoggerFactory.getLogger((String)TokenValidation.class.getName());
    DecodedJWT decodedJwt;
    List<String> scopes;
    UserProfile user;
    final String tokenStr;
    boolean valid;

    public TokenValidation(String tokenStr) {
        this.tokenStr = tokenStr;
        try {
            this.valid = this.checkTokenSignature();
            this.setScopes();
            this.user = new UserProfile(this.decodedJwt);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage());
        }
    }

    void setScopes() {
        Claim cl = (Claim)this.decodedJwt.getClaims().get("scope");
        this.scopes = cl != null ? Arrays.asList(cl.asString().split(" ")) : Arrays.asList("".split(" "));
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isValidScope(String scope) {
        return this.scopes.contains(scope);
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public UserProfile getUser() {
        return this.user;
    }

    public String getKeyId() {
        return this.decodedJwt.getKeyId();
    }

    public String getSubject() {
        return this.decodedJwt.getSubject();
    }

    public String getAlgorithm() {
        return this.decodedJwt.getAlgorithm();
    }

    public String getSignature() {
        return this.decodedJwt.getSignature();
    }

    public List<String> getAudience() {
        return this.decodedJwt.getAudience();
    }

    public boolean checkTokenSignature() {
        try {
            JWTVerifier verifier = BdrcJwks.verifier;
            this.decodedJwt = verifier.verify(this.tokenStr);
            return true;
        }
        catch (JWTVerificationException e) {
            log.error("invalid token signature or outdated token");
            return false;
        }
    }

    public boolean validateTokenExpiration() {
        Calendar cal = Calendar.getInstance();
        return this.decodedJwt.getExpiresAt().after(cal.getTime());
    }

    public DecodedJWT getVerifiedJwt() {
        return this.decodedJwt;
    }

    public String toString() {
        return "TokenValidation [decodedJwt=" + this.decodedJwt + ", scopes=" + this.scopes + ", user=" + this.user + ", token=" + this.tokenStr + ", valid=" + this.valid + "]";
    }
}

