/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.bdrc.auth.AuthProps;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Properties;

public class TestTokenBuilder {
    public static String createTestToken() throws IOException {
        FileInputStream is = new FileInputStream("/etc/buda/iiifserv/iiifservTest.properties");
        Properties props = new Properties();
        props.load(is);
        AuthProps.init(props);
        String token = null;
        try {
            Calendar cal = Calendar.getInstance();
            cal.set(2025, 0, 1);
            Algorithm algorithm = Algorithm.HMAC256((String)"secret");
            token = JWT.create().withIssuer(AuthProps.getProperty("issuer")).withAudience(new String[]{AuthProps.getProperty("audience")}).withClaim("sub", "auth0|5be992d9d7ece87f159c8bed").withClaim("azp", "G0AjmCKspNngJsTtRnHaAUCD44ZxwoMJ").withExpiresAt(cal.getTime()).sign(algorithm);
        }
        catch (JWTCreationException jWTCreationException) {
            // empty catch block
        }
        return token;
    }

    public static void decode(String token) {
        JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)"secret")).build();
        DecodedJWT jwt = verifier.verify(token);
        System.out.println(jwt.getClaim("sub").asString());
    }

    public static void main(String[] args) throws IOException {
        String token = TestTokenBuilder.createTestToken();
        System.out.println(token);
        TestTokenBuilder.decode(token);
    }
}

