/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;

public class User {
    String id;
    String authId;
    String name;
    String email;
    String asJson;
    String isSocial;
    String provider;
    String connection;
    ArrayList<String> roles;
    ArrayList<String> groups;
    Model model;

    public User(JsonNode json, ArrayList<String> roles) throws JsonProcessingException {
        this.authId = this.getJsonValue(json, "user_id");
        this.name = this.getJsonValue(json, "name");
        this.email = this.getJsonValue(json, "email");
        this.roles = roles;
        this.groups = new ArrayList();
        JsonNode ids = json.findValue("identities");
        if (ids != null) {
            this.isSocial = this.getJsonValue(ids, "isSocial");
            this.id = this.getJsonValue(ids, "user_id");
            this.provider = this.getJsonValue(ids, "provider");
            this.connection = this.getJsonValue(ids, "connection");
        }
        ObjectMapper mapper = new ObjectMapper();
        this.asJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
        this.model = this.buildModel();
    }

    public User() {
        this.authId = "";
        this.name = "";
        this.email = "";
        this.isSocial = "";
        this.id = "";
        this.provider = "";
        this.connection = "";
        this.asJson = "";
        this.roles = new ArrayList();
        this.groups = new ArrayList();
        this.model = null;
    }

    Model buildModel() {
        Resource usr = ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-auth/" + this.id));
        this.model = ModelFactory.createDefaultModel();
        this.model.getNsPrefixMap().put("foaf", "http://xmlns.com/foaf/0.1/");
        this.model.add(ResourceFactory.createStatement((Resource)usr, (Property)RDF.type, (RDFNode)ResourceFactory.createResource((String)"http://purl.bdrc.io/ontology/ext/auth/User")));
        this.model.add(ResourceFactory.createStatement((Resource)usr, (Property)ResourceFactory.createProperty((String)"http://purl.bdrc.io/ontology/ext/auth/isSocial"), (RDFNode)ResourceFactory.createPlainLiteral((String)this.isSocial)));
        this.model.add(ResourceFactory.createStatement((Resource)usr, (Property)ResourceFactory.createProperty((String)"http://purl.bdrc.io/ontology/ext/auth/provider"), (RDFNode)ResourceFactory.createPlainLiteral((String)this.provider)));
        this.model.add(ResourceFactory.createStatement((Resource)usr, (Property)ResourceFactory.createProperty((String)"http://purl.bdrc.io/ontology/ext/auth/connection"), (RDFNode)ResourceFactory.createPlainLiteral((String)this.connection)));
        this.model.add(ResourceFactory.createStatement((Resource)usr, (Property)ResourceFactory.createProperty((String)"http://xmlns.com/foaf/0.1/name"), (RDFNode)ResourceFactory.createPlainLiteral((String)this.name)));
        this.model.add(ResourceFactory.createStatement((Resource)usr, (Property)ResourceFactory.createProperty((String)"http://purl.bdrc.io/ontology/ext/auth/id"), (RDFNode)ResourceFactory.createPlainLiteral((String)this.authId)));
        this.model.add(ResourceFactory.createStatement((Resource)usr, (Property)ResourceFactory.createProperty((String)"http://xmlns.com/foaf/0.1/mbox"), (RDFNode)ResourceFactory.createPlainLiteral((String)this.email)));
        for (String role : this.roles) {
            this.model.add(ResourceFactory.createStatement((Resource)usr, (Property)ResourceFactory.createProperty((String)"http://purl.bdrc.io/ontology/ext/auth/hasRole"), (RDFNode)ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-auth/" + role))));
        }
        return this.model;
    }

    String getJsonValue(JsonNode json, String key) {
        JsonNode tmp = json.findValue(key);
        if (tmp != null) {
            return tmp.asText();
        }
        return "";
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAuthId(String authId) {
        this.authId = authId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setIsSocial(String isSocial) {
        this.isSocial = isSocial;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public ArrayList<String> getRoles() {
        return this.roles;
    }

    public ArrayList<String> getGroups() {
        return this.groups;
    }

    public String getIsSocial() {
        return this.isSocial;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getConnection() {
        return this.connection;
    }

    public Model getModel() {
        return this.model;
    }

    public String getAsJson() {
        return this.asJson;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAuthId() {
        return this.authId;
    }

    public String toString() {
        return "User [id=" + this.id + ", authId=" + this.authId + ", name=" + this.name + ", email=" + this.email + ", asJson=" + this.asJson + ", isSocial=" + this.isSocial + ", provider=" + this.provider + ", connection=" + this.connection + ", roles=" + this.roles + ", groups=" + this.groups + ", model=" + this.model + "]";
    }
}

