/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class Role {
    String id;
    String appType;
    String appId;
    String name;
    String desc;
    ArrayList<String> permissions;
    String asJson;
    Model model;

    public Role(JsonNode json) throws JsonProcessingException {
        this.id = this.getJsonValue(json, "_id");
        this.name = this.getJsonValue(json, "name");
        this.desc = this.getJsonValue(json, "description");
        this.appType = this.getJsonValue(json, "applicationType");
        this.appId = this.getJsonValue(json, "applicationId");
        this.permissions = new ArrayList();
        ArrayNode array = (ArrayNode)json.findValue("permissions");
        if (array != null) {
            Iterator it = array.iterator();
            while (it.hasNext()) {
                this.permissions.add(((JsonNode)it.next()).asText());
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        this.asJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
        this.model = this.buildModel();
    }

    public Role() {
        this.id = "";
        this.name = "";
        this.desc = "";
        this.appType = "";
        this.appId = "";
        this.permissions = new ArrayList();
    }

    String getJsonValue(JsonNode json, String key) {
        JsonNode tmp = json.findValue(key);
        if (tmp != null) {
            return tmp.asText();
        }
        return "";
    }

    Model buildModel() {
        Resource role = ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-auth/" + this.id));
        this.model = ModelFactory.createDefaultModel();
        this.model.add(ResourceFactory.createStatement((Resource)role, (Property)RDF.type, (RDFNode)ResourceFactory.createResource((String)"http://purl.bdrc.io/ontology/ext/auth/Role")));
        this.model.add(ResourceFactory.createStatement((Resource)role, (Property)RDFS.label, (RDFNode)ResourceFactory.createPlainLiteral((String)this.name)));
        this.model.add(ResourceFactory.createStatement((Resource)role, (Property)ResourceFactory.createProperty((String)"http://purl.bdrc.io/ontology/ext/auth/desc"), (RDFNode)ResourceFactory.createPlainLiteral((String)this.desc)));
        this.model.add(ResourceFactory.createStatement((Resource)role, (Property)ResourceFactory.createProperty((String)"http://purl.bdrc.io/ontology/ext/auth/appType"), (RDFNode)ResourceFactory.createPlainLiteral((String)this.appType)));
        this.model.add(ResourceFactory.createStatement((Resource)role, (Property)ResourceFactory.createProperty((String)"http://purl.bdrc.io/ontology/ext/auth/appId"), (RDFNode)ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-auth/" + this.appId))));
        for (String perm : this.permissions) {
            this.model.add(ResourceFactory.createStatement((Resource)role, (Property)ResourceFactory.createProperty((String)"http://purl.bdrc.io/ontology/ext/auth/hasPermission"), (RDFNode)ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-auth/" + perm))));
        }
        return this.model;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setPermissions(ArrayList<String> permissions) {
        this.permissions = permissions;
    }

    public Model getModel() {
        return this.model;
    }

    public String getAsJson() {
        return this.asJson;
    }

    public String getId() {
        return this.id;
    }

    public String getAppType() {
        return this.appType;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public ArrayList<String> getPermissions() {
        return this.permissions;
    }

    public String toString() {
        return "Role [id=" + this.id + ", appType=" + this.appType + ", appId=" + this.appId + ", name=" + this.name + ", desc=" + this.desc + ", permissions=" + this.permissions + ", asJson=" + this.asJson + ", model=" + this.model + "]";
    }
}

