/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class Application {
    String appType;
    String appId;
    String name;
    String desc;
    String asJson;
    Model model;

    public Application(JsonNode json) throws JsonProcessingException {
        this.name = this.getJsonValue(json, "name");
        this.desc = this.getJsonValue(json, "description");
        this.appType = this.getJsonValue(json, "app_type");
        this.appId = this.getJsonValue(json, "client_id");
        ObjectMapper mapper = new ObjectMapper();
        this.asJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
        this.model = this.buildModel();
    }

    public Application() {
        this.name = "";
        this.desc = "";
        this.appType = "";
        this.appId = "";
    }

    Model buildModel() {
        Resource app = ResourceFactory.createResource((String)("http://purl.bdrc.io/resource-auth/" + this.appId));
        this.model = ModelFactory.createDefaultModel();
        this.model.add(ResourceFactory.createStatement((Resource)app, (Property)RDF.type, (RDFNode)ResourceFactory.createResource((String)"http://purl.bdrc.io/ontology/ext/auth/Application")));
        this.model.add(ResourceFactory.createStatement((Resource)app, (Property)RDFS.label, (RDFNode)ResourceFactory.createPlainLiteral((String)this.name)));
        this.model.add(ResourceFactory.createStatement((Resource)app, (Property)ResourceFactory.createProperty((String)"http://purl.bdrc.io/ontology/ext/auth/appType"), (RDFNode)ResourceFactory.createPlainLiteral((String)this.appType)));
        this.model.add(ResourceFactory.createStatement((Resource)app, (Property)ResourceFactory.createProperty((String)"http://purl.bdrc.io/ontology/ext/auth/desc"), (RDFNode)ResourceFactory.createPlainLiteral((String)this.desc)));
        return this.model;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getAppType() {
        return this.appType;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getAsJson() {
        return this.asJson;
    }

    public Model getModel() {
        return this.model;
    }

    String getJsonValue(JsonNode json, String key) {
        JsonNode tmp = json.findValue(key);
        if (tmp != null) {
            return tmp.asText();
        }
        return "";
    }

    public String toString() {
        return "Application [appType=" + this.appType + ", appId=" + this.appId + ", name=" + this.name + ", desc=" + this.desc + ", asJson=" + this.asJson + ", model=" + this.model + "]";
    }
}

