/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth;

import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.bdrc.auth.model.User;
import io.bdrc.auth.rdf.RdfAuthModel;
import java.util.ArrayList;

public class UserProfile {
    ArrayList<String> groups;
    ArrayList<String> roles;
    ArrayList<String> permissions;
    String name;

    public UserProfile(DecodedJWT decodedJwt) {
        String id = this.getId(decodedJwt);
        User user = RdfAuthModel.getUser(id);
        if (user != null) {
            this.groups = RdfAuthModel.getUser(id).getGroups();
            this.roles = RdfAuthModel.getUser(id).getRoles();
            this.permissions = RdfAuthModel.getPermissions(this.roles, this.groups);
            this.name = user.getName();
        } else {
            this.groups = new ArrayList();
            this.roles = new ArrayList();
            this.permissions = new ArrayList();
            this.name = "";
        }
    }

    public UserProfile() {
        this.groups = new ArrayList();
        this.roles = new ArrayList();
        this.permissions = new ArrayList();
        this.name = "";
    }

    public ArrayList<String> getGroups() {
        return this.groups;
    }

    public ArrayList<String> getRoles() {
        return this.roles;
    }

    String getName(DecodedJWT decodedJwt) {
        Claim claim = (Claim)decodedJwt.getClaims().get("name");
        if (claim != null) {
            return claim.asString();
        }
        return null;
    }

    String getId(DecodedJWT decodedJwt) {
        String id;
        Claim claim = (Claim)decodedJwt.getClaims().get("sub");
        if (claim != null && !(id = claim.asString()).endsWith("@clients")) {
            return id.substring(id.indexOf("|") + 1);
        }
        return "";
    }

    public ArrayList<String> getPermissions() {
        return this.permissions;
    }

    public boolean isInGroup(String group) {
        return this.groups.contains(group);
    }

    public boolean hasRole(String role) {
        return this.roles.contains(role);
    }

    public boolean hasPermission(String permission) {
        return this.permissions.contains(permission);
    }

    public String toString() {
        return "User [groups=" + this.groups + ", roles=" + this.roles + ", permissions=" + this.permissions + ", name=" + this.name + "]";
    }
}

