/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.bdrc.auth.BdrcJwks;
import io.bdrc.auth.UserProfile;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenValidation {
    public static final Logger log = LoggerFactory.getLogger((String)TokenValidation.class.getName());
    DecodedJWT decodedJwt;
    List<String> scopes;
    UserProfile user;
    String token;
    boolean valid;

    public TokenValidation(String token) {
        this.token = token;
        try {
            this.valid = this.checkTokenValidity() & this.checkTokenSignature() & this.validateTokenKeyId();
            this.setScopes();
            this.user = new UserProfile(this.decodedJwt);
        }
        catch (IOException | IllegalArgumentException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            log.error(e.getMessage());
        }
    }

    void setScopes() {
        Claim cl = (Claim)this.decodedJwt.getClaims().get("scope");
        this.scopes = cl != null ? Arrays.asList(cl.asString().split(" ")) : Arrays.asList("".split(" "));
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isValidScope(String scope) {
        return this.scopes.contains(scope);
    }

    public boolean checkTokenValidity() {
        try {
            this.decodedJwt = JWT.decode((String)this.token);
            return true;
        }
        catch (JWTDecodeException e) {
            return false;
        }
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public UserProfile getUser() {
        return this.user;
    }

    public String getKeyId() {
        return this.decodedJwt.getKeyId();
    }

    public String getSubject() {
        return this.decodedJwt.getSubject();
    }

    public String getAlgorithm() {
        return this.decodedJwt.getAlgorithm();
    }

    public String getSignature() {
        return this.decodedJwt.getSignature();
    }

    public List<String> getAudience() {
        return this.decodedJwt.getAudience();
    }

    public boolean checkTokenSignature() throws IllegalArgumentException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        try {
            Algorithm algo = Algorithm.RSA256((RSAPublicKey)BdrcJwks.getPublicKey(), null);
            JWTVerifier verifier = JWT.require((Algorithm)algo).withIssuer(BdrcJwks.getProp("issuer")).withClaim("nbf", Long.valueOf(Calendar.getInstance().getTime().getTime())).build();
            this.decodedJwt = verifier.verify(this.token);
            return this.validateTokenKeyId();
        }
        catch (JWTVerificationException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean validateTokenExpiration() {
        Calendar cal = Calendar.getInstance();
        return this.decodedJwt.getExpiresAt().after(cal.getTime());
    }

    public boolean validateTokenIssuer() {
        return this.decodedJwt.getIssuer().equals("https://bdrc-io.auth0.com/");
    }

    public boolean validateTokenKeyId() {
        return this.decodedJwt.getKeyId().equals(BdrcJwks.getValue("kid"));
    }

    public DecodedJWT getVerifiedJwt() {
        return this.decodedJwt;
    }

    public String toString() {
        return "TokenValidation [decodedJwt=" + this.decodedJwt + ", scopes=" + this.scopes + ", user=" + this.user + ", token=" + this.token + ", valid=" + this.valid + "]";
    }
}

