/*
 * Decompiled with CFR 0.152.
 */
package io.bdrc.auth;

import io.bdrc.auth.UserProfile;
import io.bdrc.auth.model.Endpoint;
import io.bdrc.auth.model.ResourceAccess;
import io.bdrc.auth.rdf.RdfAuthModel;

public class Access {
    UserProfile user;
    Endpoint endpoint;

    public Access(UserProfile user, Endpoint endpoint) {
        this.user = user;
        this.endpoint = endpoint;
    }

    public Access() {
        this.user = new UserProfile();
        this.endpoint = new Endpoint();
    }

    public boolean hasEndpointAccess() {
        return this.matchGroup() || this.matchRole() || this.matchPermissions();
    }

    public boolean hasResourceAccess(String accessType) {
        if (accessType.equals("AccessOpen")) {
            return true;
        }
        return this.matchResourcePermissions(accessType);
    }

    public boolean matchGroup() {
        boolean match = false;
        for (String gp : this.user.getGroups()) {
            if (!this.endpoint.getGroups().contains(gp)) continue;
            return true;
        }
        return match;
    }

    public boolean matchRole() {
        boolean match = false;
        for (String r : this.user.getRoles()) {
            if (!this.endpoint.getRoles().contains(r)) continue;
            return true;
        }
        return match;
    }

    public boolean matchPermissions() {
        boolean match = false;
        for (String pm : this.user.getPermissions()) {
            if (!this.endpoint.getPermissions().contains(pm)) continue;
            return true;
        }
        return match;
    }

    public boolean matchResourcePermissions(String accessType) {
        if (accessType.equals("AccessOpen")) {
            return true;
        }
        boolean match = false;
        ResourceAccess access = RdfAuthModel.getResourceAccess(accessType);
        if (access != null) {
            for (String pm : this.user.getPermissions()) {
                if (!access.getPermission().equals(pm)) continue;
                return true;
            }
        }
        return match;
    }

    public String toString() {
        return "Access [user=" + this.user + ", endpoint=" + this.endpoint + "]";
    }
}

