package io.bdrc.auth.rdf;

/*******************************************************************************
 * Copyright (c) 2018 Buddhist Digital Resource Center (BDRC)
 * 
 * If this file is a derivation of another work the license header will appear below; 
 * otherwise, this work is licensed under the Apache License, Version 2.0 
 * (the "License"); you may not use this file except in compliance with the License.
 * 
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

public class RdfConstants {
    
    public static final String AUTH_RESOURCE="http://purl.bdrc.io/resource-auth/";
    public static final String APPLICATION="http://purl.bdrc.io/ontology/ext/auth/Application";
    public static final String PERMISSION="http://purl.bdrc.io/ontology/ext/auth/Permission";
    public static final String ROLE="http://purl.bdrc.io/ontology/ext/auth/Role";    
    public static final String GROUP="http://purl.bdrc.io/ontology/ext/auth/Group";
    public static final String USER="http://purl.bdrc.io/ontology/ext/auth/User";
    public static final String ENDPOINT="http://purl.bdrc.io/ontology/ext/auth/Endpoint";
    public static final String RES_ACCESS="http://purl.bdrc.io/ontology/ext/auth/ResourceAccess";
    
    public final static String APPID="http://purl.bdrc.io/ontology/ext/auth/appId";
    public final static String APPTYPE="http://purl.bdrc.io/ontology/ext/auth/appType";
    public final static String PATH="http://purl.bdrc.io/ontology/ext/auth/path";
    public final static String FOR_ROLE="http://purl.bdrc.io/ontology/ext/auth/forRole";
    public final static String FOR_GROUP="http://purl.bdrc.io/ontology/ext/auth/forGroup";
    public final static String FOR_PERM="http://purl.bdrc.io/ontology/ext/auth/forPermission";
    public final static String DESC="http://purl.bdrc.io/ontology/ext/auth/desc";
    public final static String HAS_MEMBER="http://purl.bdrc.io/ontology/ext/auth/hasMember";
    public final static String HAS_ROLE="http://purl.bdrc.io/ontology/ext/auth/hasRole";
    public final static String HAS_PERMISSION="http://purl.bdrc.io/ontology/ext/auth/hasPermission";
    public final static String IS_SOCIAL="http://purl.bdrc.io/ontology/ext/auth/isSocial";
    public final static String PROVIDER="http://purl.bdrc.io/ontology/ext/auth/provider";
    public final static String CONNECTION="http://purl.bdrc.io/ontology/ext/auth/connection";
    public final static String ID="http://purl.bdrc.io/ontology/ext/auth/id";
    public final static String POLICY="http://purl.bdrc.io/ontology/ext/auth/policy";
    
    public final static String FOAF_NAME="http://xmlns.com/foaf/0.1/name";
    public final static String FOAF_MBOX="http://xmlns.com/foaf/0.1/mbox";
    
    public static final String RESTRICTED_SEALED="AccessRestrictedSealed";
    public static final String RESTRICTED_CHINA="AccessRestrictedInChina";
    public static final String OPEN="AccessOpen";
    public static final String RESTRICTED_TEMP="AccessRestrictedTemporarily";
    public static final String RESTRICTED_BY_QUALITY="AccessRestrictedByQuality";
    public static final String MIXED="AccessMixed";
    public static final String RESTRICTED_BY_TBRC="AccessRestrictedByTbrc";
    public static final String FAIR_USE="AccessFairUse";

}
